/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.api.*;
import org.jvnet.substance.api.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.colorscheme.*;
import org.jvnet.substance.painter.border.ClassicInnerBorderPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.gradient.GlassGradientPainter;
import org.jvnet.substance.painter.highlight.GlassHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

/**
 * <code>Raven Graphite Glass</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.3
 */
public class RavenGraphiteGlassSkin extends SubstanceSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Raven Graphite Glass";

	/**
	 * Creates a new <code>Raven Graphite</code> skin.
	 */
	public RavenGraphiteGlassSkin() {
		SubstanceColorScheme activeScheme = new EbonyColorScheme().tint(0.2)
				.named("Raven Graphite Glass Active");
		SubstanceColorScheme defaultScheme = activeScheme.shade(0.2).named(
				"Raven Graphite Glass Default");
		SubstanceColorScheme disabledScheme = new ToneColorScheme(
				new EbonyColorScheme(), 0.35) {
			Color foreColor = new Color(32, 32, 32);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		}.named("Raven Graphite Glass Disabled");
		SubstanceColorScheme selectedDisabledScheme = new TintColorScheme(
				new EbonyColorScheme(), 0.2) {
			Color foreColor = new Color(32, 32, 32);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		}.named("Raven Graphite Glass Selected Disabled");
		SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(
				activeScheme, defaultScheme, disabledScheme);
		// register highlight alphas
		SubstanceColorScheme highlightScheme = new EbonyColorScheme();
		defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 0.4f,
				ComponentState.ROLLOVER_UNSELECTED);
		defaultSchemeBundle.registerHighlightColorScheme(highlightScheme,
				0.55f, ComponentState.SELECTED);
		defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 0.7f,
				ComponentState.ROLLOVER_SELECTED);
		defaultSchemeBundle.registerHighlightColorScheme(highlightScheme,
				0.65f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);

		// register schemes for disabled states
		defaultSchemeBundle.registerColorScheme(disabledScheme, 0.5f,
				ComponentState.DISABLED_UNSELECTED);
		defaultSchemeBundle.registerColorScheme(selectedDisabledScheme, 0.5f,
				ComponentState.DISABLED_SELECTED);

		this.registerDecorationAreaSchemeBundle(defaultSchemeBundle,
				DecorationAreaType.NONE);

		this.registerAsDecorationArea(defaultScheme,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.FOOTER,
				DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);

		setSelectedTabFadeStart(0.3);
		setSelectedTabFadeEnd(0.6);

		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceCrosshatchWatermark();
		this.gradientPainter = new GlassGradientPainter();
		this.decorationPainter = new ArcDecorationPainter();
		this.highlightPainter = new GlassHighlightPainter();
		this.borderPainter = new ClassicInnerBorderPainter(0.5f,
				ColorShiftKind.TONE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
