/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Insets;

import javax.swing.*;

import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;

/**
 * Spinner button in <b>Substance</b> look and feel.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceSpinnerButton extends JButton implements Sideable {
	static {
		FadeConfigurationManager.getInstance().disallowFades(
				FadeKind.GHOSTING_BUTTON_PRESS, SubstanceSpinnerButton.class);
		FadeConfigurationManager.getInstance().disallowFades(
				FadeKind.GHOSTING_ICON_ROLLOVER, SubstanceSpinnerButton.class);
	}

	/**
	 * Button orientation.
	 */
	private int orientation;

	/**
	 * Simple constructor.
	 * 
	 * @param spinner
	 * 		The owner spinner.
	 * @param orientation
	 * 		The orientation of the spinner icon arrow.
	 */
	public SubstanceSpinnerButton(JSpinner spinner, final int orientation) {
		// super(0, 0, false);
		super();
		// setModel(new DefaultButtonModel() {
		// @Override
		// public void setArmed(boolean armed) {
		// super.setArmed(isPressed() || armed);
		// }
		// });
		this.setEnabled(spinner.isEnabled());
		this.setFocusable(false);
		this.setRequestFocusEnabled(false);
		this.setMargin(new Insets(0, 0, 0, 2));
		this.setBorder(new SubstanceButtonBorder(ClassicButtonShaper.class) {
			public Insets getBorderInsets(Component c) {
				int extraPadding = SubstanceSizeUtils
						.getExtraPadding(SubstanceSizeUtils
								.getComponentFontSize(c));
				// Bring the icons closer together instead of
				// having them centered in the spinner buttons
				int deltaTop = (orientation == SwingConstants.NORTH) ? 2 : 0;
				int deltaBottom = (orientation == SwingConstants.NORTH) ? 0 : 2;
				return new Insets(extraPadding + deltaTop, extraPadding,
						extraPadding + deltaBottom, extraPadding);
			}
		});
		this.orientation = orientation;
		this.putClientProperty(SubstanceLookAndFeel.USE_THEMED_DEFAULT_ICONS,
				Boolean.FALSE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Component#isFocusable()
	 */
	@Override
	public boolean isFocusable() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.Sideable#getSide()
	 */
	public SubstanceConstants.Side getSide() {
		switch (this.orientation) {
		case SwingConstants.NORTH:
			return SubstanceConstants.Side.BOTTOM;
		case SwingConstants.WEST:
			return SubstanceConstants.Side.RIGHT;
		case SwingConstants.SOUTH:
			return SubstanceConstants.Side.TOP;
		case SwingConstants.EAST:
			return SubstanceConstants.Side.LEFT;
		default:
			return null;
		}
	}
	//
	// @Override
	// public void paint(Graphics g) {
	// super.paint(g);
	// Color c = "Spinner.nextButton".equals(this.getName()) ? Color.red
	// : Color.green.darker();
	// g.setColor(c);
	// g.drawRect(0, 0, getWidth() - 1, getHeight() - 1);
	// }
}
