package test;

import java.awt.ComponentOrientation;
import java.awt.FlowLayout;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;
import org.jvnet.substance.skin.SubstanceBusinessLookAndFeel;

public class RoTextField extends JFrame {
	public RoTextField() {
		super("Some simple text");

		this.setLayout(new FlowLayout());

		JSlider result = new JSlider(JSlider.VERTICAL, 0, 100, 50);
		result.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		result.setMajorTickSpacing(20);
		result.setMinorTickSpacing(5);
		result.setPaintTicks(true);
		result.setPaintLabels(true);

		this.add(result);

		this.add(new JTextField("text", 10));

		this.add(new JSeparator());

		this.setSize(650, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		// FadeTracker.DEBUG_MODE = true;
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.put(LafWidget.ANIMATION_KIND, AnimationKind.SLOW);
		UIManager.setLookAndFeel(new SubstanceBusinessLookAndFeel());
		// JFrame.setDefaultLookAndFeelDecorated(true);
		System.out.println("bg: "
				+ UIManager.getColor("Table.selectionBackground"));
		System.out.println("bg: "
				+ UIManager.getColor("Tree.selectionBackground"));
		System.out.println("fg: "
				+ UIManager.getColor("Tree.selectionForeground"));
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new RoTextField().setVisible(true);
			}
		});
	}
}
