/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Statement;

public class QueryTimerTask
extends TimerTask {
    private Statement statement_;
    private Timer timer_;

    public QueryTimerTask(Statement statement, Timer timer) {
        this.statement_ = statement;
        this.timer_ = timer;
    }

    public void run() {
        SqlWarning sqlWarning;
        this.timer_.cancel();
        try {
            this.statement_.cancel();
        }
        catch (SqlException sqlException) {
            sqlWarning = new SqlWarning(this.statement_.agent_.logWriter_, "An exception occurred while trying to cancel a statement that has timed out. See chained SQLException.");
            sqlWarning.setNextException(sqlException);
            this.statement_.accumulateWarning(sqlWarning);
        }
        boolean bl = this.cancel();
        if (bl) {
            sqlWarning = new SqlWarning(this.statement_.agent_.logWriter_, "An unexpected error occurred while trying to cancel a statement that has timed out.");
            this.statement_.accumulateWarning(sqlWarning);
        }
    }
}

