/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    public int hPalette = 0;
    int[] colorRefCount;
    int systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    int[] scripts;
    LOGFONT[] logFontsCache;
    boolean disposed;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData deviceData) {
        if (deviceData != null) {
            this.debug = deviceData.debug;
            this.tracking = deviceData.tracking;
        }
        this.create(deviceData);
        this.init();
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
        this.systemFont = this.getSystemFont().handle;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(int n) {
        int n2 = this.internal_new_GC(null);
        int n3 = -Compatibility.round(n * OS.GetDeviceCaps(n2, 90), 72);
        this.internal_dispose_GC(n2, null);
        return n3;
    }

    int computePoints(LOGFONT lOGFONT) {
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 90);
        int n3 = 0;
        if (lOGFONT.lfHeight > 0) {
            int n4 = OS.CreateFontIndirect(lOGFONT);
            int n5 = OS.SelectObject(n, n4);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n, tEXTMETRIC);
            OS.SelectObject(n, n5);
            OS.DeleteObject(n4);
            n3 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n3 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(n, null);
        return Compatibility.round(n3 * 72, n2);
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] == object) {
                this.objects[n] = null;
                this.errors[n] = null;
                return;
            }
            ++n;
        }
    }

    int EnumFontFamProc(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = bl = n4 == 1;
        if (bl2 == bl) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, n, LOGFONT.sizeof);
            this.logFonts[this.nFonts++] = object;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 8);
        int n3 = OS.GetDeviceCaps(n, 10);
        this.internal_dispose_GC(n, null);
        return new Rectangle(0, 0, n2, n3);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        int n = 0;
        int n2 = 0;
        if (this.tracking) {
            n2 = this.objects.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.objects[n3] != null) {
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        deviceData.objects = new Object[n];
        deviceData.errors = new Error[n];
        int n4 = 0;
        while (n4 < n2) {
            if (this.objects[n4] != null) {
                deviceData.objects[n3] = this.objects[n4];
                deviceData.errors[n3] = this.errors[n4];
                ++n3;
            }
            ++n4;
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 12);
        int n3 = OS.GetDeviceCaps(n, 14);
        this.internal_dispose_GC(n, null);
        return n2 * n3;
    }

    public Point getDPI() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 88);
        int n3 = OS.GetDeviceCaps(n, 90);
        this.internal_dispose_GC(n, null);
        return new Point(n2, n3);
    }

    public FontData[] getFontList(String string, boolean bl) {
        FontData[] fontDataArray;
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int n = callback.getAddress();
        this.logFonts = new LOGFONT[this.nFonts];
        int n2 = 0;
        while (n2 < this.logFonts.length) {
            this.logFonts[n2] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            ++n2;
        }
        this.nFonts = 0;
        n2 = 0;
        int n3 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(n3, null, n, bl ? 1 : 0);
            n2 = this.nFonts;
            int n4 = 0;
            while (n4 < n2) {
                fontDataArray = this.logFonts[n4];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(n3, ((LOGFONTW)fontDataArray).lfFaceName, n, bl ? 1 : 0);
                } else {
                    OS.EnumFontFamiliesA(n3, ((LOGFONTA)fontDataArray).lfFaceName, n, bl ? 1 : 0);
                }
                ++n4;
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(n3, tCHAR, n, bl ? 1 : 0);
        }
        this.internal_dispose_GC(n3, null);
        int n5 = this.nFonts - n2;
        fontDataArray = new FontData[n5];
        int n6 = 0;
        while (n6 < n5) {
            LOGFONT lOGFONT = this.logFonts[n6 + n2];
            fontDataArray[n6] = FontData.win32_new(lOGFONT, this.computePoints(lOGFONT));
            ++n6;
        }
        callback.dispose();
        this.logFonts = null;
        return fontDataArray;
    }

    String getLastError() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n) + "]";
    }

    String getLastErrorText() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        int n2 = 4864;
        int[] nArray = new int[1];
        int n3 = OS.FormatMessage(n2, 0, n, 1024, nArray, 0, 0);
        if (n3 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n3);
        OS.MoveMemory(tCHAR, nArray[0], n3 * TCHAR.sizeof);
        if (nArray[0] != 0) {
            OS.LocalFree(nArray[0]);
        }
        return tCHAR.toString(0, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0x2000000;
        switch (n) {
            case 1: {
                n2 = 0x2FFFFFF;
                break;
            }
            case 2: {
                n2 = 0x2000000;
                break;
            }
            case 3: {
                n2 = 0x20000FF;
                break;
            }
            case 4: {
                n2 = 0x2000080;
                break;
            }
            case 5: {
                n2 = 0x200FF00;
                break;
            }
            case 6: {
                n2 = 0x2008000;
                break;
            }
            case 7: {
                n2 = 0x200FFFF;
                break;
            }
            case 8: {
                n2 = 0x2008080;
                break;
            }
            case 9: {
                n2 = 0x2FF0000;
                break;
            }
            case 10: {
                n2 = 0x2800000;
                break;
            }
            case 11: {
                n2 = 0x2FF00FF;
                break;
            }
            case 12: {
                n2 = 0x2800080;
                break;
            }
            case 13: {
                n2 = 0x2FFFF00;
                break;
            }
            case 14: {
                n2 = 0x2808000;
                break;
            }
            case 15: {
                n2 = 0x2C0C0C0;
                break;
            }
            case 16: {
                n2 = 0x2808080;
            }
        }
        return Color.win32_new(this, n2);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n = OS.GetStockObject(13);
        return Font.win32_new(this, n);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        if (!OS.IsWinCE) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ScriptGetProperties(nArray, nArray2);
            this.scripts = new int[nArray2[0]];
            OS.MoveMemory(this.scripts, nArray[0], this.scripts.length * 4);
        }
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 38);
        int n3 = OS.GetDeviceCaps(n, 12);
        int n4 = OS.GetDeviceCaps(n, 14);
        if ((n2 & 0x100) == 0 || (n3 *= n4) != 8) {
            this.internal_dispose_GC(n, null);
            return;
        }
        int n5 = OS.GetDeviceCaps(n, 106);
        int n6 = OS.GetDeviceCaps(n, 104);
        if (OS.IsWinCE && n5 == 0 && n6 >= 20) {
            n5 = 20;
        }
        this.colorRefCount = new int[n6];
        byte[] byArray = new byte[4 + 4 * n6];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n6];
        OS.GetSystemPaletteEntries(n, 0, n6, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n6);
        int n7 = 0;
        while (n7 < n5 / 2) {
            this.colorRefCount[n7] = 1;
            this.colorRefCount[n6 - 1 - n7] = 1;
            ++n7;
        }
        this.internal_dispose_GC(n, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    void new_Object(Object object) {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] == null) {
                this.objects[n] = object;
                this.errors[n] = new Error();
                return;
            }
            ++n;
        }
        Object[] objectArray = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
        objectArray[this.objects.length] = object;
        this.objects = objectArray;
        Error[] errorArray = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
        errorArray[this.errors.length] = new Error();
        this.errors = errorArray;
    }

    protected void release() {
        this.scripts = null;
        this.logFontsCache = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }
}

