/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    ToolBar parent;
    Control control;
    String toolTipText;
    Image disabledImage;
    Image hotImage;
    Image disabledImage2;
    int id;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void click(boolean bl) {
        int n = this.parent.handle;
        if (OS.GetKeyState(1) < 0) {
            return;
        }
        int n2 = OS.SendMessage(n, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n, 1053, n2, rECT);
        int n3 = rECT.top + (rECT.bottom - rECT.top) / 2;
        int n4 = (bl ? rECT.right - 1 : rECT.left) | n3 << 16;
        int n5 = OS.SendMessage(n, 1095, 0, 0);
        OS.SendMessage(n, 513, 0, n4);
        OS.SendMessage(n, 514, 0, n4);
        if (n5 != -1) {
            OS.SendMessage(n, 1096, n5, 0);
        }
    }

    Image createDisabledImage(Image image, Color color) {
        return new Image((Device)this.display, image, 1);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n, 1053, n2, rECT);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1042, this.id, 0);
        return (n2 & 4) != 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1042, this.id, 0);
        return (n2 & 1) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n, 1053, n2, rECT);
        return rECT.right - rECT.left;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        if (this.disabledImage2 != null) {
            this.disabledImage2.dispose();
        }
        this.disabledImage2 = null;
    }

    void releaseImages() {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = 32;
        tBBUTTONINFO.dwMask = 9;
        int n = this.parent.handle;
        OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            ImageList imageList = this.parent.getImageList();
            ImageList imageList2 = this.parent.getHotImageList();
            ImageList imageList3 = this.parent.getDisabledImageList();
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList2 != null) {
                imageList2.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList3 != null) {
                imageList3.put(tBBUTTONINFO.iImage, null);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    void selectRadio() {
        int n = 0;
        ToolItem[] toolItemArray = this.parent.getItems();
        while (n < toolItemArray.length && toolItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && toolItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < toolItemArray.length && toolItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        this.control = control;
        this.resizeControl();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1042, this.id, 0);
        n2 &= 0xFFFFFFFB;
        if (bl) {
            n2 |= 4;
        }
        OS.SendMessage(n, 1041, this.id, n2);
        if (this.image != null) {
            this.updateImages();
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.disabledImage = image;
        this.updateImages();
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.hotImage = image;
        this.updateImages();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.updateImages();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 1042, this.id, 0);
        n2 &= 0xFFFFFFFE;
        if (bl) {
            n2 |= 1;
        }
        OS.SendMessage(n, 1041, this.id, n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        int n = this.parent.handle;
        int n2 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        int n3 = tCHAR.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, tCHAR, n3);
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = 32;
        tBBUTTONINFO.dwMask = 10;
        tBBUTTONINFO.pszText = n4;
        tBBUTTONINFO.fsStyle = (byte)(this.widgetStyle() | 0x10);
        if (string.length() != 0) {
            tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 0x40);
        }
        OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        OS.HeapFree(n2, 0, n4);
        int n5 = OS.SendMessage(n, 49, 0, 0);
        OS.SendMessage(n, 48, n5, 0);
        this.parent.layoutItems();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        int n2 = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = 32;
        tBBUTTONINFO.dwMask = 64;
        tBBUTTONINFO.cx = (short)n;
        OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        this.parent.layoutItems();
    }

    void updateImages() {
        int n = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = 32;
        tBBUTTONINFO.dwMask = 1;
        OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
        if (tBBUTTONINFO.iImage == -2 && this.image == null) {
            return;
        }
        ImageList imageList = this.parent.getImageList();
        ImageList imageList2 = this.parent.getHotImageList();
        ImageList imageList3 = this.parent.getDisabledImageList();
        if (tBBUTTONINFO.iImage == -2) {
            Rectangle rectangle = this.image.getBounds();
            Point point = new Point(rectangle.width, rectangle.height);
            if (imageList == null) {
                imageList = this.display.getToolImageList(point);
            }
            tBBUTTONINFO.iImage = imageList.add(this.image);
            this.parent.setImageList(imageList);
            if (imageList3 == null) {
                imageList3 = this.display.getToolDisabledImageList(point);
            }
            Image image = this.disabledImage;
            if (this.disabledImage == null) {
                if (this.disabledImage2 != null) {
                    this.disabledImage2.dispose();
                }
                this.disabledImage2 = null;
                image = this.image;
                if (!this.getEnabled()) {
                    Color color = this.parent.getBackground();
                    image = this.disabledImage2 = this.createDisabledImage(this.image, color);
                }
            }
            imageList3.add(image);
            this.parent.setDisabledImageList(imageList3);
            if (imageList2 == null) {
                imageList2 = this.display.getToolHotImageList(point);
            }
            imageList2.add(this.hotImage != null ? this.hotImage : this.image);
            this.parent.setHotImageList(imageList2);
        } else {
            Image image;
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, this.image);
            }
            if (imageList3 != null) {
                image = null;
                if (this.image != null) {
                    if (this.disabledImage2 != null) {
                        this.disabledImage2.dispose();
                    }
                    this.disabledImage2 = null;
                    image = this.disabledImage;
                    if (this.disabledImage == null) {
                        image = this.image;
                        if (!this.getEnabled()) {
                            Color color = this.parent.getBackground();
                            image = this.disabledImage2 = this.createDisabledImage(this.image, color);
                        }
                    }
                }
                imageList3.put(tBBUTTONINFO.iImage, image);
            }
            if (imageList2 != null) {
                image = null;
                if (this.image != null) {
                    image = this.hotImage != null ? this.hotImage : this.image;
                }
                imageList2.put(tBBUTTONINFO.iImage, image);
            }
            if (this.image == null) {
                tBBUTTONINFO.iImage = -2;
            }
        }
        OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        this.parent.layoutItems();
    }

    int widgetStyle() {
        if ((this.style & 4) != 0) {
            return 8;
        }
        if ((this.style & 8) != 0) {
            return 0;
        }
        if ((this.style & 0x20) != 0) {
            return 2;
        }
        if ((this.style & 0x10) != 0) {
            return 2;
        }
        if ((this.style & 2) != 0) {
            return 1;
        }
        return 0;
    }

    LRESULT wmCommandChild(int n, int n2) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13);
        return null;
    }
}

