#include "tads.h"
#include "t3.h"
#include "bignum.h"

main(args)
{
    local x, y, lst;

    x = new BigNumber('-.979');
    y = new BigNumber('-3.203');
    "x = <<x>>, y = <<y>>, x/y = <<x/y>>\n";

    x = new BigNumber('12345');
    y = new BigNumber('77');
    lst = x.divideBy(y);
    "x = <<x>>, y = <<y>>, x/y = <<lst[1]>>, x mod y = <<lst[2]>>\n";

    x = new BigNumber('12397');
    y = new BigNumber('77');
    lst = x.divideBy(y);
    "x = <<x>>, y = <<y>>, x/y = <<lst[1]>>, x mod y = <<lst[2]>>\n";

    x = new BigNumber('12396');
    y = new BigNumber('77');
    lst = x.divideBy(y);
    "x = <<x>>, y = <<y>>, x/y = <<lst[1]>>, x mod y = <<lst[2]>>\n";
}

bool(val)
{
    if (val)
        "true";
    else
        "nil";
}

preinit()
{
}


/* ------------------------------------------------------------------------ */
/*
 *   some boilerplate setup stuff 
 */

class Exception: object
    display = "Unknown exception"
;

class RuntimeError: Exception
    construct(errno, ...) { errno_ = errno; }
    display = "Runtime error: <<exceptionMessage>>"
    errno_ = 0
    exceptionMessage = ''
;

_say_embed(str) { tadsSay(str); }

_main(args)
{
    try
    {
        t3SetSay(&_say_embed);
        if (!global.preinited_)
        {
            preinit();
            global.preinited_ = true;
        }
        if (!t3GetVMPreinitMode())
            main(args);
    }
    catch (RuntimeError rte)
    {
        "\n<<rte.display>>\n";
    }
}

global: object
    preinited_ = nil
;
