#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "gtk_fsel_cb.h"
#include "gtk_fsel_dbox.h"
#include "support.h"

#include "platform.h"
#include "struct.h"
#include "specific.h"
#include "gtk_pbar_cb.h"
#include "gtk_msg_cb.h"
#include "tilibs.h"

#include "lib68k.h"

gint display_rom_fileselection()
{
  GtkWidget *dbox;
  gpointer user_data;
   
  dbox = create_rom_fileselection();
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "rom_fileselection");
  gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), "*.rom");
  gtk_widget_show_all(dbox);
  return 0;
}

gint display_tifile_fileselection()
{
  GtkWidget *dbox;
  gpointer user_data;
   
  dbox = create_tifile_fileselection();
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "tifile_fileselection");
  switch(ti68k_getCalcType())
    {
    case TI92:
      gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), 
				  "*.92?");
      break;
    case TI89:
      gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), 
				  "*.89?");
      break;
    case TI92 | MODULEPLUS:
      gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), 
				  "*.9x?");
      break;
    default:
      gtk_file_selection_complete(GTK_FILE_SELECTION(user_data), 
				  "*.???");
      break;
    }
  gtk_widget_show_all(dbox);
  return 0;
}

gint display_tib_fileselection()
{
  GtkWidget *dbox;
  gpointer user_data;
   
  dbox = create_tib_fileselection();
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "tib_fileselection");
  gtk_file_selection_complete(GTK_FILE_SELECTION(user_data),
			      "*.89u;*.9xu;*.tib");
  gtk_widget_show_all(dbox);
  return 0;
}

gint display_ams_fileselection()
{
  GtkWidget *dbox;
  gpointer user_data;
   
  dbox = create_ams_fileselection();
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "ams_fileselection");
  gtk_file_selection_complete(GTK_FILE_SELECTION(user_data),
			      "*.89u;*.9xu;*.tib");
  gtk_widget_show_all(dbox);
  return 0;
}

void
on_rom_fileselection_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}


extern int romOk;

void
on_rom_ok_button2_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *filename;
  gchar *ext;

  /* Open a ROM file */
  filename = gtk_file_selection_get_filename 
    (GTK_FILE_SELECTION(user_data));

  ext = strrchr(filename, '.');
  if(str_cmp(ext, ".rom"))
    return;

  g_free(options.rom_file);
  options.rom_file = g_strdup(filename);
  ti68k_loadRom(options.rom_file); 

  //update_window(); //added by Tom
  gtk_widget_destroy(GTK_WIDGET(user_data));
  unsuspend();
  romOk = 1;
}


void
on_rom_cancel_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_tifile_fileselection_destroy        (GtkObject       *object,
                                        gpointer         user_data)
{
  destroy_pbar();
  unsuspend();
}


void
on_tifile_ok_button2_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *filename;
  gchar *ext;

  /* Retrieve filename */
  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
  gtk_widget_hide(GTK_WIDGET(user_data));
  while( gtk_events_pending() ) { gtk_main_iteration(); }

  /* Get extension */
  ext = strrchr(filename, '.');
  if(ext == NULL)
    return;
  else
    ext++;
  
  /* TI file ? */
  if(!(strstr(ext, "89") && (ti68k_getCalcType() == TI89)) ||
     (strstr(ext, "92") && (ti68k_getCalcType() == TI92))  ||
     (strstr(ext, "9x") && (ti68k_getCalcType() == TI92p)) ||
     (strstr(ext, "9X") && (ti68k_getCalcType() == TI92p)) )
    return;
  
  /* FLASH APP file ? */
  else if( (ext[2] == 'k') || (ext[2] =='K'))
    {
      create_pbar_type5(_("Flash"), "");
    }

  /* FLASH OS file ? */
  else if( (ext[2] == 'u') || (ext[2] == 'U'))
    {
      create_pbar_type5(_("Flash"), "");
    }
  
  /* Backup file ? */
  else if( (ext[2] == 'b') || (ext[2] == 'B'))
    {
      create_pbar_type3(_("Backup"));
    }

  /* Group file ? */
  else if( (ext[2] == 'g') || (ext[2] == 'G'))
    {
      create_pbar_type5(_("Sending group file"), "");
    }

  /* Single file */
  else
    {
      create_pbar_type4(_("Sending variable"), "");
    }

  ti68k_sendFile(filename);

  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_tifile_cancel_button2_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_update_file1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_tib_fileselection();
}


void
on_tib_fileselection_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}


void
on_tib_ok_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *filename;

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));

  g_free(options.tib_file);
  options.tib_file = g_strdup(filename);
  if(ti68k_loadTib(options.tib_file)) 
    {
      msg_box("Error", "Can not open the ROM/FLASH file.");
      return;
    }
  
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_tib_cancel_button2_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_ams_fileselection_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}


void
on_ams_ok_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *filename;
  gchar buffer[1024];

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
  //msg_box(_("Information"), _("Conversion in progress. Please wait..."));
  //while( gtk_events_pending() ) { gtk_main_iteration(); }
  ti68k_convertTibToRom(filename, buffer);

  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_ams_cancel_button2_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}
