;*
;* PedroM - Operating System for Ti-89/Ti-92+/V200.
;* Copyright (C) 2003 PpHd
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

; Exported PedroM library

PedroMLibKernel:
	dc.l	$4E754E75		; Header
	dc.l	'68kL'			; Signature
	dc.b	0,2			; InternalFormat, RelocCount
	dc.w	0,0,0			; Offset to main, comment, exit
	dc.b	1,32+2+1		; VersionNumber,Flags
	dc.w	0,0,PedoMLibExportTable-PedroMLibKernel,0	; Handle,Bss,Export,RamTable
PedoMLibExportTable:
	dc.w	(PedoMLibExportTableEnd-PedoMLibExportTable-2)/2
	dc.w	RamDataTable-PedroMLibKernel		; 0
	dc.w	RunMainFunction-PedroMLibKernel		; 1
	dc.w	HeapRealloc3-PedroMLibKernel		; 2
	dc.w	HeapMax3-PedroMLibKernel		; 3
	dc.w	printf-PedroMLibKernel			; 4
	dc.w	vcbprintf-PedroMLibKernel		; 5
	dc.w	clrscr-PedroMLibKernel			; 6
	dc.w	fclose-PedroMLibKernel			; 7
	dc.w	freopen-PedroMLibKernel			; 8
	dc.w	fopen-PedroMLibKernel			; 9
	dc.w	fseek-PedroMLibKernel			; A
	dc.w	ftell-PedroMLibKernel			; B
	dc.w	feof-PedroMLibKernel			; C
	dc.w	fputc-PedroMLibKernel			; D
	dc.w	fputs-PedroMLibKernel			; E
	dc.w	fwrite-PedroMLibKernel			; F
	dc.w	fgetc-PedroMLibKernel			; 10
	dc.w	fread-PedroMLibKernel			; 11
	dc.w	fgets-PedroMLibKernel			; 12
	dc.w	ungetc-PedroMLibKernel			; 13
	dc.w	fflush-PedroMLibKernel			; 14
	dc.w	clearerr-PedroMLibKernel		; 15
	dc.w	ferror-PedroMLibKernel			; 16
	dc.w	rewind-PedroMLibKernel			; 17
	dc.w	fprintf-PedroMLibKernel			; 18
	dc.w	tmpnam-PedroMLibKernel			; 19
	dc.w	DIALOG.Do-PedroMLibKernel		; 1A
	dc.w	qsort-PedroMLibKernel			; 1B
	dc.w	PID_Switch-PedroMLibKernel		; 1C
	dc.w	_tt_Decompress-PedroMLibKernel		; 1D
	dc.w	bsearch-PedroMLibKernel			; 1E
	dc.w	unlink-PedroMLibKernel			; 1F
	dc.w	rename-PedroMLibKernel			; 20
	dc.w	atoi-PedroMLibKernel			; 21
	dc.w	kbd_queue-PedroMLibKernel		; 22
	dc.w	rand-PedroMLibKernel			; 23
	dc.w	srand-PedroMLibKernel			; 24
	dc.w	calloc-PedroMLibKernel			; 25
	dc.w	realloc-PedroMLibKernel			; 26
	dc.w	atof-PedroMLibKernel			; 27
	dc.w	_sputc-PedroMLibKernel			; 28
	dc.w	perror-PedroMLibKernel			; 29
	dc.w	getenv-PedroMLibKernel			; 2A
	dc.w	system-PedroMLibKernel			; 2b
	dc.w	setvbuf-PedroMLibKernel			; 2c
	dc.w	exit-PedroMLibKernel			; 2d
	dc.w	atexit-PedroMLibKernel			; 2e
	
PedoMLibExportTableEnd:
	
HeapRealloc3	bra	HeapRealloc
HeapMax3	bra	HeapMax

RamDataTable:
	dc.l	stdin
	dc.l	stdout
	dc.l	stderr
	dc.l	ARGC
	dc.l	ARGV
	dc.l	errno

; In: a0-> main
RunMainFunction:
	move.l	EXIT_STACK_PTR,-(a7)			; Push Old Exit Stack Ptr
	lea	-4*PROGRAM_MAX_ATEXIT_FUNC(a7),a7	; Push atexit ptr tab
	clr.w	-(a7)					; No atexit func
	move.l	a7,EXIT_STACK_PTR			; Save New Exit Stack Ptr
	pea	ARGV					; Push ARGV
	move.w	ARGC,-(a7)				; Push argc
	jsr	(a0)					; Jump
exit:	move.l	EXIT_STACK_PTR,a7
	bsr	Short2Float				; Save Return value
	move.w	(a7)+,d3				; Number of atexit func
	beq.s	\Done					; No atexit function
		move.l	a7,a3				; atexit tab ptr
\Loop		move.l	(a3)+,a0			; Read atexit func ptr
		jsr	(a0)				; Call atexit func
		subq.w	#1,d3				; One more ?
		bne.s	\Loop				; Yes
\Done	lea	4*PROGRAM_MAX_ATEXIT_FUNC(a7),a7	; Pop frame
	move.l	(a7)+,EXIT_STACK_PTR			; 
	rts

atexit:
	moveq	#1,d0					; Fail
	move.l	EXIT_STACK_PTR,a1			; Ptr
	move.w	(a1),d2					; Number of registered functions
	cmpi.w	#PROGRAM_MAX_ATEXIT_FUNC,d2		; Check overflow
	bge.s	\Fail
		lsl.w	#2,d2				; xsizeof(ptr)
		move.l	a0,2(a1,d2.w)			; Save function
		addq.w	#1,(a1)				; One more
		clr.w	d0				; Success
\Fail	rts

_tt_Decompress: jmp INVALID_ROMCALL
