package tijmp;

import java.util.concurrent.LinkedBlockingQueue;

/* Our own event handler.
 * Since we do not know if the security manager will grant random
 * threads access to create new threads we need our own thread running so 
 * that we do not hog the edt. 
 * This thread is started very early so it has no security set.
 */
class EventHandler implements Runnable {
    private static LinkedBlockingQueue<Runnable> lbq;

    public EventHandler (LinkedBlockingQueue<Runnable> lbq) {
	EventHandler.lbq = lbq;
    }

    public void run () {
	while (true) { 
	    try {
		Runnable r = lbq.take (); 
		r.run ();
	    } catch (InterruptedException e) {
		e.printStackTrace ();
	    }
	}
    }
}

