-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001--2003  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Text_IO;
with Interfaces.C;
with Interfaces.C.Strings;

package body Readline is

   pragma Linker_Options("-lreadline");
   pragma Linker_Options("-lncurses");
   pragma Linker_Options("ada-readline-c.o");

   function C_Get_String (Prompt : in Interfaces.C.Char_Array)
     return Interfaces.C.Strings.Chars_Ptr;

   pragma Import(C, C_Get_String, "rl_gets");

   procedure C_Add_History (History : in Interfaces.C.Char_Array);

   pragma Import(C, C_Add_History, "add_history");

   procedure  C_Disable_Tab_Completion;

   pragma Import(C, C_Disable_Tab_Completion, "rl_disable_tab_completion");

   procedure  C_Enable_Tab_Completion;

   pragma Import(C, C_Enable_Tab_Completion, "rl_enable_tab_completion");

   function Get_String (Prompt                : String  := "";
                        Enable_Tab_Completion : Boolean := False)
     return String is
      use Interfaces.C;
      use Interfaces.C.Strings;

      C_Result : Chars_Ptr;
   begin
      if Enable_Tab_Completion then
         C_Enable_Tab_Completion;
      else
         C_Disable_Tab_Completion;
      end if;
      C_Result := C_Get_String(To_C(Prompt));
      return To_Ada(Value(C_Result));
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Get_String");
         raise;
   end Get_String;

   procedure Add_History (History      : in String;
                          Remove_Empty : in Boolean := True) is
   begin
      if not (Remove_Empty and History = "") then
         C_Add_History(Interfaces.C.To_C(History));
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Add_History");
         raise;
   end Add_History;

end Readline;
