#include <windows.h>
#include <string.h>
#include <stdio.h>
#define BUFSIZE 4096
#define PATHLEN 256
#define TTH_BSIZE 256

#include "tth-gui.h"

/* defined in header file.
#define TTH_CANCEL 133
#define TTH_DEFAULTS 115
#define TTH_RUNCOMMAND 108
#define TTH_EXTRA 106
#define TTH_FILENAME 107
#define TTH_FILESELECT 134
*/

#define TTH_NUMBUTS 34

char tth_file[1000]="";

UINT tth_buts[TTH_NUMBUTS]={0};
char *tth_base="tth ";
char tth_command[256];
char *tth_switch[TTH_NUMBUTS]=
{
  ""," -w1"," -w2"," -w3","",
  "","","","","",
  ""," -i"," -t"," -s","",
  "",""," -y2"," -y3","",
  " -u1"," -u2","",""," -n1",
  " -n2","",""," -e1"," -e2",
  " -e3","","",""
};

int tth_getbuts(HWND hwnd){
  /* Examine the buttons and construct the command line. */
  char thisbuffer[TTH_BSIZE]={0};
  char shortbuffer[TTH_BSIZE]={0};
  int i;
  strcpy(tth_command,tth_base);
  for (i=0;i<TTH_NUMBUTS;i++){
    tth_buts[i]=IsDlgButtonChecked(hwnd,DLG_0100+i+1);
    if(tth_buts[i]==BST_CHECKED){
      strcat(tth_command,tth_switch[i]);
    }
  }
  if(GetDlgItemText(hwnd,TTH_EXTRA,thisbuffer,TTH_BSIZE)){
    strcat(tth_command," ");
    strcat(tth_command,thisbuffer);
  }
  if(GetDlgItemText(hwnd,TTH_FILENAME,thisbuffer,TTH_BSIZE)){
    if(tth_namefix(thisbuffer)){
      strcat(tth_command," ");
      strcat(tth_command,thisbuffer);
    }
  }
  SetDlgItemText(hwnd,109,tth_command);
  SetDlgItemText(hwnd,137,"");
  return 1;
}

int tth_namefix(char *inoutbuffer)
{
  /* If the incoming filename, of either short or long form, contains
     a backslash or a space, fix it to have full short path and long name.
     Except, if the long name contains a space, return the short
     name. Thus the name is sanitized as little as possible to make it
     compatible with a command line call.  Return zero on failure,
     length of buffer on success.*/

  char *fileonly,*sname;
  WIN32_FIND_DATA founddata;
  char shortbuffer[TTH_BSIZE]={0};
  char longbuffer[TTH_BSIZE]={0};
  int i;

  if(strcspn(inoutbuffer,"\\\" ")==strlen(inoutbuffer)){
    /* Clean file input, no conversion. */
    return strlen(inoutbuffer);
  }else{
    /*If this is presented as a quoted string, unquote it.*/
    if(*inoutbuffer=='"') {
      sname=inoutbuffer+1; *(sname+strcspn(sname,"\""))=0;
    }else{
      sname=inoutbuffer;
    }
    /*Ensure we have the full path to start with, just the file is not enough. 
    It might be long-form.*/
    GetFullPathName(sname,TTH_BSIZE,longbuffer,&fileonly);
  /*Convert it to short form in shortbuffer.*/
    if(GetShortPathName(longbuffer,shortbuffer,TTH_BSIZE)){
      /* Put into longbuffer with a pointer to the name*/
      if(GetFullPathName(shortbuffer,TTH_BSIZE,longbuffer,&fileonly)){
	/* Get the definitely long filename into founddata.cFileName. */
	/* Replace the file name only. */
	if(FindFirstFile(longbuffer,&founddata)!=INVALID_HANDLE_VALUE){
	  if(strcspn(founddata.cFileName," ")==strlen(founddata.cFileName)){
	    strcpy(fileonly,founddata.cFileName);
	}else{ /* Give up and use the short name. */
	  strcpy(longbuffer,shortbuffer);
	}
	}
	strcpy(inoutbuffer,longbuffer);
	return strlen(longbuffer);
      } else {
	return 0;
      }
    }else{
      return 0;
    }
  }
}

int tth_runtth(HWND hwnd)
{
  /* Run TtH on the file */

  char longbuffer[TTH_BSIZE]={0};
  char shortbuffer[TTH_BSIZE]={0};

  if(GetDlgItemText(hwnd,TTH_FILENAME,longbuffer,TTH_BSIZE)){
    if(tth_namefix(longbuffer)){
      /* This file shuffling not necessary.
      strcpy(shortbuffer,longbuffer);
      if(*(longbuffer+strlen(longbuffer)-4)=='.'){
	strcpy((longbuffer+strlen(longbuffer)-3),"html");
	DeleteFile(longbuffer);
      }
      if(*(shortbuffer+strlen(shortbuffer)-4)=='.'){
	strcpy((shortbuffer+strlen(shortbuffer)-3),"html");
      }
      */
      
      SetDlgItemText(hwnd,137,"Running ... ");
      if(system(tth_command)){
	SetDlgItemText(hwnd,137,"TtH command failed");
      }else{
	SetDlgItemText(hwnd,137,"Translation Completed");
      }
      
      /* Move the file back to the long filename if a short one was made.
      if(!MoveFile(longbuffer,longbuffer)){
	if(!MoveFile(shortbuffer,longbuffer)){
	  strcat(shortbuffer," can't be moved to ");
	  strncat(shortbuffer,longbuffer,100);
	  MessageBox(hwnd, shortbuffer, "Error",
                    MB_OK | MB_ICONINFORMATION);
	  }
      }
      should not now be necessary  */
      
      /* Splitting files as a separate call. */
      if(IsDlgButtonChecked(hwnd,TTH_SPLIT))
	if(IsDlgButtonChecked(hwnd,TTH_UNSPLIT)){
	  if(GetShortPathName(longbuffer,shortbuffer,TTH_BSIZE)){
	    sprintf(tth_command,"type %s | tthsplit",shortbuffer);
	    SetDlgItemText(hwnd,137,"Splitting ... ");
	    system(tth_command);
	    SetDlgItemText(hwnd,137,"Splitting Completed");
	  }
	}

    }else{
      strcpy(shortbuffer,"Can't find the file: ");
      strncat(shortbuffer,longbuffer,200);
      MessageBox(hwnd, shortbuffer, "Error",
                    MB_OK | MB_ICONINFORMATION);
    }
  }else{
   MessageBox(hwnd, "Select a TeX file first", "Error",
                    MB_OK | MB_ICONINFORMATION);
  }    
}

int tth_defaults(HWND hwnd)
{ 
  strcpy(tth_command,"tth ");
  /*  SendMessage(hwnd,BM_SETCHECK,BST_CHECKED,0)*/
  CheckRadioButton(hwnd,101,104,101);
  CheckRadioButton(hwnd,120,122,120);
  CheckRadioButton(hwnd,124,126,124);
  CheckRadioButton(hwnd,128,131,128);
  CheckRadioButton(hwnd,117,119,117);
  CheckDlgButton(hwnd,112,BST_UNCHECKED);
  CheckDlgButton(hwnd,113,BST_UNCHECKED);
  CheckDlgButton(hwnd,TTH_SPLIT,BST_UNCHECKED);
  CheckDlgButton(hwnd,138,BST_UNCHECKED);
}


int tth_getfile(HWND hwnd)
{    
  OPENFILENAME file; 
  BOOL tf; 
  memset(&file,0,sizeof(file));   
  file.lStructSize = sizeof(file);
  file.Flags = OFN_HIDEREADONLY;
  file.lpstrFile=tth_file; 
  file.nMaxFile=1000;
  file.lpstrFilter="Tex File(*.tex)\0*.tex;\0";
  if(GetOpenFileName(&file)){ 
    SetDlgItemText(hwnd,TTH_FILENAME,tth_file);
  }
  tth_getbuts(hwnd);
  return 0;
}


BOOL CALLBACK TthDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  int i,j;
  switch(Message)
    {
    case WM_INITDIALOG:
      tth_defaults(hwnd);
      SetDlgItemText(hwnd,TTH_FILENAME,tth_file);
      tth_getbuts(hwnd);
      return TRUE;

    case WM_COMMAND:
        if(HIWORD(wParam)==BN_CLICKED)tth_getbuts(hwnd); 

      switch(LOWORD(wParam))
	{
	case IDOK:
	  EndDialog(hwnd, IDOK);
	  break;
	case IDCANCEL:
	  EndDialog(hwnd, IDCANCEL);
	  break;
	case TTH_DEFAULTS:
	  tth_defaults(hwnd);
  	  tth_getbuts(hwnd);
	  break;
	case TTH_RUNCOMMAND:
	  tth_runtth(hwnd);
	  break;
	case TTH_FILESELECT:
	  tth_getfile(hwnd);
	  break;
	case TTH_CANCEL:
	  tth_getbuts(hwnd);
	  EndDialog(hwnd, TTH_CANCEL);
	  break;
	}
      break;
    default:
      return FALSE;
    }
  return TRUE;
}

int STDCALL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, int nShow)
{
  HWND hwnd=NULL; /* Null window parent.*/
  int ret;

  strncpy(tth_file,lpCmd,999);

  ret = DialogBox(GetModuleHandle(NULL), 
		  MAKEINTRESOURCE(DLG_0100), hwnd, TthDlgProc);
  if(ret == -1){
    MessageBox(hwnd, "Launcher failed!", "Error",
	       MB_OK | MB_ICONINFORMATION);
 }
 return 0;
}
