/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.webmacro.engine.Argument;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.Condition;
import org.webmacro.engine.ConstantCondition;
import org.webmacro.engine.Engine;
import org.webmacro.engine.IntrospectionException;

final class DirectiveBuilder
implements Cloneable,
Builder {
    private static final Class[] _nullSig = new Class[0];
    private static final Object[] _nullArg = new Object[0];
    private String[] _argNames = null;
    private String[] _dependents = null;
    private boolean _isContainer = false;
    private boolean _hasCondition = false;
    private boolean _hasTarget = false;
    private boolean _isSubDirective;
    private boolean _isParser = false;
    private Method _build = null;
    private int _buildArgs = 0;
    private String _name;
    private Class _directiveClass;
    private Builder _contents = null;
    private String _text = null;
    private Object _dependent = null;
    private Object _target = null;
    private Object _condition = null;
    private Vector _arguments = null;
    static /* synthetic */ Class class$org$webmacro$engine$Directive;
    static /* synthetic */ Class class$org$webmacro$engine$SubDirective;
    static /* synthetic */ Class class$org$webmacro$engine$BuildContext;
    static /* synthetic */ Class class$org$webmacro$engine$Condition;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Lorg$webmacro$engine$Argument;
    static /* synthetic */ Class class$org$webmacro$Macro;
    static /* synthetic */ Class class$java$lang$String;

    DirectiveBuilder(String string, Class clazz) throws IntrospectionException {
        Method method;
        boolean bl = false;
        boolean bl2 = false;
        this._name = string;
        this._directiveClass = clazz;
        if (!(class$org$webmacro$engine$Directive == null ? (class$org$webmacro$engine$Directive = DirectiveBuilder.class$("org.webmacro.engine.Directive")) : class$org$webmacro$engine$Directive).isAssignableFrom(clazz)) {
            throw new IntrospectionException("Not a Directive: " + clazz);
        }
        this._isSubDirective = (class$org$webmacro$engine$SubDirective == null ? (class$org$webmacro$engine$SubDirective = DirectiveBuilder.class$("org.webmacro.engine.SubDirective")) : class$org$webmacro$engine$SubDirective).isAssignableFrom(clazz);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            int n2 = methodArray[n].getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isStatic(n2) && methodArray[n].getName().equals("build")) {
                if (this._build == null) {
                    this._build = methodArray[n];
                } else {
                    throw new IntrospectionException("Directives must have only one build() method.");
                }
            }
            ++n;
        }
        if (this._build == null) {
            throw new IntrospectionException("Directives must have a public static build() method");
        }
        Class<?>[] classArray = this._build.getParameterTypes();
        this._buildArgs = classArray.length;
        if (classArray.length < 1) {
            throw new IntrospectionException("Directive.build() method must have at least one arguments");
        }
        int n3 = 0;
        if (classArray[n3++] != (class$org$webmacro$engine$BuildContext == null ? (class$org$webmacro$engine$BuildContext = DirectiveBuilder.class$("org.webmacro.engine.BuildContext")) : class$org$webmacro$engine$BuildContext)) {
            throw new IntrospectionException("Directives must have a build method whose first argument is a BuildContext");
        }
        if (classArray[n3] == (class$org$webmacro$engine$Condition == null ? (class$org$webmacro$engine$Condition = DirectiveBuilder.class$("org.webmacro.engine.Condition")) : class$org$webmacro$engine$Condition)) {
            ++n3;
            this._hasCondition = true;
        } else if (classArray[n3] == (class$java$lang$Object == null ? (class$java$lang$Object = DirectiveBuilder.class$("java.lang.Object")) : class$java$lang$Object)) {
            this._hasTarget = true;
            if (++n3 < classArray.length && classArray[n3] == (array$Lorg$webmacro$engine$Argument == null ? (array$Lorg$webmacro$engine$Argument = DirectiveBuilder.class$("[Lorg.webmacro.engine.Argument;")) : array$Lorg$webmacro$engine$Argument)) {
                ++n3;
                bl2 = true;
            }
        }
        if (n3 < classArray.length && classArray[n3] == (class$org$webmacro$Macro == null ? (class$org$webmacro$Macro = DirectiveBuilder.class$("org.webmacro.Macro")) : class$org$webmacro$Macro)) {
            ++n3;
            this._isContainer = true;
        } else if (n3 < classArray.length && classArray[n3] == (class$java$lang$String == null ? (class$java$lang$String = DirectiveBuilder.class$("java.lang.String")) : class$java$lang$String)) {
            ++n3;
            this._isParser = true;
        }
        if (n3 < classArray.length && classArray[n3] == (class$java$lang$Object == null ? (class$java$lang$Object = DirectiveBuilder.class$("java.lang.Object")) : class$java$lang$Object)) {
            ++n3;
            bl = true;
        }
        if (n3 < classArray.length) {
            throw new IntrospectionException("Class " + clazz + " build method does not match the directive pattern. " + "The parameter " + classArray[n3] + " was unexpected.");
        }
        if (bl2) {
            try {
                method = clazz.getMethod("getArgumentNames", _nullSig);
                this._argNames = (String[])method.invoke(null, _nullArg);
            }
            catch (Exception exception) {
                throw new IntrospectionException("Directive " + clazz + " build() requires a source object, but getArgumentNames " + " failed: " + exception);
            }
            if (this._argNames == null) {
                throw new IntrospectionException("getArgumentNames returned null.");
            }
        }
        if (bl) {
            try {
                method = clazz.getMethod("getSubDirectives", _nullSig);
                this._dependents = (String[])method.invoke(null, _nullArg);
            }
            catch (Exception exception) {
                throw new IntrospectionException("Directive " + clazz + " build() accepts a dependent directive, but the " + " getSubDirectives method failed: " + exception);
            }
            if (this._dependents == null) {
                throw new IntrospectionException("getSubDirectives returned a null.");
            }
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone not supported on cloneable object!");
        }
    }

    public final Class getDirectiveClass() {
        return this._directiveClass;
    }

    public final String[] getArgumentNames() {
        return this._argNames;
    }

    public final String[] getSubDirectives() {
        return this._dependents;
    }

    public final boolean hasCondition() {
        return this._hasCondition;
    }

    public final boolean hasTarget() {
        return this._hasTarget;
    }

    public final boolean hasArguments() {
        return this._argNames != null;
    }

    public final boolean isContainer() {
        return this._isContainer;
    }

    public final boolean isParser() {
        return this._isParser;
    }

    public final boolean isMulti() {
        return this._dependents != null;
    }

    public final boolean isSubDirective() {
        return this._isSubDirective;
    }

    private final Argument[] getArguments(BuildContext buildContext) throws BuildException {
        if (!this.hasArguments()) {
            return null;
        }
        if (this._arguments == null) {
            this._arguments = new Vector();
        }
        Object[] objectArray = new Argument[this._arguments.size()];
        this._arguments.copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            ((Argument)objectArray[n]).build(buildContext);
            ++n;
        }
        return objectArray;
    }

    public final void setTarget(Object object) throws IllegalStateException {
        if (this.hasCondition()) {
            throw new IllegalStateException("Directive should not have a target");
        }
        this._target = object;
    }

    public final void setCondition(Object object) throws IllegalStateException {
        if (!this.hasCondition()) {
            throw new IllegalStateException("Directive should not have a condition");
        }
        this._condition = object;
    }

    public final void setSubDirective(Object object) throws IllegalStateException {
        if (!this.isMulti()) {
            throw new IllegalStateException("Directive should not have a dependent");
        }
        this._dependent = object;
    }

    public final void addArgument(String string, Object object) throws IllegalStateException {
        if (!this.hasArguments()) {
            throw new IllegalStateException("Does not take arguments");
        }
        boolean bl = false;
        int n = 0;
        while (n < this._argNames.length) {
            if (this._argNames[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalStateException(string + " is not recognized as an argument for " + this.toString());
        }
        if (this._arguments == null) {
            this._arguments = new Vector();
        }
        Argument argument = new Argument(string, object);
        this._arguments.addElement(argument);
    }

    public final void setContents(Builder builder) {
        if (!this.isContainer()) {
            throw new IllegalStateException("Directive should not have contents");
        }
        this._contents = builder;
    }

    public final void setText(String string) {
        if (!this.isParser()) {
            throw new IllegalStateException("Directive is not a parser");
        }
        this._text = string;
    }

    public final void check() throws BuildException {
        this.check("condition", this.hasCondition(), this._condition != null);
        this.check("target", this.hasTarget(), this._target != null);
        this.check("contents", this.isContainer(), this._contents != null);
    }

    private void check(String string, boolean bl, boolean bl2) throws BuildException {
        if (bl && !bl2) {
            throw new BuildException("Missing " + string + ": " + this);
        }
    }

    public final Object build(BuildContext buildContext) throws BuildException {
        Object object;
        Object[] objectArray = new Object[this._buildArgs];
        int n = 0;
        objectArray[n++] = buildContext;
        if (this.hasCondition()) {
            object = this._condition instanceof Builder ? ((Builder)this._condition).build(buildContext) : this._condition;
            objectArray[n++] = object instanceof Condition ? object : new ConstantCondition(object);
        }
        if (this.hasTarget()) {
            objectArray[n++] = this._target;
        }
        if (this.hasArguments()) {
            objectArray[n++] = this.getArguments(buildContext);
        }
        if (this.isContainer()) {
            objectArray[n++] = this._contents;
        }
        if (this.isParser()) {
            objectArray[n++] = this._text;
        }
        if (this.isMulti()) {
            objectArray[n++] = this._dependent;
        }
        n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (object != null && object instanceof Builder) {
                objectArray[n] = ((Builder)object).build(buildContext);
            }
            ++n;
        }
        try {
            object = this._build.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            Engine.log.exception(throwable);
            throw new BuildException("failure during build: " + throwable);
        }
        catch (Exception exception) {
            throw new BuildException("failed to build: " + exception);
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = null;
        if (this.hasArguments()) {
            stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this._argNames.length) {
                stringBuffer.append(" ");
                stringBuffer.append(this._argNames[n]);
                stringBuffer.append(" TERM");
                ++n;
            }
        }
        String string = "#" + this._name + " " + (this.hasCondition() ? "(CONDITION) " : "") + (this.hasTarget() ? "TARGET " : "") + (this.hasArguments() ? stringBuffer.toString() : "") + (this.isContainer() ? "{ ... } " : "");
        if (this.isMulti()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < this._dependents.length) {
                stringBuffer2.append(string);
                stringBuffer2.append("#");
                stringBuffer2.append(this._dependents[n]);
                stringBuffer2.append(" ...\n");
                ++n;
            }
            return stringBuffer2.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

