/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import org.webmacro.engine.Mark;
import org.webmacro.engine.ParseToolException;

final class ParseTool {
    Object[] asArg = new Object[]{this};
    private LineNumberReader _in;
    private String _name;
    private int _cur;
    private int _last;
    private int _len;
    private int _pos;
    private String _buf;
    private boolean _escaped = false;
    public final int MAX_MARKS = 4;
    public final int DUMMY_MARK = -1;
    private Mark[] _marks = new Mark[4];
    private int _marked = 0;
    static String lineSeparator;
    static final int EOF = -1;

    ParseTool(String string, InputStream inputStream) throws IOException {
        this(string, new InputStreamReader(inputStream));
    }

    ParseTool(String string, Reader reader) throws IOException {
        this._name = string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        this._pos = -1;
        this._len = -1;
        this._last = -1;
        this._cur = -1;
        this._buf = "";
        this._in = lineNumberReader;
        int n = 0;
        while (n < 4) {
            this._marks[n] = new Mark();
            ++n;
        }
        this.read();
        this.parseChar('\n');
    }

    final String getName() {
        return this._name;
    }

    public final String toString() {
        return this._name + ":" + this.getLineNumber();
    }

    public final int getLineNumber() {
        return this._in.getLineNumber();
    }

    public static final boolean isNameStartChar(int n) {
        return n != 36 && Character.isJavaIdentifierStart((char)n);
    }

    public final boolean isNameStartChar() {
        return ParseTool.isNameStartChar(this._cur);
    }

    public static final boolean isNameChar(int n) {
        return n != 36 && (n == 45 || n == 42 || n == 43 || Character.isJavaIdentifierPart((char)n));
    }

    public final boolean isNameChar() {
        return ParseTool.isNameChar(this._cur);
    }

    public static final boolean isNumberStartChar(int n) {
        switch (n) {
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public final boolean isNumberStartChar() {
        return ParseTool.isNumberStartChar(this._cur);
    }

    public static final boolean isNumberChar(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public final boolean isNumberChar() {
        return ParseTool.isNumberChar(this._cur);
    }

    public static final boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10;
    }

    public final boolean isWhitespace() {
        return ParseTool.isWhitespace(this._cur);
    }

    public static final boolean isSpace(int n) {
        return n == 32 || n == 9;
    }

    public final boolean isSpace() {
        return ParseTool.isSpace(this._cur);
    }

    private void read() {
        this.read(false);
    }

    private void read(boolean bl) {
        this._last = this._cur;
        this._escaped = false;
        if (this._pos < this._len) {
            this._cur = this._buf.charAt(this._pos++);
        } else {
            this._cur = this._buf != null ? 10 : -1;
            try {
                this._buf = this._in.readLine();
                this._buf.length();
                if (this._marked != 0) {
                    int n = 0;
                    while (n < 4) {
                        if (this._marks[n] != null) {
                            if (this._cur != -1) {
                                this._marks[n].buf.append((char)this._cur);
                            }
                            this._marks[n].buf.append(this._buf);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                this._buf = null;
            }
            this._pos = 0;
            int n = this._len = this._buf != null ? this._buf.length() : -1;
        }
        if (!bl && this._cur == 92) {
            this.read(true);
            this._escaped = true;
        }
    }

    boolean isAtEOF() {
        return this._buf == null;
    }

    boolean isEscaped() {
        return this._escaped;
    }

    public final int nextChar() {
        this.read();
        return this._cur;
    }

    public final int getChar() {
        return this._cur;
    }

    public final int lookBack() {
        return this._last;
    }

    public final int mark() throws ParseToolException {
        int n = 0;
        while (n < 4) {
            if (!this._marks[n].isSet) {
                this._marks[n].set(this._last, this._cur, this._escaped, this._pos, this._buf);
                ++this._marked;
                return n;
            }
            ++n;
        }
        throw new ParseToolException(this, "Tried to mark more than MAX_MARKS positions");
    }

    public final int rewind(int n) {
        if (n < 0 || n >= 4) {
            return -1;
        }
        Mark mark = this._marks[n];
        if (!mark.isSet) {
            return -1;
        }
        this._buf = mark.buf.toString();
        this._pos = 0;
        this._len = this._buf.length();
        this._last = -1;
        this._cur = mark.last;
        this._escaped = false;
        this._marks[n].isSet = false;
        --this._marked;
        this.read();
        return -1;
    }

    public final boolean isMarked() {
        return this._marked != 0;
    }

    public final int clearMark(int n) {
        if (n < 0 || n >= 4) {
            return -1;
        }
        if (!this._marks[n].isSet) {
            return -1;
        }
        this._marks[n].isSet = false;
        --this._marked;
        return -1;
    }

    public final void clearMarks() {
        int n = 0;
        while (n < 4) {
            this._marks[n].isSet = false;
            ++n;
        }
        this._marked = 0;
    }

    public final boolean skipToEOL() throws IOException {
        boolean bl = false;
        while ((this._cur != 10 || this._escaped) && this._cur != -1) {
            this.read();
            bl = true;
        }
        return bl;
    }

    public final boolean skipSpaces() throws IOException {
        boolean bl = false;
        while (ParseTool.isSpace(this._cur) && !this._escaped) {
            this.read();
            bl = true;
        }
        return bl;
    }

    public final boolean skipWhitespace() throws IOException {
        boolean bl = false;
        while (ParseTool.isWhitespace(this._cur) && !this._escaped) {
            this.read();
            bl = true;
        }
        return bl;
    }

    public final boolean parseChar(char c) throws IOException {
        if (this._cur == c && this._cur != -1 && !this._escaped) {
            this.read();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String parseName() throws IOException {
        if (!ParseTool.isNameStartChar(this._cur) && !this._escaped) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)this._cur);
        this.read();
        while (ParseTool.isNameChar((char)this._cur) || this._escaped) {
            stringBuffer.append((char)this._cur);
            this.read();
        }
        return stringBuffer.toString();
    }

    public final Object parseNumber() throws IOException, ParseToolException {
        Long l;
        Number number = null;
        if (!this.isNumberStartChar()) {
            return null;
        }
        this.parseChar('+');
        int n = this.mark();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char)this._cur);
            this.read();
            while (this.isNumberChar()) {
                stringBuffer.append((char)this._cur);
                this.read();
            }
            String string = stringBuffer.toString();
            try {
                if (this._cur == 108 || this._cur == 76) {
                    number = new Long(string);
                    this.read();
                } else {
                    number = new Integer(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.rewind(n);
            }
            l = number;
            Object var7_7 = null;
            this.clearMark(n);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.clearMark(n);
            throw throwable;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean parseString(String string) throws IOException, ParseToolException {
        boolean bl;
        int n = 0;
        int n2 = string.length();
        int n3 = this.mark();
        try {
            while (true) {
                if (n >= n2 || this._cur != string.charAt(n) || this._escaped) {
                    if (n2 != n) break;
                    boolean bl2 = true;
                    Object var7_7 = null;
                    this.clearMark(n3);
                    return bl2;
                }
                this.read();
                ++n;
            }
            if (n > 0) {
                this.rewind(n3);
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.clearMark(n3);
            throw throwable;
        }
        Object var7_8 = null;
        this.clearMark(n3);
        return bl;
    }

    public final String parseStrings(String[] stringArray) throws ParseToolException {
        String string = null;
        int n = -1;
        boolean[] blArray = new boolean[stringArray.length];
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            bl = false;
            if (this._escaped) break;
            if (n == -1) {
                n = this.mark();
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!blArray[n3] && n2 < stringArray[n3].length()) {
                    if (this._cur != stringArray[n3].charAt(n2)) {
                        blArray[n3] = true;
                    } else {
                        bl = true;
                        if (n2 + 1 == stringArray[n3].length()) {
                            string = stringArray[n3];
                            this.clearMark(n);
                            n = -1;
                            blArray[n3] = true;
                        }
                    }
                }
                ++n3;
            }
            if (!bl) continue;
            ++n2;
            this.read();
        }
        this.rewind(n);
        return string;
    }

    public final boolean parseUntil(StringBuffer stringBuffer, char c) throws IOException {
        boolean bl = false;
        while ((this._cur != c || this._escaped) && this._cur != -1) {
            stringBuffer.append((char)this._cur);
            this.read();
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void parseUntil(StringBuffer stringBuffer, String string) throws ParseToolException {
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        char c = string.charAt(0);
        int n = -1;
        stringBuffer.setLength(0);
        block2: while (true) {
            if (this._cur == -1) {
                this.clearMark(n);
                throw new ParseToolException(this, "Expected " + string + " but reached end of file");
            }
            if (this._cur == c) {
                Object var7_6;
                n = this.mark();
                try {
                    int n2 = 0;
                    while (true) {
                        if (n2 >= string.length()) {
                            stringBuffer.append(string);
                            break;
                        }
                        if (this._cur != string.charAt(n2)) {
                            this.rewind(n);
                            stringBuffer.append((char)this._cur);
                            this.read();
                            var7_6 = null;
                            this.clearMark(n);
                            continue block2;
                        }
                        this.read();
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    this.clearMark(n);
                    throw throwable;
                }
                var7_6 = null;
                this.clearMark(n);
                return;
            }
            stringBuffer.append((char)this._cur);
            this.read();
        }
    }

    static {
        String string;
        try {
            string = System.getProperty("line.separator").intern();
        }
        catch (Exception exception) {
            string = "\n".intern();
        }
        lineSeparator = string;
    }
}

