/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.util.Hashtable;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.servlet.Handler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.util.Log;

public final class HandlerProvider
implements ResourceProvider {
    public static final String TYPE = "handler";
    static final Log _log = new Log("handler", "handler provider mechanism");
    private Hashtable _handlers = new Hashtable();
    private static final String[] _types = new String[]{"handler"};

    public final int resourceThreads() {
        return 0;
    }

    public final String[] getTypes() {
        return _types;
    }

    public final int resourceExpireTime() {
        return 1200000;
    }

    public final void resourceRequest(RequestResourceEvent requestResourceEvent) {
        Handler handler = null;
        String string = requestResourceEvent.getName();
        try {
            handler = (Handler)this._handlers.get(string);
            if (handler == null) {
                String string2 = string.substring(string.lastIndexOf(47) + 1);
                Class<?> clazz = Class.forName(string2);
                handler = (Handler)clazz.newInstance();
                handler.init();
                this._handlers.put(string, handler);
            }
            requestResourceEvent.set(handler);
        }
        catch (HandlerException handlerException) {
            _log.exception(handlerException);
            String string3 = "Unable to initialize your handler due to exception: " + handlerException;
            _log.warning(string3);
        }
        catch (Exception exception) {
            _log.exception(exception);
            String string4 = "Reactor: Unable to create handler for script name: " + string + "... this may be because your handler is not in your CLASSPATH," + " or that you have not registered WebMacro as the handler for " + " the name " + string + " in servlet.properties (or equiv.).";
            _log.warning(string4);
        }
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public final void destroy() {
    }

    public void init(ResourceBroker resourceBroker) {
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }
}

