/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.configuration.Configuration;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class ClasspathResourceLoader
extends ResourceLoader {
    public void init(Configuration configuration) {
        Runtime.info("ClasspathResourceLoader : initialization starting.");
        Runtime.info("ClasspathResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("No template name provided");
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            result = classLoader.getResourceAsStream(name);
        }
        catch (Exception fnfe) {
            throw new ResourceNotFoundException(fnfe.getMessage());
        }
        return result;
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

