/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed"};
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private File listing;
    private boolean binary = true;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(String action) throws BuildException {
        if (action.toLowerCase().equals("send") || action.toLowerCase().equals("put")) {
            this.action = 0;
        } else if (action.toLowerCase().equals("recv") || action.toLowerCase().equals("get")) {
            this.action = 1;
        } else if (action.toLowerCase().equals("del") || action.toLowerCase().equals("delete")) {
            this.action = 2;
        } else if (action.toLowerCase().equals("list")) {
            this.action = 3;
        } else {
            throw new BuildException("action " + action + " is not supported");
        }
    }

    public void setListing(File listing) throws BuildException {
        this.listing = listing;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
    }

    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        FTPDirectoryScanner ds;
        if (this.action == 0) {
            DirectoryScanner directoryScanner = fs.getDirectoryScanner(this.project);
        } else {
            FTP fTP = this;
            if (fTP == null) {
                throw null;
            }
            ds = fTP.new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.project);
            ds.scan();
        }
        String[] dsfiles = ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        if (this.action == 3) {
            File pd = new File(this.listing.getParent());
            if (!pd.exists()) {
                pd.mkdirs();
            }
            bw = new BufferedWriter(new FileWriter(this.listing));
        }
        int i = 0;
        while (i < dsfiles.length) {
            switch (this.action) {
                case 0: {
                    this.sendFile(ftp, dir, dsfiles[i]);
                    break;
                }
                case 1: {
                    this.getFile(ftp, dir, dsfiles[i]);
                    break;
                }
                case 2: {
                    this.delFile(ftp, dsfiles[i]);
                    break;
                }
                case 3: {
                    this.listFile(ftp, bw, dsfiles[i]);
                    break;
                }
                default: {
                    throw new BuildException("unknown ftp action " + this.action);
                }
            }
            ++i;
        }
        if (this.action == 3) {
            bw.close();
        }
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.transferFiles(ftp, fs);
            }
            ++i;
        }
        this.log(this.transferred + " files " + COMPLETED_ACTION_STRS[this.action]);
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    /*
     * WARNING - void declaration
     */
    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        String dirname;
        Vector<File> parents = new Vector<File>();
        File dir = new File(filename);
        while ((dirname = dir.getParent()) != null) {
            void var5_5;
            dir = new File((String)var5_5);
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        while (i >= 0) {
            dir = (File)parents.elementAt(i);
            if (!this.dirCache.contains(dir)) {
                this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                ftp.makeDirectory(this.resolveFile(dir.getPath()));
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode()) && ftp.getReplyCode() != 550) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                this.dirCache.addElement(dir);
            }
            --i;
        }
    }

    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        if (files == null) {
            return false;
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        if (this.action == 0) {
            return remoteTimestamp > localTimestamp;
        }
        return localTimestamp > remoteTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        instream = null;
        try {
            file = this.project.resolveFile(new File(dir, filename).getPath());
            if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block11;
            var6_7 = null;
            ** if (instream == null) goto lbl-1000
        }
        catch (Throwable var5_10) {
            var6_9 = null;
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw var5_10;
        }
lbl-1000:
        // 1 sources

        {
            try {
                instream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
lbl-1000:
        // 3 sources

        {
            block11: {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + file.getAbsolutePath());
            }
            instream = new BufferedInputStream(new FileInputStream(file));
            this.createParents(ftp, filename);
            ftp.storeFile(this.resolveFile(filename), instream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("could not transfer file: " + ftp.getReplyString());
            }
            this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
            ++this.transferred;
        }
        var6_8 = null;
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            throw new BuildException("could not delete file: " + ftp.getReplyString());
        }
        this.log("File " + filename + " deleted from " + this.server, 3);
        ++this.transferred;
    }

    /*
     * Unable to fully structure code
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        outstream = null;
        try {
            file = this.project.resolveFile(new File(dir, filename).getPath());
            if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block12;
            var6_7 = null;
            ** if (outstream == null) goto lbl-1000
        }
        catch (Throwable var5_11) {
            var6_9 = null;
            if (outstream != null) {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw var5_11;
        }
lbl-1000:
        // 1 sources

        {
            try {
                outstream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
lbl-1000:
        // 3 sources

        {
            block12: {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + filename + " to " + file.getAbsolutePath());
            }
            if (!(pdir = new File(file.getParent())).exists()) {
                pdir.mkdirs();
            }
            outstream = new BufferedOutputStream(new FileOutputStream(file));
            ftp.retrieveFile(this.resolveFile(filename), outstream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("could not transfer file: " + ftp.getReplyString());
            }
            this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
            ++this.transferred;
        }
        var6_8 = null;
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("listing " + filename);
        }
        FTPFile ftpfile = ftp.listFiles(this.resolveFile(filename))[0];
        bw.write(ftpfile.toString());
        bw.newLine();
        ++this.transferred;
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        FTPClient ftp = null;
        try {
            try {
                this.log("Opening FTP connection to " + this.server, 3);
                ftp = new FTPClient();
                ftp.connect(this.server, this.port);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("FTP connection failed: " + ftp.getReplyString());
                }
                this.log("connected", 3);
                this.log("logging in to FTP server", 3);
                if (!ftp.login(this.userid, this.password)) {
                    throw new BuildException("Could not login to FTP server");
                }
                this.log("login succeeded", 3);
                if (this.binary) {
                    ftp.setFileType(2);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                    }
                }
                if (this.remotedir != null) {
                    this.log("changing the remote directory", 3);
                    ftp.changeWorkingDirectory(this.remotedir);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                    }
                }
                this.log(ACTION_STRS[this.action] + " files");
                this.transferFiles(ftp);
            }
            catch (IOException ex) {
                throw new BuildException("error during FTP transfer: " + ex);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.scandir(".", "", true);
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                FTPFile[] newfiles = this.ftp.listFiles();
                if (newfiles == null) {
                    return;
                }
                int i = 0;
                while (i < newfiles.length) {
                    FTPFile file = newfiles[i];
                    String name = vpath + file.getName();
                    if (file.isDirectory()) {
                        if (this.isIncluded(name)) {
                            if (!this.isExcluded(name)) {
                                this.dirsIncluded.addElement(name);
                                if (fast) {
                                    this.scandir(name, name + File.separator, fast);
                                }
                            } else {
                                this.dirsExcluded.addElement(name);
                            }
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(name, name + File.separator, fast);
                            }
                        }
                        if (!fast) {
                            this.scandir(name, name + File.separator, fast);
                        }
                    } else if (file.isFile()) {
                        if (this.isIncluded(name)) {
                            if (!this.isExcluded(name)) {
                                this.filesIncluded.addElement(name);
                            } else {
                                this.filesExcluded.addElement(name);
                            }
                        } else {
                            this.filesNotIncluded.addElement(name);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
        }
    }
}

