/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.xml.DOMConfigurator;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static StringBuffer sbuf = new StringBuffer();
    private static /* synthetic */ Class class$Lorg$apache$log4j$spi$Configurator;

    public static String[] concatanateArrays(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length + stringArray2.length;
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String convertSpecialChars(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 110) {
                    n3 = 10;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 8) {
                    n3 = 8;
                } else if (n3 == 34) {
                    n3 = 34;
                } else if (n3 == 39) {
                    n3 = 39;
                } else if (n3 == 92) {
                    n3 = 92;
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static Object instantiateByKey(Properties properties, String string, Class clazz, Object object) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            LogLog.error("Could not find value for key " + string);
            return object;
        }
        return OptionConverter.instantiateByClassName(string2.trim(), clazz, object);
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        String string2 = string.trim();
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public static int toInt(String string, int n) {
        if (string != null) {
            String string2 = string.trim();
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string2 + "] is not in proper int form.");
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }

    public static long toFileSize(String string, long l) {
        if (string == null) {
            return l;
        }
        String string2 = string.trim().toUpperCase();
        long l2 = 1L;
        int n = string2.indexOf("KB");
        if (n != -1) {
            l2 = 1024L;
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf("MB");
            if (n != -1) {
                l2 = 0x100000L;
                string2 = string2.substring(0, n);
            } else {
                n = string2.indexOf("GB");
                if (n != -1) {
                    l2 = 0x40000000L;
                    string2 = string2.substring(0, n);
                }
            }
        }
        if (string2 != null) {
            try {
                return Long.valueOf(string2) * l2;
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string2 + "] is not in proper int form.");
                LogLog.error("[" + string + "] not in expected format.", numberFormatException);
            }
        }
        return l;
    }

    public static String findAndSubst(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(string2, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.error("Bad option value [" + string2 + "].", illegalArgumentException);
            return string2;
        }
    }

    public static Object instantiateByClassName(String string, Class clazz, Object object) {
        if (string != null) {
            try {
                Class<?> clazz2 = Class.forName(string);
                if (!clazz.isAssignableFrom(clazz2)) {
                    LogLog.error("A \"" + string + "\" object is not assignable to a \"" + clazz.getName() + "\" object.");
                }
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                LogLog.error("Could not instantiate class [" + string + "].", exception);
            }
        }
        return object;
    }

    public static String substVars(String string, Properties properties) throws IllegalArgumentException {
        sbuf.setLength(0);
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(DELIM_START, n)) == -1) {
                if (n == 0) {
                    return string;
                }
                sbuf.append(string.substring(n, string.length()));
                return sbuf.toString();
            }
            sbuf.append(string.substring(n, n2));
            int n3 = string.indexOf(DELIM_STOP, n2);
            if (n3 == -1) {
                throw new IllegalArgumentException("\"" + string + "\" has no closing brace. Opening brace at position " + n2 + ".");
            }
            String string2 = string.substring(n2 += DELIM_START_LEN, n3);
            String string3 = System.getProperty(string2);
            if (string3 == null && properties != null) {
                string3 = properties.getProperty(string2);
            }
            if (string3 != null) {
                sbuf.append(string3);
            }
            n = n3 + DELIM_STOP_LEN;
        }
    }

    public static void selectAndConfigure(URL uRL, Hierarchy hierarchy) {
        String string = uRL.getRef();
        Configurator configurator = null;
        if (string != null) {
            LogLog.debug("Preferred configurator class: " + string);
            configurator = (Configurator)OptionConverter.instantiateByClassName(string, class$Lorg$apache$log4j$spi$Configurator != null ? class$Lorg$apache$log4j$spi$Configurator : (class$Lorg$apache$log4j$spi$Configurator = OptionConverter.class$("org.apache.log4j.spi.Configurator")), null);
            if (configurator == null) {
                LogLog.error("Could not instantiate configurator [" + string + "].");
                return;
            }
        } else {
            String string2 = uRL.getFile();
            if (string2 != null && string2.endsWith(".xml")) {
                try {
                    configurator = new DOMConfigurator();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    LogLog.warn("Could not find DOMConfigurator!", noClassDefFoundError);
                    return;
                }
            } else {
                configurator = new PropertyConfigurator();
            }
        }
        configurator.doConfigure(uRL, hierarchy);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private OptionConverter() {
    }
}

