#!/bin/sh

#--------------------------------------------
# No need to edit anything past here
#--------------------------------------------
if test -z "${JAVA_HOME}" ; then
    echo "ERROR: JAVA_HOME not found in your environment."
    echo "Please, set the JAVA_HOME variable in your environment to match the"
    echo "location of the Java Virtual Machine you want to use."
    exit
fi

if test -f ${JAVA_HOME}/lib/tools.jar ; then
    CLASSPATH=${CLASSPATH}:${JAVA_HOME}/lib/tools.jar
fi

# convert the existing path to unix
if [ "$OSTYPE" = "cygwin32" ] || [ "$OSTYPE" = "cygwin" ] ; then
   CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

for i in ant*.jar
do
    ANT_JAR=${ANT_JAR}:$i
done

# OSX hack to make it work with jikes
OSXHACK="/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Classes"
if [ -d ${OSXHACK} ] ; then 
for i in ${OSXHACK}/*.jar
do
    CLASSPATH=${CLASSPATH}:$i
done
fi

XERCES_JAR=`ls ../lib/xerces*.jar`
VELOCITY_JAR=`ls ../lib/velocity*.jar`
JDOM_JAR=`ls ../../jakarta-site2/lib/jdom*.jar`

CLASSPATH=${CLASSPATH}:${ANT_JAR}
CLASSPATH=${CLASSPATH}:${XERCES_JAR}
CLASSPATH=${CLASSPATH}:${VELOCITY_JAR}
CLASSPATH=${CLASSPATH}:${JDOM_JAR}

# convert the unix path to windows
if [ "$OSTYPE" = "cygwin32" ] || [ "$OSTYPE" = "cygwin" ] ; then
   CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
fi

BUILDFILE=build-turbine.xml

${JAVA_HOME}/bin/java -classpath ${CLASSPATH} org.apache.tools.ant.Main \
                      -buildfile ${BUILDFILE} "$@"
