/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Duration;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class IncrementDurationAction extends Action{
    public static final String NAME = "action.note.duration.increment-duration";    
    
    public IncrementDurationAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        //comienza el undoable
    	UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo(); 
        
        Duration duration = getEditor().getTablature().getCaret().getDuration();
        if(duration.getValue() < Duration.SIXTY_FOURTH){        	
            this.changeDuration(duration.getValue() * 2);
            updateTablature();                
        }
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());      
        
        return true;
    }
    
    private void changeDuration(int value) {
        Caret caret = getEditor().getTablature().getCaret();      
        caret.getDuration().setValue(value);
        caret.getDuration().setDotted(false);
        caret.getDuration().setDoubleDotted(false);
        //caret.getDuration().getTupleto().setEnters(1);
        //caret.getDuration().getTupleto().setTimes(1);        
        caret.changeDuration((Duration)caret.getDuration().clone());        
    }    
    
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());        
        redraw();
    }   


}
