/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    private List measureHeaders;
    
    public SongCoords(Tablature tablature,SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }	

    public void init(){
        this.tracksCoords = new ArrayList();
        this.measureHeaders = new ArrayList();
    }    

    public void create(int tracks,int measures){
        this.tracksCoords = new ArrayList(tracks);
        this.measureHeaders = new ArrayList(measures);
    }        
    
    public SongTrackCoords getTrackAt(int y){
    	int number = this.tablature.getViewLayout().getTrackNumberAt(this.tracksCoords,y);
    	if(number >= 0){
    		return getTrack(number);
    	}
    	return null;
    }
    
    public SongTrackCoords getTrack(int number){
        SongTrackCoords trackCoords = null;        
        for (int i = 0; i < this.tracksCoords.size(); i++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(i);            
            if(currTrack.getTrack().getNumber() == number){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;        
    }
    
    public SongTrackCoords getNextTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int nextIndex = trackIdx + 1;
                if(nextIndex < this.tracksCoords.size()){
                    track = (SongTrackCoords)this.tracksCoords.get(nextIndex);                    
                }
                break;
            }
        }     
        return track;
    }
    
    public SongTrackCoords getPrevTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int prevIndex = trackIdx - 1;
                if(prevIndex >= 0){
                    track = (SongTrackCoords)this.tracksCoords.get(prevIndex);                    
                }
                break;
            }
        }     
        return track;
    }    
    
    public SongTrackCoords getTrack(SongTrack songTrack){
        SongTrackCoords trackCoords = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.getTrack().equals(songTrack)){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;
    }        

    public SongTrackCoords getFirstTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return track;
    }       

    public SongTrackCoords getLastTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return track;
    }               
 
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public List getTrackCoords(){
        return this.tracksCoords;
    }

	public SongTrackCoords getTrackByIndex(int index) {
		if(tracksCoords.size() > index){                                
    		return (SongTrackCoords)tracksCoords.get(index);
        }		
		SongTrackCoords track = new SongTrackCoords(tablature,songManager,songManager.getTrack(index + 1),tablature.getViewLayout());
		tracksCoords.add(track);
		return track;
	}    
    
	public MeasureHeaderGui getHeaderByIndex(int index) {
		if(measureHeaders.size() > index){                                
    		return (MeasureHeaderGui)measureHeaders.get(index);
        }
		MeasureHeaderGui header = new MeasureHeaderGui(songManager.getMeasureHeader(index + 1));
		measureHeaders.add(header);
		return header;
	}
    
	
	public void disposeTracks(){
    	//dispose old measures
        for (int i = 0; i < tracksCoords.size(); i++) {
            SongTrackCoords trackCoords = (SongTrackCoords)tracksCoords.get(i);
            for (int j = 0; j < trackCoords.getMeasuresCoords().size(); j++) {
            	MeasureCoords measure = (MeasureCoords)trackCoords.getMeasuresCoords().get(j);
            	measure.dispose();
            }
        }
    }	
}