/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDoubleDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetEighthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetHalfDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetQuarterDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixteenthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixtyFourthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetThirtySecondDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetWholeDurationAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Duration;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DurationMenuItem  implements MenuItems{
    private TablatureEditor tablatureEditor;
    private Shell shell;
    private MenuItem durationMenuItem;
    private Menu menu; 
    private MenuItem whole;
    private MenuItem half;
    private MenuItem quarter;
    private MenuItem eighth;
    private MenuItem sixteenth;
    private MenuItem thirtySecond;
    private MenuItem sixtyFourth;
    private MenuItem dotted;
    private MenuItem doubleDotted;
    private MenuItem tupleto;
    
    public DurationMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.durationMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.shell = shell;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--whole--
        this.whole = new MenuItem(this.menu, SWT.PUSH);
        this.whole.setImage(SystemImages.getDuration(Duration.WHOLE));
        this.whole.addSelectionListener(TuxGuitar.instance().getAction(SetWholeDurationAction.NAME));
        //--half--
        this.half = new MenuItem(this.menu, SWT.PUSH);
        this.half.setImage(SystemImages.getDuration(Duration.HALF));
        this.half.addSelectionListener(TuxGuitar.instance().getAction(SetHalfDurationAction.NAME));
        //--quarter--
        this.quarter = new MenuItem(this.menu, SWT.PUSH);
        this.quarter.setImage(SystemImages.getDuration(Duration.QUARTER));
        this.quarter.addSelectionListener(TuxGuitar.instance().getAction(SetQuarterDurationAction.NAME));
        //--Eighth--
        this.eighth = new MenuItem(this.menu, SWT.PUSH);
        this.eighth.setImage(SystemImages.getDuration(Duration.EIGHTH));
        this.eighth.addSelectionListener(TuxGuitar.instance().getAction(SetEighthDurationAction.NAME));
        //--sixteenth--
        this.sixteenth = new MenuItem(this.menu, SWT.PUSH);
        this.sixteenth.setImage(SystemImages.getDuration(Duration.SIXTEENTH));
        this.sixteenth.addSelectionListener(TuxGuitar.instance().getAction(SetSixteenthDurationAction.NAME));
        //--thirtySecond--
        this.thirtySecond = new MenuItem(this.menu, SWT.PUSH);
        this.thirtySecond.setImage(SystemImages.getDuration(Duration.THIRTY_SECOND));
        this.thirtySecond.addSelectionListener(TuxGuitar.instance().getAction(SetThirtySecondDurationAction.NAME));       
        //--sixtyFourth--
        this.sixtyFourth = new MenuItem(this.menu, SWT.PUSH);
        this.sixtyFourth.setImage(SystemImages.getDuration(Duration.SIXTY_FOURTH));
        this.sixtyFourth.addSelectionListener(TuxGuitar.instance().getAction(SetSixtyFourthDurationAction.NAME));
                                
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);        
        
        //--dotted---
        this.dotted = new MenuItem(this.menu, SWT.PUSH);
        this.dotted.setImage(SystemImages.DOTTED_IMAGE);
        this.dotted.addSelectionListener(TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));        
        
        this.doubleDotted = new MenuItem(this.menu, SWT.PUSH);
        this.doubleDotted.setImage(SystemImages.DOUBLE_DOTTED_IMAGE);
        this.doubleDotted.addSelectionListener(TuxGuitar.instance().getAction(ChangeDoubleDottedDurationAction.NAME));        
        
        //--tupleto---
        this.tupleto = new MenuItem(this.menu, SWT.PUSH);
        this.tupleto.setImage(SystemImages.TUPLETO_IMAGE);
        this.tupleto.addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));        
                
        this.durationMenuItem.setMenu(menu);       
        
        this.loadProperties();
    }

    public void update(){        
    }
    
    public void loadProperties(){
        this.durationMenuItem.setText(TuxGuitar.getProperty("duration"));  
        this.whole.setText(TuxGuitar.getProperty("duration.whole"));  
        this.half.setText(TuxGuitar.getProperty("duration.half"));  
        this.quarter.setText(TuxGuitar.getProperty("duration.quarter"));
        this.eighth.setText(TuxGuitar.getProperty("duration.eighth"));  
        this.sixteenth.setText(TuxGuitar.getProperty("duration.sixteenth"));  
        this.thirtySecond.setText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.sixtyFourth.setText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupleto.setText(TuxGuitar.getProperty("duration.tupleto"));
    }     
}
