/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDoubleDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetEighthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetHalfDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetQuarterDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixteenthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixtyFourthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetThirtySecondDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetWholeDurationAction;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DurationToolItems  extends ToolItems{
    public static final String NAME = "duration.items";
    private ToolBar toolBar;   
    private ToolItem[] durationItems; 
    private ToolItem dotted;
    private ToolItem doubleDotted;
    private TupletoMenuItem tupletoItems;
    
    public DurationToolItems(){    
    	super(NAME);   
    }
   

    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;          
    	this.durationItems = new ToolItem[7];
    	
        durationItems[0] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[0].setImage(SystemImages.getDuration(Duration.WHOLE));
        durationItems[0].setToolTipText("Redonda");        
        durationItems[0].addSelectionListener(TuxGuitar.instance().getAction(SetWholeDurationAction.NAME));
        
        durationItems[1] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[1].setImage(SystemImages.getDuration(Duration.HALF));
        durationItems[1].setToolTipText("Blanca");        
        durationItems[1].addSelectionListener(TuxGuitar.instance().getAction(SetHalfDurationAction.NAME));
        
        durationItems[2] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[2].setImage(SystemImages.getDuration(Duration.QUARTER));
        durationItems[2].setToolTipText("Negra");
        durationItems[2].setSelection(true);
        durationItems[2].addSelectionListener(TuxGuitar.instance().getAction(SetQuarterDurationAction.NAME));
        
        durationItems[3] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[3].setImage(SystemImages.getDuration(Duration.EIGHTH));
        durationItems[3].setToolTipText("Corchea");
        durationItems[3].addSelectionListener(TuxGuitar.instance().getAction(SetEighthDurationAction.NAME));
        
        durationItems[4] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[4].setImage(SystemImages.getDuration(Duration.SIXTEENTH));
        durationItems[4].setToolTipText("Semi-Corchea");
        durationItems[4].addSelectionListener(TuxGuitar.instance().getAction(SetSixteenthDurationAction.NAME));
        
        durationItems[5] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[5].setImage(SystemImages.getDuration(Duration.THIRTY_SECOND));
        durationItems[5].setToolTipText("Fusa");
        durationItems[5].addSelectionListener(TuxGuitar.instance().getAction(SetThirtySecondDurationAction.NAME));
        
        durationItems[6] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[6].setImage(SystemImages.getDuration(Duration.SIXTY_FOURTH));
        durationItems[6].setToolTipText("Semi-Fusa");
        durationItems[6].addSelectionListener(TuxGuitar.instance().getAction(SetSixtyFourthDurationAction.NAME));        
        
        new ToolItem(toolBar, SWT.SEPARATOR);
        
        dotted = new ToolItem(toolBar, SWT.CHECK);
        dotted.setImage(SystemImages.DOTTED_IMAGE);
        dotted.setToolTipText("Puntillo");
        dotted.addSelectionListener(TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
        
        doubleDotted = new ToolItem(toolBar, SWT.CHECK);
        doubleDotted.setImage(SystemImages.DOUBLE_DOTTED_IMAGE);
        doubleDotted.setToolTipText("Doble Puntillo");
        doubleDotted.addSelectionListener(TuxGuitar.instance().getAction(ChangeDoubleDottedDurationAction.NAME));
                
        tupletoItems = new TupletoMenuItem();        
        tupletoItems.addItems();
        
        
        loadProperties();
    }

    
    public void update(){
        Duration duration = getEditor().getTablature().getCaret().getDuration();
        
        for(int i = 0;i < this.durationItems.length;i++){
            this.durationItems[i].setSelection(false);
        }        
        
        int index = 0;
        int value = duration.getValue();        
        while(value > 1){
            value = value / 2;
            index ++;
        }
        this.durationItems[index].setSelection(true);
        this.dotted.setSelection(duration.isDotted());
        this.doubleDotted.setSelection(duration.isDoubleDotted());
        
        this.tupletoItems.update();
    }
    
    
    public void loadProperties(){
        this.durationItems[0].setToolTipText(TuxGuitar.getProperty("duration.whole"));  
        this.durationItems[1].setToolTipText(TuxGuitar.getProperty("duration.half"));  
        this.durationItems[2].setToolTipText(TuxGuitar.getProperty("duration.quarter"));
        this.durationItems[3].setToolTipText(TuxGuitar.getProperty("duration.eighth"));  
        this.durationItems[4].setToolTipText(TuxGuitar.getProperty("duration.sixteenth"));  
        this.durationItems[5].setToolTipText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.durationItems[6].setToolTipText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setToolTipText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setToolTipText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupletoItems.setText(TuxGuitar.getProperty("duration.tupleto"));
    }    
    
    
    private class TupletoMenuItem extends SelectionAdapter {
        private ToolItem tupleto;
        private Menu subMenu;
        private MenuItem[] subMenuItems;
        
        public TupletoMenuItem() {
            this.tupleto = new ToolItem(toolBar, SWT.DROP_DOWN);
            this.tupleto.setImage(SystemImages.TUPLETO_IMAGE);
            
            this.tupleto.addSelectionListener(this);
            this.tupleto.setData(new Tupleto(3,2));
            
            this.subMenu = new Menu(this.tupleto.getParent().getShell());
        }

        public void setText(String text){
            this.tupleto.setToolTipText(text);
        }
        
        public void addItems() {
          this.subMenuItems = new MenuItem[8];
            
          this.subMenuItems[0] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[0].setText("3");
          this.subMenuItems[0].setData(new Tupleto(3,2));
          this.subMenuItems[0].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[1] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[1].setText("5");
          this.subMenuItems[1].setData(new Tupleto(5,4));
          this.subMenuItems[1].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));          
          
          this.subMenuItems[2] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[2].setText("6");
          this.subMenuItems[2].setData(new Tupleto(6,4));
          this.subMenuItems[2].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[3] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[3].setText("7");
          this.subMenuItems[3].setData(new Tupleto(7,4));
          this.subMenuItems[3].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[4] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[4].setText("9");
          this.subMenuItems[4].setData(new Tupleto(9,8));
          this.subMenuItems[4].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[5] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[5].setText("10");
          this.subMenuItems[5].setData(new Tupleto(10,8));
          this.subMenuItems[5].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[6] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[6].setText("11");
          this.subMenuItems[6].setData(new Tupleto(11,8));
          this.subMenuItems[6].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
          
          this.subMenuItems[7] = new MenuItem(this.subMenu, SWT.CHECK);
          this.subMenuItems[7].setText("12");
          this.subMenuItems[7].setData(new Tupleto(12,8));
          this.subMenuItems[7].addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));                 
        }

        public void widgetSelected(SelectionEvent event) {
          if (event.detail == SWT.ARROW) {            
            ToolItem item = (ToolItem) event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            this.subMenu.setLocation(pt.x, pt.y + rect.height);
            this.subMenu.setVisible(true);
          }else{
              Duration duration = getEditor().getTablature().getCaret().getDuration();
              if(duration.getTupleto().isEqual(Duration.NO_TUPLETO)){
                  ((Tupleto)this.tupleto.getData()).setEnters(3);
                  ((Tupleto)this.tupleto.getData()).setTimes(2);                  
              }else{
                  ((Tupleto)this.tupleto.getData()).setEnters(1);
                  ((Tupleto)this.tupleto.getData()).setTimes(1);  
              }
              TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME).process(event);
              update();
          }
        }
        
        
        
        public void update(){
            Duration duration = getEditor().getTablature().getCaret().getDuration();
            
            for(int i = 0;i < this.subMenuItems.length;i++){                               
                Tupleto tupleto = (Tupleto)this.subMenuItems[i].getData();
                this.subMenuItems[i].setSelection((tupleto.isEqual(duration.getTupleto())));
            }
        }  
        
      }        
    
}

