package org.herac.tuxguitar.player.impl;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

import org.herac.tuxguitar.song.models.TimeSignature;

public class MidiMessageUtils {
	
	public static final byte TICK_MOVE = 0x01;
	
	private static int getValue(int value){
		value = (value > 127)?127:value;
		value = (value < 0)?0:value;		
		return value;
	}
	
	private static int getChannel(int channel){
		channel = (channel > 15)?15:channel;
		channel = (channel < 0)?0:channel;		
		return channel;
	}
	
	public static MidiMessage noteOn(int channel,int note,int velocity){				
		try {
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.NOTE_ON, getChannel(channel), getValue(note), getValue(velocity));
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MidiMessage noteOff(int channel,int note,int velocity){				
		try {			
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.NOTE_OFF, getChannel(channel), getValue(note), getValue(velocity));
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}	
	
	public static MidiMessage controlChange(int channel,int controller,int value){				
		try {
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.CONTROL_CHANGE,getChannel(channel),getValue(controller), getValue(value));
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MidiMessage programChange(int channel,int instrument){				
		try {
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.PROGRAM_CHANGE, getChannel(channel), getValue(instrument), 0);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MidiMessage pitchBend(int channel,int value){				
		try {
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.PITCH_BEND, getChannel(channel), 0, getValue(value));
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
		
	public static MidiMessage systemReset(){				
		try {
			ShortMessage message = new ShortMessage();
			message.setMessage(ShortMessage.SYSTEM_RESET);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}	
	
	public static MidiMessage tempoInUSQ(int usq){				
		try {
			MetaMessage message = new MetaMessage();
	        message.setMessage(0x51, new byte[]{ (byte)((usq >> 16) & 0x00FF),(byte)((usq >> 8) & 0x00FF),(byte)((usq) & 0x00FF) }, 3);	        
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;		
	}
	
	public static MidiMessage timeSignature(TimeSignature ts){				
		try {			
			MetaMessage message = new MetaMessage();
	        message.setMessage(0x58, new byte[]{  (byte)ts.getNumerator(),(byte)ts.getDenominator().log2(),(byte)(96 / ts.getDenominator().getValue()),8 }, 4);	        
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;		
	}		
	
	public static MidiMessage tickMove(long move){				
		try {						
			byte[] data = new byte[]{ (byte) (move & 0x00FF),
									  (byte) ((move >> 8) & 0x000000FF),
									  (byte) ((move >> 16) & 0x000000FF),
									  (byte) ((move >> 24) & 0x000000FF),
									  (byte) ((move >> 32) & 0x000000FF),
									  (byte) ((move >> 40) & 0x000000FF),
									  (byte) ((move >> 48) & 0x000000FF),
									  (byte) ((move >> 56) & 0x000000FF) 
			};			
			MetaMessage message = new MetaMessage();	        
			message.setMessage(TICK_MOVE, data,data.length);	 			
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;		
	}	
}