#!/bin/bash
#
#  multistation-audio-gen-conf.sh
#
# Author:
#  Jason Kim <jason@userful.com>
# 
# Description:
#  - Create ~/.asoundrc, ~/.pulse/default.pa & ~/.pulse/daemon.conf
#  - pulseaudio daemon will use the configurations located at home directory if exist.

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

echo "`date +"%b %d %T"` $ProgramName: Found pulseaudio. Set .asoundrc and .default.pa" >> $logfile

ALSA_CARD=$1

##
## ~/.asoundrc
echo '
pcm.card0 {
    type hw
    card '$ALSA_CARD'
}

pcm.sound-in {
    type asym
    playback.pcm "pulse"
    capture.pcm "card0"
}
pcm.sound-out {
    type pulse
}
pcm.ringing {
    type pulse
}

pcm.!default {
    type pulse
}

ctl.!default {
    type pulse
}'  > ~/.asoundrc

##
## Check ~/.pulse/ directory
if [ ! -d ~/.pulse ]; then
    mkdir ~/.pulse
fi

##
## ~/.pulse/default.pa
echo '
#!/usr/bin/pulseaudio -nF

# load sink with assigned ALSA device
# Do not set source for skype
load-module module-alsa-sink device=hw:'$ALSA_CARD'
#load-module module-alsa-source device=hw:'$ALSA_CARD'
load-module module-native-protocol-unix

# Set volume of first sink index
set-sink-volume 0 45000
' > ~/.pulse/default.pa

##
## ~/.pulse/default.pa
echo '
default-fragments = 8
default-fragment-size-msec = 5
' > ~/.pulse/daemon.conf
