#!/bin/bash
#
# Copyright (c) 2004-2007 by Userful Corporation 
#
# Name: usbinput-reconfig.sh
# Author: Jason Kim
# Description:
#  - reconfigure all input devices.
#  - reset the type of device configuration to 'dynamic'
#
#######################################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
NUMOFSTATIONS=
CURRENTDM=
CURRENTXTYPE=
LOCK_FILE="/tmp/usbinput.lock"

if [ -f /opt/userful/bin/xkeepalive ]; then
    KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [ -f /opt/userful/bin/keepalive ]; then
    KEEPALIVE="/opt/userful/bin/keepalive"
fi

#################################
# Check if user has root access...
#################################
if [ ! -r /proc/kmsg ]; then
    echo ""
    echo "   You must be logged in as Root to run this program."
    echo ""
    exit 1
fi

#####################################################################
# Log for Press-Fkey program is located at /var/log/userful directory
#####################################################################
if [ ! -d /var/log/userful ]; then
	mkdir /var/log/userful
fi

################################
# Get the current station number
################################
# Availble video heads
ALL_HEAD=`cat /etc/X11/stations`
# Station number
S_NUM=`cat /etc/stations`
if [ $S_NUM -ge $ALL_HEAD ]; then
	NUMOFSTATIONS=$ALL_HEAD
else
	NUMOFSTATIONS=$S_NUM
fi

#################################################
# Reset the device config type (Default: dynamic)
#################################################
# Remove the static config file
if [[ -f /etc/usbinput.static ]]; then
    rm -f /etc/usbinput.static
fi

if [[ -x /opt/userful/bin/userful-input-command.sh ]]; then
	/opt/userful/bin/userful-input-command.sh -static disable
fi

#####################
# reset the usbinput
#####################
while ! (set -C; : > $LOCK_FILE) 2> /dev/null; do
	sleep 0.2
done

: > /etc/usbinput.tmp

if [ -e /etc/usbinput ]; then
	while read USBINPUT; do

		if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	   		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
		fi
    	echo $USBINPUT >> /etc/usbinput.tmp
	done < /etc/usbinput

	# update /etc/usbinput
	rm -f /etc/usbinput
	cp -f /etc/usbinput.tmp /etc/usbinput

	# update /etc/X11/Xinput/configstat
	/opt/userful/bin/make-config-file -r
else
	/opt/userful/bin/make-config-file -r
fi

# Check Mandatory device
if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
    /opt/userful/bin/umx-mandatory-dev-refresh.sh
fi

rm -f $LOCK_FILE

echo "`date +"%b %d %T"` $ProgramName: Device reassignment" >> $logfile

#/usr/bin/killall -s USR1 userful-usbinput-config

###########################
# Start Press-Fkey program
###########################
# Check current Display Manager
if [ -e /etc/userful/currentdm ]; then
	source /etc/userful/currentdm
	if [ -z "$CURRENTDM" ]; then
		CURRENTDM=gdm
	fi
fi

if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
    for ((i = 0; i < $NUMOFSTATIONS; i++))
    do
		# find out a greeter is running on each station.
		# If then, kill login-server to start usb-config wrapper..
		/opt/userful/bin/checkGrabKeyboard -display :$i
		IsRunning=$?

		if [ "$IsRunning" = 1 ]; then
			if [ -e /var/run/pid.login-server$i ]; then
	    		kill `cat /var/run/pid.login-server$i` > /dev/null 2>&1
			fi
		else
			if [ -e /var/run/pid.kbdlink$i ]; then
				#echo userful-usbinput-config is running already..
				:
			else
				/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
			fi

			/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
		fi	
    done
    sleep 1;
else
	# Start userful-usbinput-config program on each station 
	for ((i = 0; i < $NUMOFSTATIONS; i++))
	do
    	if [ -e /var/run/pid.kbdlink$i ]; then
			if [ -e /proc/`cat /var/run/pid.kbdlink$i` ]; then
	    		#echo userful-usbinput-config is running already..
				:
			else
	    		/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
			fi
    	else  
	   		/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
    	fi
	done
fi

##########################################
# Send signal to daemons to reset devices
##########################################
sleep 1
/usr/bin/killall -s USR1 userful-usbinput-config
#/opt/userful/bin/send_signal
#sleep 1
#sleep 2

# re-initialize USBConfigDaemon
if pgrep USBConfigDaemon > /dev/null 2>&1; then
    #pkill USBConfigDaemon
	:
else
	if [ -z "$CURRENTDM" ]; then
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon &
	else
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon -dm $CURRENTDM &
	fi
fi

# re-initialize kbd-daemon
if pgrep kbd-daemon > /dev/null 2>&1; then
	pkill kbd-daemon
else
	$KEEPALIVE 	/opt/userful/bin/kbd-daemon 2>>/var/log/kbd-daemon.log &
fi

# re-initialize mse-daemon
if pgrep mse-daemon > /dev/null 2>&1; then
	pkill mse-daemon
else
	$KEEPALIVE /opt/userful/bin/mse-daemon 2>>/var/log/mse-daemon.log &
fi

sleep 1
/usr/bin/killall -s HUP userful-usbinput-config
rm -f /etc/usbinput.tmp
