#!/usr/bin/env python

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# license-details.py

import gtk 
import gtk.glade
import os, sys
import time

import gettext

gtk.glade.bindtextdomain("userful-control-panel", "/usr/share/locale")
gtk.glade.textdomain("userful-control-panel")

gettext.bindtextdomain('userful-control-panel')
gettext.textdomain('userful-control-panel')

#gettext.bind_textdomain_codeset("userful-control-panel", "UTF-8")
gettext.bind_textdomain_codeset("userful-control-panel", "ISO-8859-1")

_ = gettext.gettext

class PyGlade:
    glade_filename = 'license-dialog.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/umx-utils/')

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access("/opt/userful/bin/dm-gen-info", os.R_OK) == 1:
            sys.stdout.write("running dm-gen-info -licenseinfo\n")
            os.system("/opt/userful/bin/dm-gen-info -licenseinfo")

        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            exit

        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

        widget = self.gtk_glade_xml.get_widget("help_text")
        try:
            text_file = file("/etc/userful/userful-license-info")
            text = text_file.read()
        except:
            text = ""


        if text == "":
            text = _("The license details file was empty or not present")
        

	buffer = widget.get_buffer()
        buffer.set_text(text)


    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

    ################ CALLBACKS ################
    def on_license_details_dialog_destroy(self, widget):
        gtk.main_quit()
    def on_closebutton_clicked(self, widget):
        gtk.main_quit()
        
def main():

    PyGlade_ins = PyGlade()

    gtk.main()

if __name__ == "__main__":
    main()

