#!/bin/bash
#
# dm-gen-xconfig.sh
#
#	Create X/MX config file. 
#	 - userful.xorg.conf.one
#	 - userful.xorg.conf.all
#	 - userful.Mxorg.conf
#
#	Copyright (c) 2006 Userful Corporation
#
#	Jason Kim <jason@userful.com>
##############################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

source /opt/userful/bin/userful-bash-lib.sh

XORG_CONF_NEW="/root/xorg.conf.new"

MXDEVNO=0 # Multiple graphic configuration
SXDEVNO=0 # Single graphic configuration
NUM_OF_HEAD=0
CURR_CARD_TYPE=
STATION_TYPE=

H_SYNC=
V_REFRESH=
BUSID=
VENDORNAME=
BOARDNAME=
DRIVER=
HEADNO=
DEVID=

KILLX=1
# diable VIDMODE for radeon card
DISABLEXVIDMODE=0

#########################################
# bomb
#  - Show error message and exit program.
#########################################
function bomb() {
	log "%s" "$*"
	exit 1
}

########################
# usage
########################
function usage()
{
	echo "Usage:"	
	echo "$ProgramName <config type>"	
	echo "		-1box		create config-file for 1Box-Server"
	echo "		-check		create config-file for checking dual-head"
	echo "		-one		create one head config-file for normal X"
	echo "		-all		create all heads config-file for normal X"
	exit 1
}

#------------------
# start here...
#------------------
# TODO:
#   - Sourcing confmodule causes some problems on Debian 4.0
# For Debian based system, load shell library
#if [[ -f /usr/share/debconf/confmodule ]]; then
	# It will re-run the caller program 
	#source /usr/share/debconf/confmodule
#fi

IsRoot
xconfigtype=$1

#
# find available lspci command and set LSPCI.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi


#
# Check arguments recieved
if [[ $# -ne 1 ]]; then
	log "No argument found."
	usage
fi

case "$xconfigtype" in
	"-1box")
		log "%s %s : userful.Mxorg.conf" "$ProgramName" "$xconfigtype"
		;;
	"-check")
		log "%s %s : Checking every video card..." "$ProgramName" "$xconfigtype"
		;;
	"-one")
		log "%s %s userful.xorg.conf.one"  "$ProgramName" "$xconfigtype"
		;;
	"-all")
		log "%s %s userful.xorg.conf.all" "$ProgramName" "$xconfigtype"
		;;
	*)
		log "Invalid argument."
		usage
		;;
esac

#
# Check system type (32bit or 64bit)
LIB=$(Check_System_Type)

#
# Check MXVER
[[ -f /etc/userful/MXVERSION ]] && source /etc/userful/MXVERSION
[[ $MXVER ]] || MXVER=MX11R6

#
# Check MAXSTATIONS
if [[ -e /etc/userful/dm-max-stations ]]; then
    source /etc/userful/dm-max-stations
else
	log "%s doesn't exist" "/etc/userful/dm-max-stations" 
    exit 1
fi

#
# Initialize STATION_TYPE array based on MAXSTATIONS
for (( i=0; i<$MAXSTATIONS; i++ )); do
	STATION_TYPE[$i]=S
done

#
# Check os-info and dm-sys-info
#  - dm-sys-info : generated by config-message (Press Enter program)
if [[ -f /etc/userful/os-info ]]; then
	source /etc/userful/os-info
else
	log "%s is not available" "/etc/userful/os-info"
	exit 1
fi

##
## Source umx.conf to find the default Monitor resolution
##
if [ -f /etc/userful/umx.conf ]; then
    sed -e "s/^\[/#\[/g" /etc/userful/umx.conf > /tmp/umx.conf.tmp
    source /tmp/umx.conf.tmp
fi

##
## Source dm-sys-info and check required variables
##  - SYS_TYPE
##  - SYS_DUALVIEW
##  - SYS_RESOLUTION

[[ -f /etc/dm-sys-info ]] && source /etc/dm-sys-info

# Default system type (SYS_TYPE) is desktop.
[[ $SYS_TYPE ]] || SYS_TYPE=0

# Default number of dualview (SYS_DUALVIEW) is 0.
[[ $SYS_DUALVIEW ]] || SYS_DUALVIEW=0

if [ x"$SYS_RESOLUTION" = x ]; then
    # SYS_RESOLUTION is not available
    if [ "$MONITOR_RES" == "probed" ] && [ -e /tmp/Monitor.Probed ]; then
        # Use probed resolution
	    SYS_RESOLUTION=5
    else
        # default resolution is 1024x768
	    SYS_RESOLUTION=3
    fi

else
    # SYS_RESOLUTION is available. Check Monitor.Probed file for the probed resolution
    if [ "$SYS_RESOLUTION" == "5" ]; then
        if [ ! -e /tmp/Monitor.Probed ]; then
	        SYS_RESOLUTION=3
        fi
    fi
fi

#
# check if the nVidia driver and kernel module exist.
if $LSPCI -n | tr "a-z" "A-Z" | grep "0300:[[:space:]]10DE:" > /dev/null 2>&1 ; then
    IS_NVIDIA_DRIVER=$(Check_nVidia_Driver)
    if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
		log "nVidia driver and/or kernel module was not found." 
    fi
fi

#
# Create temp file for sections
FILES_SECTION_FILE=$(mktemp /tmp/FilesSection.XXXXXXXX)
MODULE_SECTION_FILE=$(mktemp /tmp/ModuleSection.XXXXXXXX)
MONITOR_SECTION_FILE=$(mktemp /tmp/MonitorSection.XXXXXXXX)
DEVICE_SECTION_FILE=$(mktemp /tmp/DeviceSection.XXXXXXXX)

#
# Load dm-config-module.sh
source /opt/userful/bin/dm-xconfig-module.sh

#
# Parse xorg.conf.new
if [[ -f $XORG_CONF_NEW ]]; then
    parse_xorg_conf_new $XORG_CONF_NEW
else
	log "%s is not available. Use own Database to generate config files." "$XORG_CONF_NEW"
fi

##############################################
# Generate X config file based on xconfigtype
##############################################
TEMP_XORG_CONF=$(mktemp /tmp/xorgconf.XXXXXXXX)

# Header
genHeader

# Files section
if [[ -s $FILES_SECTION_FILE ]]; then

    # Checking Font path
    if grep "FontPath" $FILES_SECTION_FILE | grep "misc" > /dev/null 2>&1; then
	    genSectionCommon Files $FILES_SECTION_FILE
    else
	    genFilesSection
    fi
else
	genFilesSection
fi

# ServerFlags Section
genServerflagsSection

# Module Section
if [[ -s $MODULE_SECTION_FILE ]]; then
	genSectionCommon Module $MODULE_SECTION_FILE
else
	genModuleSection
fi

# Device Section
#echo "genDeviceSection" >> $logfile
genDeviceSection

# Monitor Section
#echo "genMonitorSection" >> $logfile
genMonitorSection "$TEMP_XORG_CONF" "/etc/mvgainfo" "/etc/X11/monitors.conf"

#cat $FILES_SECTION_FILE; echo
#cat $MODULE_SECTION_FILE; echo
#cat $MONITOR_SECTION_FILE; echo
#cat $DEVICE_SECTION_FILE; echo
#cat $TEMP_XORG_CONF; echo

if [[ "$xconfigtype" != "-check" ]]; then
	#echo "genScreenSection" >> $logfile
	genScreenSection

	#echo "genKbdSection" >> $logfile
	genKbdSection

	#echo "genMseSection" >> $logfile
	genMseSection

	#echo "genTouchSection" >> $logfile
	genTouchSection
	
	#echo "genServerlayoutSection" >> $logfile
	genServerlayoutSection

	#echo "reconfXConfig" >> $logfile
	reconfXConfig
fi

rm -f $TEMP_XORG_CONF $DEVICE_SECTION_FILE $FILES_SECTION_FILE $MODULE_SECTION_FILE $MONITOR_SECTION_FILE
