#!/bin/bash

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# launch-preferred-browser.sh

ARGS="$*"

echo "LPB: args: $ARGS"

# Use gnome's default browser
G=`which gconftool-2`
if [ -n "$G" ] && [ -x $G ] ; then 
    P=`$G -g /desktop/gnome/applications/browser/exec`
    if which $P &> /dev/null ; then
        exec $P "$ARGS"
    fi
fi

# We didn't find a default gnome browser, check all known browsers

# preferred:
BROWSER_LIST="firefox seamonkey kazehakase epiphany mozilla galeon "

# bottom of the barrel:
BROWSER_LIST="$BROWSER_LIST dillo netscape opera iexplore.exe konqueror"

for B in $BROWSER_LIST ; do
    P=`which $B`
    if which $B &> /dev/null ; then 
        exec $P "$ARGS"
    fi
done

zenity --error --text "Can't find a web browser to launch. Go to: $ARGS"

exit 1
