/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;

class CbImageFileWindow
extends FixedFrame
implements CbButtonCallback {
    CbImageChooser parent;
    ScrollImage imgp;
    TextField url;
    CbButton browse;
    CbButton ok;
    CbButton cancel;
    FileDialog filedlog;
    String lastfile = "";

    CbImageFileWindow(CbImageChooser cbImageChooser) {
        this.parent = cbImageChooser;
        this.parent.filewin = this;
        this.setLayout(new BorderLayout());
        this.imgp = new ScrollImage(this.parent.img, 200, 200);
        this.add("Center", this.imgp);
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(new FlowLayout(0));
        grayPanel.add(new Label("URL:"));
        this.url = new TextField(this.parent.imgsrc, 20);
        grayPanel.add(this.url);
        this.browse = new CbButton("Browse..", (CbButtonCallback)this);
        grayPanel.add(this.browse);
        grayPanel.add(new Label("  "));
        this.ok = new CbButton("Ok", (CbButtonCallback)this);
        grayPanel.add(this.ok);
        this.cancel = new CbButton("Cancel", (CbButtonCallback)this);
        grayPanel.add(this.cancel);
        this.add("South", grayPanel);
        this.pack();
        this.show();
        this.setTitle("Choose Image..");
        Util.recursiveBackground(this, Color.lightGray);
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            this.parent.setImage(this.imgp.img, this.lastfile);
        }
        if (cbButton == this.ok || cbButton == this.cancel) {
            this.dispose();
            return;
        }
        if (cbButton == this.browse) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose Image", 0);
            ((Window)fileDialog).show();
            if (fileDialog.getFile() != null) {
                String string = fileDialog.getDirectory() + fileDialog.getFile();
                ((TextComponent)this.url).setText(string);
                this.loadFile(string);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.parent.filewin = null;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.url) {
            String string = this.url.getText();
            if (string.startsWith("http:") || string.startsWith("ftp:")) {
                this.loadURL(string);
            } else {
                this.loadFile(string);
            }
            return true;
        }
        return false;
    }

    private void loadFile(String string) {
        Image image = Util.tk.getImage(string);
        if (image == null || !Util.waitForImage(image)) {
            new ErrorWindow("Failed to load image " + string);
            return;
        }
        this.imgp.setImage(image);
        this.lastfile = string;
    }

    private void loadURL(String string) {
        try {
            Image image = Util.tk.getImage(new URL(string));
            if (image == null || !Util.waitForImage(image)) {
                new ErrorWindow("Failed to load image from " + string);
                return;
            }
            this.imgp.setImage(image);
            this.lastfile = string;
            return;
        }
        catch (MalformedURLException malformedURLException) {
            new ErrorWindow(string + " is not a valid URL");
            return;
        }
    }
}

