/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;

public class Hierarchy
extends BorderPanel
implements CbScrollbarCallback {
    HierarchyNode root;
    CbScrollbar sb;
    int width;
    int height;
    int sbwidth;
    HierarchyCallback callback;
    Image bim;
    Font font = new Font("courier", 0, 12);
    FontMetrics fnm;
    Graphics bg;
    int top = 0;
    int count = 0;
    Insets in;
    HierarchyNode sel;
    long last;
    static boolean broken_awt = System.getProperty("os.name").startsWith("Windows");

    Hierarchy(HierarchyNode hierarchyNode) {
        this();
        this.root = hierarchyNode;
    }

    Hierarchy(HierarchyNode hierarchyNode, HierarchyCallback hierarchyCallback) {
        this(hierarchyNode);
        this.callback = hierarchyCallback;
    }

    Hierarchy() {
        super(3, Util.dark_edge_hi, Util.body_hi);
        this.setLayout(null);
        this.sb = new CbScrollbar(0, this);
        this.add(this.sb);
    }

    Hierarchy(HierarchyCallback hierarchyCallback) {
        this();
        this.callback = hierarchyCallback;
    }

    void redraw() {
        if (this.fnm != null) {
            this.render();
            this.paint(this.getGraphics());
            this.compscroll();
        }
    }

    void setRoot(HierarchyNode hierarchyNode) {
        this.root = hierarchyNode;
        this.redraw();
    }

    HierarchyNode selected() {
        return this.sel;
    }

    void select(HierarchyNode hierarchyNode) {
        this.sel = hierarchyNode;
    }

    public void setFont(Font font) {
        this.font = font;
        this.bim = null;
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.in = this.insets();
        this.sbwidth = this.sb.minimumSize().width;
        this.width = n3 - this.sbwidth - (this.in.left + this.in.right);
        this.height = n4 - (this.in.top + this.in.bottom);
        this.sb.reshape(this.width + this.in.left, this.in.top, this.sbwidth, this.height);
        this.bim = null;
        this.repaint();
        this.compscroll();
        super.reshape(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.render();
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.bim == null) {
            this.bim = this.createImage(this.width, this.height);
            this.bg = this.bim.getGraphics();
            this.bg.setFont(this.font);
            this.fnm = this.bg.getFontMetrics();
            this.render();
            this.compscroll();
        }
        graphics.drawImage(this.bim, this.in.left, this.in.top, this);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.root == null) {
            return false;
        }
        HierarchyNode hierarchyNode = this.nodeat(this.root, n / 16, n2 / 16 + this.top);
        if (hierarchyNode == null) {
            this.sel = null;
            this.repaint();
            return true;
        }
        boolean bl = false;
        if (event.when - this.last < 500L && this.sel == hierarchyNode) {
            bl = true;
        } else {
            this.last = event.when;
        }
        this.sel = hierarchyNode;
        if (bl && this.sel.ch != null) {
            boolean bl2 = this.sel.open = !this.sel.open;
            if (this.callback != null) {
                if (this.sel.open) {
                    this.callback.openNode(this, this.sel);
                } else {
                    this.callback.closeNode(this, this.sel);
                }
            }
        } else if (this.callback != null) {
            if (bl) {
                this.callback.doubleNode(this, this.sel);
            } else {
                this.callback.clickNode(this, this.sel);
            }
        }
        this.compscroll();
        this.repaint();
        return true;
    }

    public void moved(CbScrollbar cbScrollbar, int n) {
        this.moving(cbScrollbar, n);
    }

    public void moving(CbScrollbar cbScrollbar, int n) {
        this.top = this.sb.getValue();
        this.compscroll();
        this.repaint();
    }

    private void render() {
        if (this.fnm != null) {
            int n = this.fnm.getHeight();
            int n2 = this.fnm.getAscent();
            this.bg.setColor(Util.light_bg);
            this.bg.fillRect(0, 0, this.width, this.height);
            if (this.root == null) {
                return;
            }
            this.bg.setColor(Util.text);
            this.recurse(this.root, 0, 0, n, n2);
        }
    }

    private int recurse(HierarchyNode hierarchyNode, int n, int n2, int n3, int n4) {
        int n5 = n * 16;
        int n6 = (n2 - this.top) * 16;
        int n7 = 1;
        hierarchyNode.x = n;
        hierarchyNode.y = n2;
        int n8 = this.fnm.stringWidth(hierarchyNode.text);
        if (n6 >= 0 && n6 <= this.height) {
            if (hierarchyNode.im != null) {
                this.bg.drawImage(hierarchyNode.im, n5, n6, this);
            }
            if (this.sel == hierarchyNode) {
                this.bg.setColor(Util.body);
                this.bg.fillRect(n5 + 17, n6 + 2, n8 + 2, 13);
                this.bg.setColor(Util.text);
            }
            this.bg.drawString(hierarchyNode.text, n5 + 18, n6 + 12);
        }
        if (hierarchyNode.ch != null && hierarchyNode.open && n6 <= this.height) {
            this.bg.drawLine(n5 + 18, n6 + 14, n5 + 17 + n8, n6 + 14);
            n6 += 16;
            int n9 = 0;
            while (n9 < hierarchyNode.ch.size() && n6 <= this.height) {
                int n10 = this.recurse((HierarchyNode)hierarchyNode.ch.elementAt(n9), n + 1, n2 + n7, n3, n4);
                this.bg.drawLine(n5 + 7, n6 + 7, n5 + 15, n6 + 7);
                if (n9 == hierarchyNode.ch.size() - 1) {
                    this.bg.drawLine(n5 + 7, n6, n5 + 7, n6 + 7);
                } else {
                    this.bg.drawLine(n5 + 7, n6, n5 + 7, n6 + n10 * 16 - 1);
                }
                n7 += n10;
                n6 += n10 * 16;
                ++n9;
            }
        }
        return n7;
    }

    private void compscroll() {
        if (this.fnm == null) {
            return;
        }
        int n = this.root != null ? this.count(this.root) : 1;
        int n2 = Math.min(n, this.height / 16 - 1);
        int n3 = n - n2;
        this.sb.setValues(this.top, n2 == 0 ? 1 : n2, n);
    }

    private int count(HierarchyNode hierarchyNode) {
        int n = 1;
        if (hierarchyNode.open && hierarchyNode.ch != null) {
            int n2 = 0;
            while (n2 < hierarchyNode.ch.size()) {
                n += this.count((HierarchyNode)hierarchyNode.ch.elementAt(n2));
                ++n2;
            }
        }
        return n;
    }

    private HierarchyNode nodeat(HierarchyNode hierarchyNode, int n, int n2) {
        if (n2 == hierarchyNode.y && n >= hierarchyNode.x) {
            return hierarchyNode;
        }
        if (hierarchyNode.ch == null || !hierarchyNode.open) {
            return null;
        }
        int n3 = 0;
        while (n3 < hierarchyNode.ch.size()) {
            HierarchyNode hierarchyNode2 = this.nodeat((HierarchyNode)hierarchyNode.ch.elementAt(n3), n, n2);
            if (hierarchyNode2 != null) {
                return hierarchyNode2;
            }
            ++n3;
        }
        return null;
    }
}

