/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class SharingWindow
extends FixedFrame
implements CbButtonCallback {
    CbButton save_b;
    CbButton cancel_b;
    RemoteFile file;
    FileManager filemgr;
    SambaShare sshare;
    DFSAdminExport dexport;
    LinuxExport lexport;
    Checkbox samba_on;
    Checkbox samba_off;
    Checkbox writable_on;
    Checkbox writable_off;
    Checkbox available_on;
    Checkbox available_off;
    Checkbox guest_on;
    Checkbox guest_off;
    Checkbox guest_only;
    TextField comment;
    TextField desc;
    Checkbox nfs_on;
    Checkbox nfs_off;
    TextField rwhosts;
    TextField rohosts;
    TextField roothosts;
    Checkbox[] rw = new Checkbox[3];
    Checkbox[] ro = new Checkbox[3];
    Checkbox[] root = new Checkbox[3];
    TextField[] host;
    Choice[] lro;
    Choice[] squash;

    SharingWindow(RemoteFile remoteFile, FileManager fileManager) {
        this.file = remoteFile;
        this.filemgr = fileManager;
        this.setTitle(this.filemgr.text("share_title", this.file.path));
        this.sshare = (SambaShare)this.filemgr.stab.get(this.file.path);
        Object v = this.filemgr.ntab.get(this.file.path);
        if (this.filemgr.nfsmode == 1) {
            this.lexport = (LinuxExport)v;
        } else if (this.filemgr.nfsmode == 2) {
            this.dexport = (DFSAdminExport)v;
        }
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(2, 1));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.samba_off = new Checkbox(this.filemgr.text("share_soff"), checkboxGroup, this.sshare == null);
        panel4.add(this.samba_off);
        this.samba_on = new Checkbox(this.filemgr.text("share_son"), checkboxGroup, this.sshare != null);
        panel4.add(this.samba_on);
        panel.add("North", panel4);
        LinedPanel linedPanel = new LinedPanel(this.filemgr.text("share_sheader"));
        this.setup_leftright(linedPanel, panel2, panel3);
        this.comment = new TextField(this.sshare == null ? "" : this.sshare.comment, 25);
        this.comment.setFont(this.filemgr.fixed);
        this.add_item(this.filemgr.text("share_comment"), this.comment, panel2, panel3);
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(1, 0));
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.available_on = new Checkbox(this.filemgr.text("yes"), checkboxGroup2, this.sshare == null || this.sshare.available);
        panel5.add(this.available_on);
        this.available_off = new Checkbox(this.filemgr.text("no"), checkboxGroup2, this.sshare != null && !this.sshare.available);
        panel5.add(this.available_off);
        this.add_item(this.filemgr.text("share_available"), panel5, panel2, panel3);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(1, 0));
        CheckboxGroup checkboxGroup3 = new CheckboxGroup();
        this.writable_on = new Checkbox(this.filemgr.text("yes"), checkboxGroup3, this.sshare == null || this.sshare.writable);
        panel6.add(this.writable_on);
        this.writable_off = new Checkbox(this.filemgr.text("no"), checkboxGroup3, this.sshare != null && !this.sshare.writable);
        panel6.add(this.writable_off);
        this.add_item(this.filemgr.text("share_writable"), panel6, panel2, panel3);
        Panel panel7 = new Panel();
        panel7.setLayout(new GridLayout(1, 0));
        CheckboxGroup checkboxGroup4 = new CheckboxGroup();
        this.guest_only = new Checkbox(this.filemgr.text("share_only"), checkboxGroup4, this.sshare != null && this.sshare.guest == 2);
        panel7.add(this.guest_only);
        this.guest_on = new Checkbox(this.filemgr.text("yes"), checkboxGroup4, this.sshare == null || this.sshare.guest == 1);
        panel7.add(this.guest_on);
        this.guest_off = new Checkbox(this.filemgr.text("no"), checkboxGroup4, this.sshare != null && this.sshare.guest == 0);
        panel7.add(this.guest_off);
        this.add_item(this.filemgr.text("share_guest"), panel7, panel2, panel3);
        panel.add("Center", linedPanel);
        Panel panel8 = new Panel();
        Panel panel9 = new Panel();
        Panel panel10 = new Panel();
        panel8.setLayout(new BorderLayout());
        Panel panel11 = new Panel();
        panel11.setLayout(new GridLayout(2, 1));
        CheckboxGroup checkboxGroup5 = new CheckboxGroup();
        this.nfs_off = new Checkbox(this.filemgr.text("share_noff"), checkboxGroup5, v == null);
        panel11.add(this.nfs_off);
        this.nfs_on = new Checkbox(this.filemgr.text("share_non"), checkboxGroup5, v != null);
        panel11.add(this.nfs_on);
        panel8.add("North", panel11);
        LinedPanel linedPanel2 = new LinedPanel(this.filemgr.text("share_nheader"));
        this.setup_leftright(linedPanel2, panel9, panel10);
        if (this.filemgr.nfsmode == 1) {
            panel9.setLayout(new GridLayout(0, 1, 2, 2));
            panel10.setLayout(new GridLayout(0, 1, 2, 2));
            panel9.add(new Label(this.filemgr.text("share_host")));
            panel10.add(new Label(this.filemgr.text("share_opts")));
            int n = this.lexport == null ? 0 : this.lexport.host.length;
            this.host = new TextField[n + 1];
            this.lro = new Choice[n + 1];
            this.squash = new Choice[n + 1];
            int n2 = 0;
            while (n2 < n) {
                this.host[n2] = new TextField(this.lexport.host[n2], 20);
                this.host[n2].setFont(this.filemgr.fixed);
                this.lro[n2] = this.robox(this.lexport.ro[n2]);
                this.squash[n2] = this.squashbox(this.lexport.squash[n2]);
                panel9.add(this.host[n2]);
                panel10.add(this.opts_panel(this.lro[n2], this.squash[n2]));
                ++n2;
            }
            this.host[n] = new TextField("", 20);
            this.host[n].setFont(this.filemgr.fixed);
            this.lro[n] = this.robox(false);
            this.squash[n] = this.squashbox(1);
            panel9.add(this.host[n]);
            panel10.add(this.opts_panel(this.lro[n], this.squash[n]));
        } else if (this.filemgr.nfsmode == 2) {
            this.desc = new TextField(this.dexport == null ? "" : this.dexport.desc, 25);
            this.desc.setFont(this.filemgr.fixed);
            this.add_item(this.filemgr.text("share_desc"), this.desc, panel9, panel10);
            this.rohosts = this.add_hosts(this.filemgr.text("share_ro"), this.dexport == null ? "-" : this.dexport.ro, this.ro, panel9, panel10);
            this.rwhosts = this.add_hosts(this.filemgr.text("share_rw"), this.dexport == null ? "-" : this.dexport.rw, this.rw, panel9, panel10);
            this.roothosts = this.add_hosts(this.filemgr.text("share_root"), this.dexport == null ? "-" : this.dexport.root, this.root, panel9, panel10);
            this.root[1].getParent().remove(this.root[1]);
        } else if (this.filemgr.nfsmode == 3) {
            // empty if block
        }
        panel8.add("Center", linedPanel2);
        if (this.filemgr.sambamode && this.filemgr.nfsmode != 0) {
            TabbedPanel tabbedPanel = new TabbedPanel();
            tabbedPanel.addItem(this.filemgr.text("share_samba"), panel);
            tabbedPanel.addItem(this.filemgr.text("share_nfs"), panel8);
            this.add("Center", tabbedPanel);
        } else if (this.filemgr.sambamode) {
            this.add("Center", panel);
        } else if (this.filemgr.nfsmode != 0) {
            this.add("Center", panel8);
        }
        Panel panel12 = new Panel();
        panel12.setLayout(new FlowLayout(2));
        this.save_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("save"), 0, this);
        panel12.add(this.save_b);
        this.cancel_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        panel12.add(this.cancel_b);
        this.add("South", panel12);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.save_b) {
            String[] stringArray;
            if (this.sshare != null && this.samba_on.getState()) {
                this.sshare.available = this.available_on.getState();
                this.sshare.writable = this.writable_on.getState();
                this.sshare.guest = this.guest_only.getState() ? 2 : (this.guest_on.getState() ? 1 : 0);
                this.sshare.comment = this.comment.getText();
                stringArray = this.filemgr.get_text("save_share.cgi?" + this.sshare.params());
            } else if (this.sshare != null) {
                stringArray = this.filemgr.get_text("save_share.cgi?delete=1&" + this.sshare.params());
                this.filemgr.stab.remove(this.sshare.path);
            } else if (this.samba_on.getState()) {
                this.sshare = new SambaShare(this.file.path, this.available_on.getState(), this.writable_on.getState(), this.guest_only.getState() ? 2 : (this.guest_on.getState() ? 1 : 0), this.comment.getText());
                this.filemgr.stab.put(this.sshare.path, this.sshare);
                stringArray = this.filemgr.get_text("save_share.cgi?new=1&" + this.sshare.params());
            }
            if (this.filemgr.nfsmode == 1) {
                if (this.lexport != null && this.nfs_on.getState()) {
                    this.export_options(this.lexport);
                    stringArray = this.filemgr.get_text("save_export.cgi?" + this.lexport.params());
                } else if (this.lexport != null) {
                    stringArray = this.filemgr.get_text("save_export.cgi?delete=1&" + this.lexport.params());
                    this.filemgr.ntab.remove(this.lexport.path);
                } else if (this.nfs_on.getState()) {
                    this.lexport = new LinuxExport(this.file.path, null, null, null);
                    this.export_options(this.lexport);
                    stringArray = this.filemgr.get_text("save_export.cgi?new=1&" + this.lexport.params());
                    this.filemgr.ntab.put(this.lexport.path, this.lexport);
                }
            } else if (this.filemgr.nfsmode == 2) {
                if (this.dexport != null && this.nfs_on.getState()) {
                    this.dexport.desc = this.desc.getText();
                    String string = this.ro[0].getState() ? "-" : (this.dexport.ro = this.ro[1].getState() ? "" : this.rohosts.getText());
                    this.dexport.rw = this.rw[0].getState() ? "-" : (this.rw[1].getState() ? "" : this.rwhosts.getText());
                    this.dexport.root = this.root[0].getState() ? "-" : this.roothosts.getText();
                    stringArray = this.filemgr.get_text("save_export.cgi?" + this.dexport.params());
                } else if (this.dexport != null) {
                    stringArray = this.filemgr.get_text("save_export.cgi?delete=1&" + this.dexport.params());
                    this.filemgr.ntab.remove(this.dexport.path);
                } else if (this.nfs_on.getState()) {
                    this.dexport = new DFSAdminExport(this.file.path, this.desc.getText(), this.ro[0].getState() ? "-" : (this.ro[1].getState() ? "" : this.rohosts.getText()), this.rw[0].getState() ? "-" : (this.rw[1].getState() ? "" : this.rwhosts.getText()), this.root[0].getState() ? "-" : this.roothosts.getText());
                    stringArray = this.filemgr.get_text("save_export.cgi?new=1&" + this.dexport.params());
                    this.filemgr.ntab.put(this.dexport.path, this.dexport);
                }
            } else if (this.filemgr.nfsmode == 3) {
                // empty if block
            }
            this.filemgr.show_files(this.filemgr.showing_files);
            this.dispose();
        } else if (cbButton == this.cancel_b) {
            this.dispose();
        }
    }

    void setup_leftright(Panel panel, Panel panel2, Panel panel3) {
        panel.setLayout(new BorderLayout());
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add("West", panel2);
        panel4.add("Center", panel3);
        panel2.setLayout(new GridLayout(0, 1));
        panel3.setLayout(new GridLayout(0, 1));
        panel.add("North", panel4);
    }

    void add_item(String string, Component component, Panel panel, Panel panel2) {
        panel.add(new Label(string));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("West", component);
        panel2.add(panel3);
    }

    TextField add_hosts(String string, String string2, Checkbox[] checkboxArray, Panel panel, Panel panel2) {
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 3));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        checkboxArray[0] = new Checkbox(this.filemgr.text("share_none"), checkboxGroup, string2.equals("-"));
        panel3.add(checkboxArray[0]);
        checkboxArray[1] = new Checkbox(this.filemgr.text("share_all"), checkboxGroup, string2.length() == 0);
        panel3.add(checkboxArray[1]);
        checkboxArray[2] = new Checkbox(this.filemgr.text("share_listed"), checkboxGroup, string2.length() > 1);
        panel3.add(checkboxArray[2]);
        this.add_item(string, panel3, panel, panel2);
        TextField textField = new TextField(string2.equals("-") ? "" : string2, 25);
        textField.setFont(this.filemgr.fixed);
        this.add_item("", textField, panel, panel2);
        return textField;
    }

    Choice squashbox(int n) {
        Choice choice = new Choice();
        choice.addItem(this.filemgr.text("share_s0"));
        choice.addItem(this.filemgr.text("share_s1"));
        choice.addItem(this.filemgr.text("share_s2"));
        choice.select(n);
        return choice;
    }

    Choice robox(boolean bl) {
        Choice choice = new Choice();
        choice.addItem(this.filemgr.text("share_lrw"));
        choice.addItem(this.filemgr.text("share_lro"));
        choice.select(bl ? 1 : 0);
        return choice;
    }

    Panel opts_panel(Component component, Component component2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", component);
        panel.add("East", component2);
        return panel;
    }

    void export_options(LinuxExport linuxExport) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.host.length) {
            if (this.host[n2].getText().length() > 0) {
                ++n;
            }
            ++n2;
        }
        linuxExport.host = new String[n];
        linuxExport.ro = new boolean[n];
        linuxExport.squash = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.host.length) {
            if (this.host[n3].getText().trim().length() > 0) {
                linuxExport.host[n4] = this.host[n3].getText();
                linuxExport.ro[n4] = this.lro[n3].getSelectedIndex() == 1;
                linuxExport.squash[n4] = this.squash[n3].getSelectedIndex();
                ++n4;
            }
            ++n3;
        }
    }
}

