/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath;

import com.werken.xpath.FunctionContext;
import com.werken.xpath.function.BooleanFunction;
import com.werken.xpath.function.CeilingFunction;
import com.werken.xpath.function.ConcatFunction;
import com.werken.xpath.function.ContainsFunction;
import com.werken.xpath.function.CountFunction;
import com.werken.xpath.function.FalseFunction;
import com.werken.xpath.function.FloorFunction;
import com.werken.xpath.function.Function;
import com.werken.xpath.function.LastFunction;
import com.werken.xpath.function.LocalNameFunction;
import com.werken.xpath.function.NameFunction;
import com.werken.xpath.function.NamespaceUriFunction;
import com.werken.xpath.function.NotFunction;
import com.werken.xpath.function.NumberFunction;
import com.werken.xpath.function.PositionFunction;
import com.werken.xpath.function.RoundFunction;
import com.werken.xpath.function.StartsWithFunction;
import com.werken.xpath.function.StringFunction;
import com.werken.xpath.function.StringLengthFunction;
import com.werken.xpath.function.SubstringAfterFunction;
import com.werken.xpath.function.SubstringBeforeFunction;
import com.werken.xpath.function.SubstringFunction;
import com.werken.xpath.function.SumFunction;
import com.werken.xpath.function.TrueFunction;
import java.util.HashMap;
import java.util.Map;

public class XPathFunctionContext
implements FunctionContext {
    private static final Object _instanceLock = new Object();
    private static XPathFunctionContext _instance = null;
    private final Map _functions = new HashMap();

    public XPathFunctionContext() {
        this.addFunction("last", new LastFunction());
        this.addFunction("position", new PositionFunction());
        this.addFunction("count", new CountFunction());
        this.addFunction("local-name", new LocalNameFunction());
        this.addFunction("namespace-uri", new NamespaceUriFunction());
        this.addFunction("name", new NameFunction());
        this.addFunction("string", new StringFunction());
        this.addFunction("concat", new ConcatFunction());
        this.addFunction("starts-with", new StartsWithFunction());
        this.addFunction("contains", new ContainsFunction());
        this.addFunction("substring-before", new SubstringBeforeFunction());
        this.addFunction("substring-after", new SubstringAfterFunction());
        this.addFunction("substring", new SubstringFunction());
        this.addFunction("string-length", new StringLengthFunction());
        this.addFunction("boolean", new BooleanFunction());
        this.addFunction("not", new NotFunction());
        this.addFunction("true", new TrueFunction());
        this.addFunction("false", new FalseFunction());
        this.addFunction("number", new NumberFunction());
        this.addFunction("sum", new SumFunction());
        this.addFunction("floor", new FloorFunction());
        this.addFunction("ceiling", new CeilingFunction());
        this.addFunction("round", new RoundFunction());
    }

    protected void addFunction(String name, Function func) {
        this._functions.put(name, func);
    }

    public Function getFunction(String name) {
        return (Function)this._functions.get(name);
    }

    public static XPathFunctionContext getInstance() {
        if (_instance == null) {
            Object object = _instanceLock;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new XPathFunctionContext();
                }
            }
        }
        return _instance;
    }
}

