/*
 * cbmcharsets.c - CBM lookalike character sets.
 *
 * Written by
 *  Joe Forster / STA <sta@ludens.elte.hu>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "types.h"

#include "cbmcharsets.h"

BYTE cbm_charset_1[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x7e, 0x7e, 0x81, 0x81, 0xa5, 0xa5, 0x81, 0x81,
    0x99, 0x99, 0x81, 0x81, 0x7e, 0x7e, 0x00, 0x00,
    0x7e, 0x7e, 0xff, 0xff, 0xdb, 0xdb, 0xff, 0xff,
    0xe7, 0xe7, 0xff, 0xff, 0x7e, 0x7e, 0x00, 0x00,
    0x36, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00,
    0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f,
    0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00,
    0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f,
    0x7f, 0x7f, 0x1c, 0x1c, 0x3e, 0x3e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c,
    0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xc3, 0xc3,
    0xc3, 0xc3, 0xe7, 0xe7, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x24, 0x24,
    0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xdb, 0xdb,
    0xdb, 0xdb, 0xe7, 0xe7, 0xff, 0xff, 0xff, 0xff,
    0x0e, 0x0e, 0x05, 0x05, 0x08, 0x08, 0x38, 0x38,
    0x44, 0x44, 0x44, 0x44, 0x38, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x38, 0x44, 0x44, 0x44, 0x44,
    0x38, 0x38, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10,
    0x08, 0x08, 0x0c, 0x0c, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00,
    0x3e, 0x3e, 0x22, 0x22, 0x3e, 0x3e, 0x22, 0x22,
    0x22, 0x22, 0x26, 0x26, 0x66, 0x66, 0x60, 0x60,
    0x08, 0x08, 0x2a, 0x2a, 0x14, 0x14, 0x63, 0x63,
    0x14, 0x14, 0x2a, 0x2a, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x78, 0x78, 0x7e, 0x7e,
    0x7e, 0x7e, 0x78, 0x78, 0x60, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x1e, 0x1e, 0x7e, 0x7e,
    0x7e, 0x7e, 0x1e, 0x1e, 0x06, 0x06, 0x00, 0x00,
    0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x3f, 0x3f, 0x5b, 0x5b, 0x1b, 0x1b,
    0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00,
    0x3c, 0x3c, 0x60, 0x60, 0x3c, 0x3c, 0x66, 0x66,
    0x3c, 0x3c, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
    0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x7e, 0x7e,
    0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x08, 0x0c, 0x0c, 0xfe, 0xfe,
    0xfe, 0xfe, 0x0c, 0x0c, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x10, 0x30, 0x30, 0x7f, 0x7f,
    0x7f, 0x7f, 0x30, 0x30, 0x10, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x60,
    0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0xfe, 0xfe,
    0xfe, 0xfe, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c,
    0x3c, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x3c,
    0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0xff, 0xff, 0x66, 0x66,
    0xff, 0xff, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x18, 0x18, 0x3e, 0x3e, 0x60, 0x60, 0x3c, 0x3c,
    0x06, 0x06, 0x7c, 0x7c, 0x18, 0x18, 0x00, 0x00,
    0x62, 0x62, 0x66, 0x66, 0x0c, 0x0c, 0x18, 0x18,
    0x30, 0x30, 0x66, 0x66, 0x46, 0x46, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x3c, 0x3c, 0x38, 0x38,
    0x67, 0x67, 0x66, 0x66, 0x3f, 0x3f, 0x00, 0x00,
    0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00,
    0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x3c, 0x3c, 0xff, 0xff,
    0x3c, 0x3c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x7e,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c,
    0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x6e, 0x6e, 0x76, 0x76,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x7e, 0x7e, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x0c, 0x0c,
    0x30, 0x30, 0x60, 0x60, 0x7e, 0x7e, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x1c, 0x1c,
    0x06, 0x06, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x06, 0x06, 0x0e, 0x0e, 0x1e, 0x1e, 0x66, 0x66,
    0x7f, 0x7f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00,
    0x7e, 0x7e, 0x60, 0x60, 0x7c, 0x7c, 0x06, 0x06,
    0x06, 0x06, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x7c, 0x7c,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x7e, 0x7e, 0x66, 0x66, 0x0c, 0x0c, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e,
    0x06, 0x06, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30,
    0x0e, 0x0e, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60,
    0x30, 0x30, 0x18, 0x18, 0x0e, 0x0e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x00,
    0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x70, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06,
    0x0c, 0x0c, 0x18, 0x18, 0x70, 0x70, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x0c, 0x0c,
    0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x6e, 0x6e, 0x6e, 0x6e,
    0x60, 0x60, 0x62, 0x62, 0x3c, 0x3c, 0x00, 0x00,
    0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c,
    0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x78, 0x78, 0x6c, 0x6c, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x6c, 0x6c, 0x78, 0x78, 0x00, 0x00,
    0x7e, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x78, 0x78,
    0x60, 0x60, 0x60, 0x60, 0x7e, 0x7e, 0x00, 0x00,
    0x7e, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x78, 0x78,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x6e, 0x6e,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00,
    0x1e, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x6c, 0x6c, 0x38, 0x38, 0x00, 0x00,
    0x66, 0x66, 0x6c, 0x6c, 0x78, 0x78, 0x70, 0x70,
    0x78, 0x78, 0x6c, 0x6c, 0x66, 0x66, 0x00, 0x00,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x7e, 0x7e, 0x00, 0x00,
    0x63, 0x63, 0x77, 0x77, 0x7f, 0x7f, 0x6b, 0x6b,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00,
    0x66, 0x66, 0x76, 0x76, 0x7e, 0x7e, 0x7e, 0x7e,
    0x6e, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x3c, 0x0e, 0x0e, 0x00, 0x00,
    0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c,
    0x78, 0x78, 0x6c, 0x6c, 0x66, 0x66, 0x00, 0x00,
    0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x3c, 0x3c,
    0x06, 0x06, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b,
    0x7f, 0x7f, 0x77, 0x77, 0x63, 0x63, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18,
    0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x7e, 0x7e, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18,
    0x30, 0x30, 0x60, 0x60, 0x7e, 0x7e, 0x00, 0x00,
    0x3c, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18,
    0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x00, 0x00,
    0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3c, 0x00, 0x00,
    0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
    0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x06, 0x06,
    0x3e, 0x3e, 0x66, 0x66, 0x3e, 0x3e, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c,
    0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x3e, 0x3e,
    0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66,
    0x7e, 0x7e, 0x60, 0x60, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x0e, 0x0e, 0x18, 0x18, 0x3e, 0x3e,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x3e, 0x06, 0x06, 0x7c, 0x7c,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x38, 0x38,
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3c, 0x3c,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x6c, 0x6c,
    0x78, 0x78, 0x6c, 0x6c, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x7f, 0x7f,
    0x7f, 0x7f, 0x6b, 0x6b, 0x63, 0x63, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x3e, 0x06, 0x06, 0x06, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x66, 0x66,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x60, 0x60,
    0x3c, 0x3c, 0x06, 0x06, 0x7c, 0x7c, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x7e, 0x7e, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x0e, 0x0e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6b, 0x6b,
    0x7f, 0x7f, 0x3e, 0x3e, 0x36, 0x36, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3c, 0x3c,
    0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x3e, 0x0c, 0x0c, 0x78, 0x78,
    0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x0c, 0x0c,
    0x18, 0x18, 0x30, 0x30, 0x7e, 0x7e, 0x00, 0x00,
    0x1c, 0x1c, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60,
    0x30, 0x30, 0x30, 0x30, 0x1c, 0x1c, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x38, 0x38, 0x0c, 0x0c, 0x0c, 0x0c, 0x06, 0x06,
    0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x38, 0x00, 0x00,
    0x3b, 0x3b, 0x6e, 0x6e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c,
    0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f,
    0x7f, 0x7f, 0x1c, 0x1c, 0x3e, 0x3e, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0,
    0xf0, 0xf0, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x1c, 0x1c, 0x0f, 0x0f,
    0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0xf0, 0xf0,
    0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0xc0, 0xe0, 0xe0, 0x70, 0x70, 0x38, 0x38,
    0x1c, 0x1c, 0x0e, 0x0e, 0x07, 0x07, 0x03, 0x03,
    0x03, 0x03, 0x07, 0x07, 0x0e, 0x0e, 0x1c, 0x1c,
    0x38, 0x38, 0x70, 0x70, 0xe0, 0xe0, 0xc0, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x00, 0x00, 0x3c, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e,
    0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x36, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07,
    0x0f, 0x0f, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18,
    0xc3, 0xc3, 0xe7, 0xe7, 0x7e, 0x7e, 0x3c, 0x3c,
    0x3c, 0x3c, 0x7e, 0x7e, 0xe7, 0xe7, 0xc3, 0xc3,
    0x00, 0x00, 0x3c, 0x3c, 0x7e, 0x7e, 0x66, 0x66,
    0x66, 0x66, 0x7e, 0x7e, 0x3c, 0x3c, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f,
    0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
    0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xc0, 0xc0, 0xc0, 0xc0, 0x30, 0x30, 0x30, 0x30,
    0xc0, 0xc0, 0xc0, 0xc0, 0x30, 0x30, 0x30, 0x30,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x3e, 0x3e,
    0x76, 0x76, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00,
    0xff, 0xff, 0x7f, 0x7f, 0x3f, 0x3f, 0x1f, 0x1f,
    0x0f, 0x0f, 0x07, 0x07, 0x03, 0x03, 0x01, 0x01,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
    0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, 0x30,
    0x60, 0x60, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00,
    0x0c, 0x0c, 0x12, 0x12, 0x30, 0x30, 0x7c, 0x7c,
    0x30, 0x30, 0x62, 0x62, 0xfc, 0xfc, 0x00, 0x00,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
    0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
    0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33, 0x66, 0x66,
    0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33, 0x66, 0x66,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x22, 0x22, 0x66, 0x66, 0xcc, 0xcc,
    0xcc, 0xcc, 0x66, 0x66, 0x22, 0x22, 0x00, 0x00,
    0x00, 0x00, 0x88, 0x88, 0xcc, 0xcc, 0x66, 0x66,
    0x66, 0x66, 0xcc, 0xcc, 0x88, 0x88, 0x00, 0x00,
    0x11, 0x11, 0x44, 0x44, 0x11, 0x11, 0x44, 0x44,
    0x11, 0x11, 0x44, 0x44, 0x11, 0x11, 0x44, 0x44,
    0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
    0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
    0xee, 0xee, 0xbb, 0xbb, 0xee, 0xee, 0xbb, 0xbb,
    0xee, 0xee, 0xbb, 0xbb, 0xee, 0xee, 0xbb, 0xbb,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
    0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18,
    0x18, 0x18, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0xe6,
    0xe6, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe,
    0xfe, 0xfe, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18,
    0x18, 0x18, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18,
    0x66, 0x66, 0xe6, 0xe6, 0xe6, 0xe6, 0x06, 0x06,
    0x06, 0x06, 0xe6, 0xe6, 0xe6, 0xe6, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0x06, 0x06,
    0x06, 0x06, 0xe6, 0xe6, 0xe6, 0xe6, 0x66, 0x66,
    0x66, 0x66, 0xe6, 0xe6, 0xe6, 0xe6, 0x06, 0x06,
    0x06, 0x06, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0xfe,
    0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0xf8, 0xf8, 0xf8, 0xf8, 0x18, 0x18,
    0x18, 0x18, 0xf8, 0xf8, 0xf8, 0xf8, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
    0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
    0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
    0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
    0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1f, 0x18, 0x18,
    0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1f, 0x18, 0x18,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x67,
    0x67, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x67, 0x67, 0x67, 0x67, 0x60, 0x60,
    0x60, 0x60, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00,
    0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x60, 0x60,
    0x60, 0x60, 0x67, 0x67, 0x67, 0x67, 0x66, 0x66,
    0x66, 0x66, 0xe7, 0xe7, 0xe7, 0xe7, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xe7, 0xe7, 0xe7, 0xe7, 0x66, 0x66,
    0x66, 0x66, 0x67, 0x67, 0x67, 0x67, 0x60, 0x60,
    0x60, 0x60, 0x67, 0x67, 0x67, 0x67, 0x66, 0x66,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x66, 0x66, 0xe7, 0xe7, 0xe7, 0xe7, 0x00, 0x00,
    0x00, 0x00, 0xe7, 0xe7, 0xe7, 0xe7, 0x66, 0x66,
    0x18, 0x18, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7f, 0x7f,
    0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1f, 0x18, 0x18,
    0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00,
    0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x18, 0x18,
    0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1f, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
    0x7f, 0x7f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff,
    0xff, 0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x18, 0x18, 0xff, 0xff, 0xff, 0xff, 0x18, 0x18,
    0x18, 0x18, 0xff, 0xff, 0xff, 0xff, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
    0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f,
    0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xff, 0xff, 0xfe, 0xfe, 0xfc, 0xfc, 0xf8, 0xf8,
    0xf0, 0xf0, 0xe0, 0xe0, 0xc0, 0xc0, 0x80, 0x80,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
    0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
    0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
    0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f,
    0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
    0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x03, 0x03, 0x06, 0x06, 0x6c, 0x6c,
    0x78, 0x78, 0x70, 0x70, 0x60, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE cbm_charset_2[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd,
    0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3,
    0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0xff, 0xff,
    0x7e, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0xff,
    0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c,
    0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3,
    0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42,
    0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd,
    0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x0f, 0x03, 0x07, 0x0d, 0x39, 0x6c,
    0x44, 0x44, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x36, 0x1c,
    0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x08, 0x0c, 0x0c, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x38, 0x38, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x3e, 0x22, 0x3e, 0x22, 0x22, 0x22,
    0x26, 0x26, 0x66, 0x60, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x49, 0x2a, 0x14, 0x63,
    0x14, 0x2a, 0x49, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x30, 0x38, 0x3c, 0x3e, 0x3e,
    0x3c, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x0c, 0x1c, 0x3c, 0x7c, 0x7c,
    0x3c, 0x1c, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
    0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3f, 0x7b, 0x5b, 0x5b, 0x3b, 0x1b,
    0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x60, 0x60, 0x3c, 0x66, 0x66,
    0x66, 0x3c, 0x06, 0x06, 0x3c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
    0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
    0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfe,
    0xfe, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x7f,
    0x7f, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60,
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff,
    0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c,
    0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e,
    0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0xff, 0x66, 0x66,
    0xff, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x3e, 0x60, 0x60, 0x3c,
    0x06, 0x06, 0x7c, 0x18, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x0c, 0x0c, 0x18, 0x18,
    0x30, 0x30, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x38, 0x67,
    0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff,
    0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e,
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18,
    0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x6e, 0x76, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x38, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x0c, 0x18,
    0x30, 0x60, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x1c, 0x06,
    0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x0e, 0x1e, 0x1e, 0x66, 0x66,
    0x7f, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x60, 0x60, 0x7c, 0x06, 0x06,
    0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x7c, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x66, 0x06, 0x06, 0x0c, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3e, 0x06,
    0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x0e, 0x18, 0x30, 0x60, 0x60,
    0x30, 0x18, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x70, 0x18, 0x0c, 0x06, 0x06,
    0x0c, 0x18, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x0c, 0x18,
    0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x6e, 0x6e, 0x6e, 0x60,
    0x62, 0x62, 0x62, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x7e,
    0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x66,
    0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x6c, 0x78, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x60, 0x60, 0x60, 0x78, 0x60,
    0x60, 0x60, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x60, 0x60, 0x60, 0x78, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x6e, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x6c, 0x6c, 0x78, 0x78,
    0x6c, 0x6c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x63, 0x77, 0x7f, 0x6b, 0x6b, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x76, 0x76, 0x7e, 0x6e,
    0x6e, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x0e, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x78,
    0x6c, 0x6c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x3c, 0x06,
    0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b,
    0x6b, 0x7f, 0x77, 0x63, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18,
    0x3c, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x06, 0x0c, 0x0c, 0x18, 0x18,
    0x30, 0x30, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18,
    0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x06, 0x06,
    0x3e, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x06, 0x3e, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66,
    0x7e, 0x60, 0x60, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0e, 0x18, 0x18, 0x3e, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x06, 0x06, 0x7c, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x60, 0x66, 0x6c, 0x78,
    0x78, 0x6c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x7f, 0x7f,
    0x6b, 0x6b, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66,
    0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0x60,
    0x3c, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6b,
    0x6b, 0x7f, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3c,
    0x18, 0x3c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x3e, 0x06, 0x0c, 0x78, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x06, 0x0c,
    0x18, 0x30, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18,
    0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18,
    0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x33, 0x7e, 0xcc, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x66,
    0x66, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0xff,
    0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,
    0xf0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x0f,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf0,
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff,
    0x80, 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18,
    0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x01,
    0x01, 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18,
    0x18, 0x30, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0x80,
    0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xff, 0xff, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e,
    0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x0f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x81, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18,
    0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0x81,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x66,
    0x66, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0xff, 0xff,
    0x7e, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
    0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xc0, 0xc0, 0xc0, 0xc0, 0x30, 0x30, 0x30, 0x30,
    0xc0, 0xc0, 0xc0, 0xc0, 0x30, 0x30, 0x30, 0x30,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3e, 0x76,
    0x76, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00,
    0xff, 0xff, 0x7f, 0x7f, 0x3f, 0x3f, 0x1f, 0x1f,
    0x0f, 0x0f, 0x07, 0x07, 0x03, 0x03, 0x01, 0x01,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18,
    0x0c, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0x12, 0x32, 0x30, 0x7c, 0x30,
    0x30, 0x62, 0x62, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
    0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
    0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33, 0x66, 0x66,
    0xcc, 0xcc, 0x99, 0x99, 0x33, 0x33, 0x66, 0x66,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x66, 0xcc,
    0xcc, 0x66, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xcc, 0x66,
    0x66, 0xcc, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x11, 0x11, 0x44, 0x44, 0x11, 0x11, 0x44, 0x44,
    0x11, 0x11, 0x44, 0x44, 0x11, 0x11, 0x44, 0x44,
    0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
    0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
    0xee, 0xee, 0xbb, 0xbb, 0xee, 0xee, 0xbb, 0xbb,
    0xee, 0xee, 0xbb, 0xbb, 0xee, 0xee, 0xbb, 0xbb,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
    0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
    0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6,
    0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
    0xfe, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18,
    0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0xe6, 0x06,
    0x06, 0xe6, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x06,
    0x06, 0xe6, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0xe6, 0x06,
    0x06, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe,
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
    0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
    0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
    0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
    0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
    0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67,
    0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x67, 0x60,
    0x60, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x60,
    0x60, 0x67, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0xe7, 0xe7, 0x00,
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x00, 0xe7, 0xe7, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x67, 0x60,
    0x60, 0x67, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0xe7, 0xe7, 0x00,
    0x00, 0xe7, 0xe7, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7f,
    0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
    0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18,
    0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
    0x7f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff,
    0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18,
    0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
    0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xcc, 0xcc, 0xcc, 0xcc, 0x33, 0x33, 0x33, 0x33,
    0xff, 0xff, 0xfe, 0xfe, 0xfc, 0xfc, 0xf8, 0xf8,
    0xf0, 0xf0, 0xe0, 0xe0, 0xc0, 0xc0, 0x80, 0x80,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
    0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
    0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
    0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
    0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x03, 0x06, 0x06, 0x6c, 0x6c,
    0x78, 0x78, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* ------------------------------------------------------------------------- */

/* Conversion tables.  */

/* PETSCII lowercase/uppercase to extended ASCII converter table (used when
   the C64 character set is on).  */
BYTE cbm_petscii_business_to_charset[0x100] = {
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x5B, 0xA9, 0x5D, 0x18, 0x1B,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x5B, 0xA9, 0x5D, 0x18, 0x1B,
    0x80, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x9B, 0x9C, 0x9D, 0xAA, 0xAB,
    0x80, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x9B, 0x9C, 0x9D, 0xAA, 0xAB,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xAC, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xA0, 0xA1, 0xFB, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
    0x80, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x9B, 0x9C, 0x9D, 0xAA, 0xAB,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xAC, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xA0, 0xA1, 0xFB, 0xA3, 0xA4, 0xA5, 0xA6, 0xAA
};

/* PETSCII uppercase/graphics to extended ASCII converter table (used when the
   C64 character set is on).  */
BYTE cbm_petscii_graphics_to_charset[0x100] = {
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0xA9, 0x5D, 0x18, 0x1B,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0xA9, 0x5D, 0x18, 0x1B,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0x9E
};

/* FIXME: These are currently unused.  */

BYTE cbm_petscii_business_to_ascii[0x100] = {
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x5B, 0x9C, 0x5D, 0x18, 0x1B,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x5B, 0x9C, 0x5D, 0x18, 0x1B,
    0xC4, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0xC5, 0xF9, 0xB3, 0xF9, 0xF9,
    0xC4, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0xC5, 0xF9, 0xB3, 0xF9, 0xF9,
    0x5F, 0xDD, 0xDC, 0xC4, 0xC4, 0xB3, 0xF9, 0xB3,
    0xF9, 0xF9, 0xB3, 0xC3, 0xF9, 0xC0, 0xBF, 0xC4,
    0xDA, 0xC1, 0xC2, 0xB4, 0xB3, 0xDD, 0xDE, 0xC4,
    0xDF, 0xDC, 0xFB, 0xF9, 0xF9, 0xD9, 0xF9, 0xF9,
    0xC4, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0xC5, 0xF9, 0xB3, 0xF9, 0xF9,
    0x5F, 0xDD, 0xDC, 0xC4, 0xC4, 0xB3, 0xF9, 0xB3,
    0xF9, 0xF9, 0xB3, 0xC3, 0xF9, 0xC0, 0xBF, 0xC4,
    0xDA, 0xC1, 0xC2, 0xB4, 0xB3, 0xDD, 0xDE, 0xC4,
    0xDF, 0xDC, 0xFB, 0xF9, 0xF9, 0xD9, 0xF9, 0xF9
};

BYTE cbm_petscii_graphics_to_ascii[0x100] = {
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0x9C, 0x5D, 0x18, 0x1B,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0x9C, 0x5D, 0x18, 0x1B,
    0xC4, 0x06, 0xB3, 0xC4, 0xC4, 0xC4, 0xC4, 0xB3,
    0xB3, 0xBF, 0xC0, 0xD9, 0xC0, 0x5C, 0x2F, 0xDA,
    0xBF, 0x07, 0xC4, 0x03, 0xB3, 0xDA, 0x58, 0x09,
    0x05, 0xB3, 0x04, 0xC5, 0xF9, 0xB3, 0xE3, 0xF9,
    0xC4, 0x06, 0xB3, 0xC4, 0xC4, 0xC4, 0xC4, 0xB3,
    0xB3, 0xBF, 0xC0, 0xD9, 0xC0, 0x5C, 0x2F, 0xDA,
    0xBF, 0x07, 0xC4, 0x03, 0xB3, 0xDA, 0x58, 0x09,
    0x05, 0xB3, 0x04, 0xC5, 0xF9, 0xB3, 0xE3, 0xF9,
    0x5F, 0xDD, 0xDC, 0xC4, 0xC4, 0xB3, 0xF9, 0xB3,
    0xF9, 0xF9, 0xB3, 0xC3, 0xF9, 0xC0, 0xBF, 0xC4,
    0xDA, 0xC1, 0xC2, 0xB4, 0xB3, 0xDD, 0xDE, 0xC4,
    0xDF, 0xDC, 0xD9, 0xF9, 0xF9, 0xD9, 0xF9, 0xF9,
    0xC4, 0x06, 0xB3, 0xC4, 0xC4, 0xC4, 0xC4, 0xB3,
    0xB3, 0xBF, 0xC0, 0xD9, 0xC0, 0x5C, 0x2F, 0xDA,
    0xBF, 0x07, 0xC4, 0x03, 0xB3, 0xDA, 0x58, 0x09,
    0x05, 0xB3, 0x04, 0xC5, 0xF9, 0xB3, 0xE3, 0xF9,
    0x5F, 0xDD, 0xDC, 0xC4, 0xC4, 0xB3, 0xF9, 0xB3,
    0xF9, 0xF9, 0xB3, 0xC3, 0xF9, 0xC0, 0xBF, 0xC4,
    0xDA, 0xC1, 0xC2, 0xB4, 0xB3, 0xDD, 0xDE, 0xC4,
    0xDF, 0xDC, 0xD9, 0xF9, 0xF9, 0xD9, 0xF9, 0xE3
};

BYTE cbm_ascii_to_petscii[0x100] = {
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0x5B, 0xCD, 0x5D, 0x5E, 0xA0,
    0x20, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0xDD, 0x5D, 0x2D, 0x20,
    0xC3, 0x55, 0x45, 0x41, 0x41, 0x41, 0x41, 0x43,
    0x45, 0x45, 0x45, 0x49, 0x49, 0x49, 0xC1, 0xC1,
    0xC5, 0x41, 0xC1, 0x4F, 0x4F, 0x4F, 0x55, 0x55,
    0x59, 0xCF, 0xD5, 0x43, 0x5C, 0xD9, 0x20, 0x20,
    0x41, 0x45, 0x4F, 0x55, 0x4E, 0xCE, 0x20, 0x20,
    0x3F, 0x20, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20,
    0xA6, 0xA6, 0xA6, 0xDD, 0xB3, 0xB3, 0xB3, 0xAE,
    0xAE, 0xB3, 0xA6, 0xAE, 0xBD, 0xBD, 0xBD, 0xAE,
    0xAD, 0xB1, 0xB2, 0xAB, 0xC0, 0xDB, 0xAB, 0xAB,
    0xAD, 0xB0, 0xB1, 0xB2, 0xAB, 0xC0, 0xDB, 0xB1,
    0xB1, 0xB2, 0xB2, 0xAD, 0xAD, 0xB0, 0xB0, 0xDB,
    0xDB, 0xBD, 0xB0, 0x20, 0xA2, 0xA1, 0xB6, 0xB9,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
};

