/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.streaming;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.streaming.XMLReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public abstract class XMLStreamReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamReaderFactory.class.getName());
    @NotNull
    private static volatile XMLStreamReaderFactory theInstance;

    public static void set(XMLStreamReaderFactory f) {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        theInstance = f;
    }

    public static XMLStreamReaderFactory get() {
        return theInstance;
    }

    public static XMLStreamReader create(InputSource source, boolean rejectDTDs) {
        try {
            if (source.getCharacterStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), source.getCharacterStream(), rejectDTDs);
            }
            if (source.getByteStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), source.getByteStream(), rejectDTDs);
            }
            return XMLStreamReaderFactory.get().doCreate(source.getSystemId(), new URL(source.getSystemId()).openStream(), rejectDTDs);
        }
        catch (IOException e) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{e});
        }
    }

    public static XMLStreamReader create(@Nullable String systemId, InputStream in, boolean rejectDTDs) {
        return XMLStreamReaderFactory.get().doCreate(systemId, in, rejectDTDs);
    }

    public static XMLStreamReader create(@Nullable String systemId, InputStream in, @Nullable String encoding, boolean rejectDTDs) {
        return encoding == null ? XMLStreamReaderFactory.create(systemId, in, rejectDTDs) : XMLStreamReaderFactory.get().doCreate(systemId, in, encoding, rejectDTDs);
    }

    public static XMLStreamReader create(@Nullable String systemId, Reader reader, boolean rejectDTDs) {
        return XMLStreamReaderFactory.get().doCreate(systemId, reader, rejectDTDs);
    }

    public static void recycle(XMLStreamReader r) {
        XMLStreamReaderFactory.get().doRecycle(r);
    }

    public abstract XMLStreamReader doCreate(String var1, InputStream var2, boolean var3);

    private XMLStreamReader doCreate(String systemId, InputStream in, @NotNull String encoding, boolean rejectDTDs) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException ue) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{ue});
        }
        return this.doCreate(systemId, reader, rejectDTDs);
    }

    public abstract XMLStreamReader doCreate(String var1, Reader var2, boolean var3);

    public abstract void doRecycle(XMLStreamReader var1);

    private static Boolean getProperty(final String prop) {
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String value = System.getProperty(prop);
                return value != null ? Boolean.valueOf(value) : Boolean.FALSE;
            }
        });
        return Boolean.FALSE;
    }

    static {
        XMLInputFactory xif = null;
        if (XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".woodstox").booleanValue()) {
            try {
                xif = (XMLInputFactory)Class.forName("com.ctc.wstx.stax.WstxInputFactory").newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (xif == null) {
            xif = XMLInputFactory.newInstance();
        }
        xif.setProperty("javax.xml.stream.isNamespaceAware", true);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReaderFactory f = null;
        if (!XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".noPool").booleanValue()) {
            f = Zephyr.newInstance(xif);
        }
        if (f == null && xif.getClass().getName().equals("com.ctc.wstx.stax.WstxInputFactory")) {
            f = new Woodstox(xif);
        }
        if (f == null) {
            f = new Default(xif);
        }
        theInstance = f;
        LOGGER.fine("XMLStreamReaderFactory instance is = " + theInstance);
    }

    public static final class Woodstox
    extends NoLock {
        public Woodstox(XMLInputFactory xif) {
            super(xif);
            xif.setProperty("org.codehaus.stax2.internNsUris", true);
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }
    }

    public static class NoLock
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;

        public NoLock(XMLInputFactory xif) {
            this.xif = xif;
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            try {
                return this.xif.createXMLStreamReader(systemId, in);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            try {
                return this.xif.createXMLStreamReader(systemId, in);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        public void doRecycle(XMLStreamReader r) {
        }
    }

    public static final class Default
    extends NoLock {
        public Default(XMLInputFactory xif) {
            super(xif);
        }

        public synchronized XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }

        public synchronized XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            return super.doCreate(systemId, in, rejectDTDs);
        }
    }

    public static final class Zephyr
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;
        private final ThreadLocal<XMLStreamReader> pool = new ThreadLocal();
        private final Method setInputSourceMethod;
        private final Method resetMethod;
        private final Class zephyrClass;

        @Nullable
        public static XMLStreamReaderFactory newInstance(XMLInputFactory xif) {
            try {
                Class<?> clazz = xif.createXMLStreamReader(new StringReader("<foo/>")).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.stream.")) {
                    return null;
                }
                return new Zephyr(xif, clazz);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (XMLStreamException e) {
                return null;
            }
        }

        public Zephyr(XMLInputFactory xif, Class clazz) throws NoSuchMethodException {
            this.zephyrClass = clazz;
            this.setInputSourceMethod = clazz.getMethod("setInputSource", InputSource.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
            try {
                xif.setProperty("reuse-instance", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.xif = xif;
        }

        @Nullable
        private XMLStreamReader fetch() {
            XMLStreamReader sr = this.pool.get();
            if (sr == null) {
                return null;
            }
            this.pool.set(null);
            return sr;
        }

        public void doRecycle(XMLStreamReader r) {
            if (this.zephyrClass.isInstance(r)) {
                this.pool.set(r);
            }
            if (r instanceof RecycleAware) {
                ((RecycleAware)((Object)r)).onRecycled();
            }
        }

        public XMLStreamReader doCreate(String systemId, InputStream in, boolean rejectDTDs) {
            try {
                XMLStreamReader xsr = this.fetch();
                if (xsr == null) {
                    return this.xif.createXMLStreamReader(systemId, in);
                }
                InputSource is = new InputSource(systemId);
                is.setByteStream(in);
                this.reuse(xsr, is);
                return xsr;
            }
            catch (IllegalAccessException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
            catch (InvocationTargetException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        public XMLStreamReader doCreate(String systemId, Reader in, boolean rejectDTDs) {
            try {
                XMLStreamReader xsr = this.fetch();
                if (xsr == null) {
                    return this.xif.createXMLStreamReader(systemId, in);
                }
                InputSource is = new InputSource(systemId);
                is.setCharacterStream(in);
                this.reuse(xsr, is);
                return xsr;
            }
            catch (IllegalAccessException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new XMLReaderException("stax.cantCreate", new Object[]{cause});
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        private void reuse(XMLStreamReader xsr, InputSource in) throws IllegalAccessException, InvocationTargetException {
            this.resetMethod.invoke((Object)xsr, new Object[0]);
            this.setInputSourceMethod.invoke((Object)xsr, in);
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }
}

