#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "global.h"

extern char *badhosts;

int check_badhosts(char *ehost)
{
  int ret = 0;
  FILE *stream = NULL;
  char b[255] = { 0 }, *p = NULL;

  if (badhosts == NULL)
     return 0;  

  stream = fopen(badhosts, "r");
  if (stream == NULL)
     return 0;  

  ret = 0;

  while(1) {
     memset((char *)b, 0, 255);
     fgets(b, 255, stream);

     if (feof(stream))
        break;

     if (!(*b == '#')) {
        for (p = b; *p; p++) {
            if ((*p == '\n') || (*p == '\r')) {
               *p = '\0';
               break;
            }
        }

        if (*b) {
           ret = parse_ehost(b, ehost);
           if (ret)
              break;
        }
     }
  }

  fclose(stream);

  return ret;
}

int parse_ehost(char *data, char *ehost)
{
  int len = 0, elen = 0;

  /*
     Compare the end of data against ehost
  */
  if (*data == '.') {
     elen = strlen(ehost);
     len = strlen(data);

     if (len >= elen)
        return 0;     

     if (!(strcasecmp((ehost + (elen - len)), data)))
        return 1;     

     return 0;
  }

  /*
     Compare the entire string
  */
  else {
     if (!(strcasecmp(data, ehost)))
        return 1;     

     return 0;
  }
}
