#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql.h>
#include "global.h"
#include "db_misc.h"
#include "db_mysql.h"

MYSQL mysql;

extern char *db_host, *db_name, *db_user, *db_password;

int db_open(void)
{
  int ret = 0;
  MYSQL *res = NULL;

  if ((db_host == NULL) || (db_name == NULL) || (db_user == NULL) || (db_password == NULL))
     return DB_E_CREDENTIALS;

  if ((!(*db_host)) || (!(*db_name)) || (!(*db_user)) || (!(*db_password)))
     return DB_E_CREDENTIALS;     

  mysql_init(&mysql);

  if (!(mysql_real_connect(&mysql, db_host, db_user, db_password, db_name, 0, NULL, 0)))
     return DB_E_CONNECT;  

  ret = mysql_select_db(&mysql, db_name);
  if (ret) {
     mysql_close(&mysql);
     return DB_E_DATABASE;
  }

  return DB_E_SUCCESS;
}

void db_close(void)
{
  mysql_close(&mysql);
}

int db_insert_data(char *tname, char **nfields, char **fields)
{
  int ret = 0, n = 0;
  char *query = NULL;

  /*
     Gather up combined length
     of fields, and number of fields.
  */

  for (ret = 0, n = 0; fields[n]; n++)
      ret += strlen(fields[n]);

  ret += (n * 2); /* quotes */
  ret += n; /* commas */

  /*
     Count prepended text length
  */

  ret += strlen(db_name);
  ret += 23; /* "INSERT INTO " " VALUES (" ")" */
  
  query = (char *)malloc(ret);
  if (query == NULL)
     return DB_E_MEM;

  memset((char *)query, 0, ret);
  
  snprintf(query, ret, "INSERT INTO %s VALUES (", tname);

  for (n = 0; fields[n]; n++) {
      strncat(query, "'", ret);
      strncat(query, fields[n], ret);

      if (!fields[n + 1])
         strncat(query, "')", ret);
      else
         strncat(query, "',", ret);
  } 

  ret = mysql_real_query(&mysql, query, strlen(query));
 
  free(query);

  if (ret) {    
     global_error("Database query failed", 0, 0);
     exit(1);
  }
 
  return DB_E_SUCCESS;  
}
