#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "global.h"

char *mstrdup(char *str)
{
  int len = 0;
  char *r = NULL;

  len = strlen(str);
  
  r = (char *)malloc(len + 1);
  if (r == NULL)
     global_error("Out of memory", 0, 0);

  memset((char *)r, 0, len + 1);
  memcpy((char *)r, (char *)str, len);

  return r;
}

/*
   An error occured in which there is absolutely no way to recover,
   or report outside of internal code.
*/
void tfatal(void)
{
  
  printf("<HTML><HEAD><TITLE>Fatal Error</TITLE></HEAD><BODY>\n" \
         "<CENTER>Fatal Error</CENTER>\n" \
         "<PRE>\n" \
         "An unrecoverable, fatal error has occured.  Please e-mail\n" \
         "the webmaster immediately and report this error, as it will\n" \
         "continue to occur.\n" \
         "</PRE></BODY></HTML>");

  exit(1);         
}
