/*
 * TransformData.java
 *
 * created: mpichler, 19970114
 *
 * changed: mpichler, 19970729
 *
 * $Id: TransformData.java,v 1.5 1997/08/04 13:21:05 apesen Exp $
 */


package iicm.vrml.vrwave.pwdat;

import iicm.vrml.vrwave.Builder;
import iicm.vrml.pw.*;
import iicm.utils3d.Mat4f;


/**
 * TransformData - additional Transform attributes.
 * Copyright (c) 1997 IICM
 */


public class TransformData implements GotEventCallback
{
  private Transform trf_;
  private boolean valid_ = false;
  private float[] trfmat_ = new float[16];
  private float[] invmat_ = null;

  /**
   * constructor. establish event callbacks
   */

  public TransformData (Transform trf)
  {
    trf_ = trf;
    // callbacks (see Interpolator.gotEventCB)
    trf.translation.setEventCallback (this);
    trf.rotation.setEventCallback (this);
    trf.scale.setEventCallback (this);
    trf.scaleOrientation.setEventCallback (this);
    trf.center.setEventCallback (this);
  }

  /**
   * calculate transformation matrix for a transform node
   * returns cached matrix unless invalidated by a field change
   */

  public float[/*16*/] getMatrix ()
  {
    if (!valid_)
    {
      Transform trf = trf_;
      Builder.buildTransform (  // build transformation matrix
        trf.translation.getValue (), trf.rotation.getValue (), trf.scale.getValue (),
        trf.scaleOrientation.getValue (), trf.center.getValue (), trfmat_);
      valid_ = true;
      // inverse matrices are calculated on demand
    }
    return trfmat_;
  }

  /**
   * calculate inverse transformation matrix
   * @see #getMatrix
   */

  public float[/*16*/] getInvMatrix ()
  {
    if (invmat_ == null)
    {
      float[] inv = new float[16];
      if (Mat4f.invertMatrix44 (getMatrix (), inv))
        invmat_ = inv;
      else
        invmat_ = Mat4f.identity4d;
    }
    return invmat_;
  }

  /**
   * invalidate transformation on any event on Transform node fields
   */

  public void gotEventCB (Field field, double timestamp)
  {
    // note: should check for field type if also other event callbacks are involved
    valid_ = false;
    invmat_ = null;
  }

} // TransformData
