/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventOutMFColor.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFColor;

public class EventOutMFColor extends EventOutMField
{
  public float[][] getValue ()
  {
    float[] data = ((MFColor) eventout_).getValueData ();
    float[][] value = new float[getSize ()][3];

    int j = 0;
    for (int i = 0; i < getSize () * 3; i += 3)
    {
      value[j][0] = data[i];
      value[j][1] = data[i+1];
      value[j][2] = data[i+2];
      j++;
    }
 
    return value;
  }

  public float[] get1Value (int index)
  {
    float[] data = ((MFColor) eventout_).getValueData ();
    index *= 3;
    float[] value = { data[index], data[index+1], data[index+2] };
    return value;
  }
}
