/*
 * asmooth.c - normal vector generation in VRwave
 * Copyright (c) 1996,97 IICM
 *
 * created: kwagen, 19970607
 *
 * changed: mpichler, 19970703
 * changed: kwagen, 19970703
 *
 * $Id: asmooth.c,v 1.1 1997/07/03 16:35:43 kwagen Exp $
 */
/* see asmooth.C of VRweb */


#ifdef __cplusplus
extern "C" {
#endif
#include "Builder.h"
#ifdef __cplusplus
} // C++
#endif


#ifdef macintosh
# include <vectors.h>
# include <ge3d.h>
# define M_PI _PI
# define PACKAGE iicm_vrml_vrwave_
#else
# include <ge3d/vectors.h>
# include <ge3d/ge3d.h>
#endif

#include "jutils.h"

#include <math.h>  /* M_PI */
#include <stdio.h>  /* debugging */



static int equal (vector3D* a, vector3D* b)
{
  return (a->x == b->x && a->y == b->y && a->z == b->z);
}


static void calcnormvec (vector3D* facenormals, int facenum, int* faces, int fn,
  float thresh_value, vector3D* vertnormal)
{
  vector3D* facenormal = facenormals + facenum;
  int currentface, i;
  float skalarpr;
  init3D (*vertnormal, facenormal->x, facenormal->y, facenormal->z);

  for (i = 0; i < fn; i++)
  {
    currentface = faces[i];
    if (facenum != currentface)
    {
      skalarpr = dot3D (facenormals[currentface], *facenormal);
      if (skalarpr > thresh_value)
        inc3D (*vertnormal, facenormals[currentface]);
    }
  }
}


static void normalize (vector3D* normal)
{
  float norm = dot3D (*normal, *normal);
  if (norm > 0.0)
  {
    norm = 1/sqrt (norm);
    scl3D (*normal, norm);
  }
}


/* autosmooth */
jn_int32 name2(PACKAGE,Builder_autosmooth) (struct name3(H,PACKAGE,Builder)* handle,
  HArrayOfInt* vertindsh,
  jn_int32 numvertinds,
  HArrayOfFloat* facenormalsh,
  jn_int32 numfaces,
  float crease_angle,
  HArrayOfFloat* normallisth,
  HArrayOfInt* normalindsh
)
{
  jn_int32* vertinds = (jn_int32*) unhand (vertindsh)->body;
  vector3D* facenormals = (vector3D*) unhand (facenormalsh)->body;
  vector3D* normallist = (vector3D*) unhand (normallisth)->body;
  jn_int32* normalinds = (jn_int32*) unhand (normalindsh)->body;

  int maxvert = 0, i = numvertinds, fn = 0, same_normal = 0, normal_index = 0;
  jn_int32* vi = vertinds;
  int *facespervertex, *numfacespervertex, *normalspervertex, *numnormalspervertex;
  int curindex, j, found;
  float thresh_value = cos (crease_angle);

  /* find maximum vertexindex */
  while (i--)
  {
    if (*vi > maxvert)
      maxvert = *vi;
    vi++;
  }
  /* printf ("maximum vertex index: %d\n", maxvert); */

  /* create list of faces containing the vertices */
  maxvert++;
  facespervertex = (int*) malloc (sizeof (int) * numfaces * maxvert);
  numfacespervertex = (int*) malloc (sizeof (int) * maxvert);
  for (i = 0; i < maxvert; i++)
    numfacespervertex[i] = 0;
  for (i = numvertinds, vi = vertinds; i--; vi++)
  {
    if (*vi >= 0)
    {
      facespervertex[*vi * numfaces + numfacespervertex[*vi]] = fn;
      numfacespervertex[*vi]++;
    }
    else
      fn++;
  }
  /* printf ("\nlist of faces the particular vertices belong to:\n");
  for (i=0; i < maxvert; i++)
  {
    printf ("Vertex %d: ", i); 
    for (j = 0; j < numfacespervertex[i]; j++)
      printf ("%d ", facespervertex[i * numfaces + j]);
    printf ("\n");
  } */

  /* create list of normals and normalindeces */
  normalspervertex = (int*) malloc (sizeof (int) * numfaces * maxvert);
  numnormalspervertex = (int*) malloc (sizeof (int) * maxvert);
  for (i = 0; i < maxvert; i++)
    numnormalspervertex[i] = 0;
  fn = 0;
  for (i = 0; i < numvertinds; i++)
  {
    curindex = vertinds[i];
    if (curindex >= 0)
    {
      calcnormvec (facenormals, fn, facespervertex + (curindex * numfaces), numfacespervertex[curindex],
                   thresh_value, normallist + normal_index);
      normalize (normallist + normal_index);
      found = 0;
      for (j = 0; j < numnormalspervertex[curindex] && !found; j++)
      {
        same_normal = normalspervertex[curindex * numfaces + j];
        found = equal (normallist + same_normal, normallist + normal_index);
      }
      if (found)
        normalinds[i] = same_normal;
      else if ((normal_index > 0) && equal (normallist + normal_index, normallist + (normal_index - 1)))
        normalinds[i] = normal_index - 1;
      else
      {
        normalinds[i] = normal_index;
        normalspervertex[curindex * numfaces + numnormalspervertex[curindex]] = normal_index;
        numnormalspervertex[curindex]++;
        normal_index++;
      }
    }
    else
    {
      fn++;
      normalinds[i] = -1;
    }
  }
  /* printf ("\nnormallist:\n");
  for (i = 0; i < normal_index; i++)
    printf ("%f %f %f\n", normallist[i].x, normallist[i].y, normallist[i].z);
  printf ("\nnormalindices:\n");
  for (i = 0; i < numvertinds; i++)
  {
    printf ("%ld ", normalinds[i]);
    if (normalinds[i] < 0)
      printf ("\n");
  } */

  free (facespervertex);
  free (numfacespervertex);
  free (normalspervertex);
  free (numnormalspervertex); 

  return normal_index;

} /* autosmooth */
