/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

typedef enum
{
	CA_PLAYERCLASS_GRUNT		= 0,
	CA_PLAYERCLASS_CAMPER		= 1,
	CA_PLAYERCLASS_SPAMMER		= 2,
	CA_PLAYERCLASS_TOTAL		= 3
} ca_playerclass_t;

typedef enum
{
	CA_WEAPONFLAG_NONE		= 0,
	CA_WEAPONFLAG_WEAK_GB		= 1 << 0,
	CA_WEAPONFLAG_WEAK_RG		= 1 << 1,
	CA_WEAPONFLAG_WEAK_GL		= 1 << 2,
	CA_WEAPONFLAG_WEAK_RL		= 1 << 3,
	CA_WEAPONFLAG_WEAK_PG		= 1 << 4,
	CA_WEAPONFLAG_WEAK_LG		= 1 << 5,
	CA_WEAPONFLAG_WEAK_EB		= 1 << 6,
	CA_WEAPONFLAG_STRONG_GB		= 1 << 7,
	CA_WEAPONFLAG_STRONG_RG		= 1 << 8,
	CA_WEAPONFLAG_STRONG_GL		= 1 << 9,
	CA_WEAPONFLAG_STRONG_RL		= 1 << 10,
	CA_WEAPONFLAG_STRONG_PG		= 1 << 11,
	CA_WEAPONFLAG_STRONG_LG		= 1 << 12,
	CA_WEAPONFLAG_STRONG_EB		= 1 << 13
	//CA_WEAPONFLAG_WEAK_SW		= 1 << x // FIXME
	//CA_WEAPONFLAG_STRONG_SW	= 1 << x // FIXME
} ca_weaponflag_t;

#define	CA_WEAPONFLAG_WEAK_ALL		((CA_WEAPONFLAG_WEAK_GB) | \
					 (CA_WEAPONFLAG_WEAK_RG) | \
					 (CA_WEAPONFLAG_WEAK_GL) | \
					 (CA_WEAPONFLAG_WEAK_RL) | \
					 (CA_WEAPONFLAG_WEAK_PG) | \
					 (CA_WEAPONFLAG_WEAK_LG) | \
					 (CA_WEAPONFLAG_WEAK_EB))

#define	CA_WEAPONFLAG_STRONG_ALL	((CA_WEAPONFLAG_STRONG_GB) | \
					 (CA_WEAPONFLAG_STRONG_RG) | \
					 (CA_WEAPONFLAG_STRONG_GL) | \
					 (CA_WEAPONFLAG_STRONG_RL) | \
					 (CA_WEAPONFLAG_STRONG_PG) | \
					 (CA_WEAPONFLAG_STRONG_LG) | \
					 (CA_WEAPONFLAG_STRONG_EB))

#define	CA_WEAPONFLAG_ALL		((CA_WEAPONFLAG_WEAK_ALL) | \
					 (CA_WEAPONFLAG_STRONG_ALL))

