#!/usr/local/bin/perl
# copy.cgi
# Copy some file or directory

require './file-lib.pl';
$disallowed_buttons{'copy'} && &error($text{'ebutton'});
&ReadParse();
&webmin_log("copy", undef, $in{'from'}, \%in);
&switch_acl_uid_and_chroot();
print "Content-type: text/plain\n\n";
if ($access{'ro'} || !&can_access($in{'from'})) {
	print &text('copy_efrom', $in{'from'}),"\n";
	exit;
	}
if (!&can_access($in{'to'})) {
	print &text('copy_eto', $in{'to'}),"\n";
	exit;
	}
if (-l $in{'from'}) {
	# Remake the link
	&lock_file($in{'to'});
	if (!symlink(readlink($in{'from'}), $in{'to'})) {
		print &text('copy_elink', $!),"\n";
		exit;
		}
	&unlock_file($in{'to'});
	$err = undef;
	}
elsif (-d $in{'from'}) {
	# Recursively copy with tar
	unlink($in{'to'});
	mkdir($in{'to'}, 0755);
	$out = &backquote_logged("(cd ".quotemeta($in{'from'})." ; tar cf - . | (cd ".quotemeta($in{'to'})." ; tar xf -)) 2>&1");
	$err = $?;
	}
else {
	# Simple copy using cp
	unlink($in{'to'});
	$out = &backquote_logged("cp -p ".quotemeta($in{'from'})." ".
					  quotemeta($in{'to'})." 2>&1");
	$err = $?;
	}
if ($err) {
	print $out,"\n";
	}
else {
	print "\n";
	print &file_info_line($in{'to'}),"\n";
	}

sub split_dir
{
$_[0] =~ /^(.*\/)([^\/]+)$/;
return ($1, $2);
}

