// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Defines a bunch of DesktopGL constants so we can make sure WebGL
// implementations disallow them.

var desktopGL = {
  'MIN': '0x8007',
  'MAX': '0x8008',
  'QUADS': '0x0007',
  'QUAD_STRIP': '0x0008',
  'POLYGON': '0x0009',
  '1': '0x0001',
  '2': '0x0002',
  '3': '0x0003',
  '4': '0x0004',
  'STATIC_READ': '0x88E5',
  'CLIP_PLANE0': '0x3000',
  'PERSPECTIVE_CORRECTION_HINT': '0x0C50',
  'RGB4': '0x804F',
  'RGB5': '0x8050',
  'RGB8': '0x8051',
  'RGB10': '0x8052',
  'RGB12': '0x8053',
  'RGB16': '0x8054',
  'RGBA2': '0x8055',
  'RGBA4': '0x8056',
  'RGB5_A1': '0x8057',
  'RGBA8': '0x8058',
  'RGB10_A2': '0x8059',
  'RGBA12': '0x805A',
  'RGBA16': '0x805B',
  'SMOOTH_POINT_SIZE_RANGE': '0x0B12',
  'SMOOTH_POINT_SIZE_GRANULARITY': '0x0B13',
  'SMOOTH_LINE_WIDTH_RANGE': '0x0B22',
  'SMOOTH_LINE_WIDTH_GRANULARITY': '0x0B23',
  'UNSIGNED_BYTE_3_3_2': '0x8032',
  'UNSIGNED_SHORT_4_4_4_4': '0x8033',
  'UNSIGNED_SHORT_5_5_5_1': '0x8034',
  'UNSIGNED_INT_8_8_8_8': '0x8035',
  'UNSIGNED_INT_10_10_10_2': '0x8036',
  'RESCALE_NORMAL': '0x803A',
  'TEXTURE_BINDING_3D': '0x806A',
  'PACK_SKIP_IMAGES': '0x806B',
  'PACK_IMAGE_HEIGHT': '0x806C',
  'UNPACK_SKIP_IMAGES': '0x806D',
  'UNPACK_IMAGE_HEIGHT': '0x806E',
  'TEXTURE_3D': '0x806F',
  'PROXY_TEXTURE_3D': '0x8070',
  'TEXTURE_DEPTH': '0x8071',
  'TEXTURE_WRAP_R': '0x8072',
  'MAX_3D_TEXTURE_SIZE': '0x8073',
  'BGR': '0x80E0',
  'BGRA': '0x80E1',
  'MAX_ELEMENTS_VERTICES': '0x80E8',
  'MAX_ELEMENTS_INDICES': '0x80E9',
  'CLAMP_TO_EDGE': '0x812F',
  'TEXTURE_MIN_LOD': '0x813A',
  'TEXTURE_MAX_LOD': '0x813B',
  'TEXTURE_BASE_LEVEL': '0x813C',
  'TEXTURE_MAX_LEVEL': '0x813D',
  'LIGHT_MODEL_COLOR_CONTROL': '0x81F8',
  'SINGLE_COLOR': '0x81F9',
  'SEPARATE_SPECULAR_COLOR': '0x81FA',
  'UNSIGNED_BYTE_2_3_3_REV': '0x8362',
  'UNSIGNED_SHORT_5_6_5': '0x8363',
  'UNSIGNED_SHORT_5_6_5_REV': '0x8364',
  'UNSIGNED_SHORT_4_4_4_4_REV': '0x8365',
  'UNSIGNED_SHORT_1_5_5_5_REV': '0x8366',
  'UNSIGNED_INT_8_8_8_8_REV': '0x8367',
  'UNSIGNED_INT_2_10_10_10_REV': '0x8368',
  'ALIASED_POINT_SIZE_RANGE': '0x846D',
  'ALIASED_LINE_WIDTH_RANGE': '0x846E',
  'MULTISAMPLE': '0x809D',
  'SAMPLE_ALPHA_TO_COVERAGE': '0x809E',
  'SAMPLE_ALPHA_TO_ONE': '0x809F',
  'SAMPLE_COVERAGE': '0x80A0',
  'SAMPLE_BUFFERS': '0x80A8',
  'SAMPLES': '0x80A9',
  'SAMPLE_COVERAGE_VALUE': '0x80AA',
  'SAMPLE_COVERAGE_INVERT': '0x80AB',
  'CLAMP_TO_BORDER': '0x812D',
  'TEXTURE0': '0x84C0',
  'TEXTURE1': '0x84C1',
  'TEXTURE2': '0x84C2',
  'TEXTURE3': '0x84C3',
  'TEXTURE4': '0x84C4',
  'TEXTURE5': '0x84C5',
  'TEXTURE6': '0x84C6',
  'TEXTURE7': '0x84C7',
  'TEXTURE8': '0x84C8',
  'TEXTURE9': '0x84C9',
  'TEXTURE10': '0x84CA',
  'TEXTURE11': '0x84CB',
  'TEXTURE12': '0x84CC',
  'TEXTURE13': '0x84CD',
  'TEXTURE14': '0x84CE',
  'TEXTURE15': '0x84CF',
  'TEXTURE16': '0x84D0',
  'TEXTURE17': '0x84D1',
  'TEXTURE18': '0x84D2',
  'TEXTURE19': '0x84D3',
  'TEXTURE20': '0x84D4',
  'TEXTURE21': '0x84D5',
  'TEXTURE22': '0x84D6',
  'TEXTURE23': '0x84D7',
  'TEXTURE24': '0x84D8',
  'TEXTURE25': '0x84D9',
  'TEXTURE26': '0x84DA',
  'TEXTURE27': '0x84DB',
  'TEXTURE28': '0x84DC',
  'TEXTURE29': '0x84DD',
  'TEXTURE30': '0x84DE',
  'TEXTURE31': '0x84DF',
  'ACTIVE_TEXTURE': '0x84E0',
  'CLIENT_ACTIVE_TEXTURE': '0x84E1',
  'MAX_TEXTURE_UNITS': '0x84E2',
  'TRANSPOSE_MODELVIEW_MATRIX': '0x84E3',
  'TRANSPOSE_PROJECTION_MATRIX': '0x84E4',
  'TRANSPOSE_TEXTURE_MATRIX': '0x84E5',
  'TRANSPOSE_COLOR_MATRIX': '0x84E6',
  'SUBTRACT': '0x84E7',
  'COMPRESSED_ALPHA': '0x84E9',
  'COMPRESSED_LUMINANCE': '0x84EA',
  'COMPRESSED_LUMINANCE_ALPHA': '0x84EB',
  'COMPRESSED_INTENSITY': '0x84EC',
  'COMPRESSED_RGB': '0x84ED',
  'COMPRESSED_RGBA': '0x84EE',
  'TEXTURE_COMPRESSION_HINT': '0x84EF',
  'NORMAL_MAP': '0x8511',
  'REFLECTION_MAP': '0x8512',
  'TEXTURE_CUBE_MAP': '0x8513',
  'TEXTURE_BINDING_CUBE_MAP': '0x8514',
  'TEXTURE_CUBE_MAP_POSITIVE_X': '0x8515',
  'TEXTURE_CUBE_MAP_NEGATIVE_X': '0x8516',
  'TEXTURE_CUBE_MAP_POSITIVE_Y': '0x8517',
  'TEXTURE_CUBE_MAP_NEGATIVE_Y': '0x8518',
  'TEXTURE_CUBE_MAP_POSITIVE_Z': '0x8519',
  'TEXTURE_CUBE_MAP_NEGATIVE_Z': '0x851A',
  'PROXY_TEXTURE_CUBE_MAP': '0x851B',
  'MAX_CUBE_MAP_TEXTURE_SIZE': '0x851C',
  'COMBINE': '0x8570',
  'COMBINE_RGB': '0x8571',
  'COMBINE_ALPHA': '0x8572',
  'RGB_SCALE': '0x8573',
  'ADD_SIGNED': '0x8574',
  'INTERPOLATE': '0x8575',
  'CONSTANT': '0x8576',
  'PRIMARY_COLOR': '0x8577',
  'PREVIOUS': '0x8578',
  'SOURCE0_RGB': '0x8580',
  'SOURCE1_RGB': '0x8581',
  'SOURCE2_RGB': '0x8582',
  'SOURCE0_ALPHA': '0x8588',
  'SOURCE1_ALPHA': '0x8589',
  'SOURCE2_ALPHA': '0x858A',
  'OPERAND0_RGB': '0x8590',
  'OPERAND1_RGB': '0x8591',
  'OPERAND2_RGB': '0x8592',
  'OPERAND0_ALPHA': '0x8598',
  'OPERAND1_ALPHA': '0x8599',
  'OPERAND2_ALPHA': '0x859A',
  'TEXTURE_COMPRESSED_IMAGE_SIZE': '0x86A0',
  'TEXTURE_COMPRESSED': '0x86A1',
  'NUM_COMPRESSED_TEXTURE_FORMATS': '0x86A2',
  'COMPRESSED_TEXTURE_FORMATS': '0x86A3',
  'DOT3_RGB': '0x86AE',
  'DOT3_RGBA': '0x86AF',
  'MULTISAMPLE_BIT': '0x20000000',
  'BLEND_DST_RGB': '0x80C8',
  'BLEND_SRC_RGB': '0x80C9',
  'BLEND_DST_ALPHA': '0x80CA',
  'BLEND_SRC_ALPHA': '0x80CB',
  'POINT_SIZE_MIN': '0x8126',
  'POINT_SIZE_MAX': '0x8127',
  'POINT_FADE_THRESHOLD_SIZE': '0x8128',
  'POINT_DISTANCE_ATTENUATION': '0x8129',
  'GENERATE_MIPMAP': '0x8191',
  'GENERATE_MIPMAP_HINT': '0x8192',
  'DEPTH_COMPONENT16': '0x81A5',
  'DEPTH_COMPONENT24': '0x81A6',
  'DEPTH_COMPONENT32': '0x81A7',
  'MIRRORED_REPEAT': '0x8370',
  'FOG_COORDINATE_SOURCE': '0x8450',
  'FOG_COORDINATE': '0x8451',
  'FRAGMENT_DEPTH': '0x8452',
  'CURRENT_FOG_COORDINATE': '0x8453',
  'FOG_COORDINATE_ARRAY_TYPE': '0x8454',
  'FOG_COORDINATE_ARRAY_STRIDE': '0x8455',
  'FOG_COORDINATE_ARRAY_POINTER': '0x8456',
  'FOG_COORDINATE_ARRAY': '0x8457',
  'COLOR_SUM': '0x8458',
  'CURRENT_SECONDARY_COLOR': '0x8459',
  'SECONDARY_COLOR_ARRAY_SIZE': '0x845A',
  'SECONDARY_COLOR_ARRAY_TYPE': '0x845B',
  'SECONDARY_COLOR_ARRAY_STRIDE': '0x845C',
  'SECONDARY_COLOR_ARRAY_POINTER': '0x845D',
  'SECONDARY_COLOR_ARRAY': '0x845E',
  'MAX_TEXTURE_LOD_BIAS': '0x84FD',
  'TEXTURE_FILTER_CONTROL': '0x8500',
  'TEXTURE_LOD_BIAS': '0x8501',
  'INCR_WRAP': '0x8507',
  'DECR_WRAP': '0x8508',
  'TEXTURE_DEPTH_SIZE': '0x884A',
  'DEPTH_TEXTURE_MODE': '0x884B',
  'TEXTURE_COMPARE_MODE': '0x884C',
  'TEXTURE_COMPARE_FUNC': '0x884D',
  'COMPARE_R_TO_TEXTURE': '0x884E',
  'BUFFER_SIZE': '0x8764',
  'BUFFER_USAGE': '0x8765',
  'QUERY_COUNTER_BITS': '0x8864',
  'CURRENT_QUERY': '0x8865',
  'QUERY_RESULT': '0x8866',
  'QUERY_RESULT_AVAILABLE': '0x8867',
  'ARRAY_BUFFER': '0x8892',
  'ELEMENT_ARRAY_BUFFER': '0x8893',
  'ARRAY_BUFFER_BINDING': '0x8894',
  'ELEMENT_ARRAY_BUFFER_BINDING': '0x8895',
  'VERTEX_ARRAY_BUFFER_BINDING': '0x8896',
  'NORMAL_ARRAY_BUFFER_BINDING': '0x8897',
  'COLOR_ARRAY_BUFFER_BINDING': '0x8898',
  'INDEX_ARRAY_BUFFER_BINDING': '0x8899',
  'TEXTURE_COORD_ARRAY_BUFFER_BINDING': '0x889A',
  'EDGE_FLAG_ARRAY_BUFFER_BINDING': '0x889B',
  'SECONDARY_COLOR_ARRAY_BUFFER_BINDING': '0x889C',
  'FOG_COORDINATE_ARRAY_BUFFER_BINDING': '0x889D',
  'WEIGHT_ARRAY_BUFFER_BINDING': '0x889E',
  'VERTEX_ATTRIB_ARRAY_BUFFER_BINDING': '0x889F',
  'READ_ONLY': '0x88B8',
  'WRITE_ONLY': '0x88B9',
  'READ_WRITE': '0x88BA',
  'BUFFER_ACCESS': '0x88BB',
  'BUFFER_MAPPED': '0x88BC',
  'BUFFER_MAP_POINTER': '0x88BD',
  'STREAM_DRAW': '0x88E0',
  'STREAM_READ': '0x88E1',
  'STREAM_COPY': '0x88E2',
  'STATIC_DRAW': '0x88E4',
  'STATIC_READ': '0x88E5',
  'STATIC_COPY': '0x88E6',
  'DYNAMIC_DRAW': '0x88E8',
  'DYNAMIC_READ': '0x88E9',
  'DYNAMIC_COPY': '0x88EA',
  'SAMPLES_PASSED': '0x8914',
  'VERTEX_ATTRIB_ARRAY_ENABLED': '0x8622',
  'VERTEX_ATTRIB_ARRAY_SIZE': '0x8623',
  'VERTEX_ATTRIB_ARRAY_STRIDE': '0x8624',
  'VERTEX_ATTRIB_ARRAY_TYPE': '0x8625',
  'CURRENT_VERTEX_ATTRIB': '0x8626',
  'VERTEX_PROGRAM_POINT_SIZE': '0x8642',
  'VERTEX_PROGRAM_TWO_SIDE': '0x8643',
  'VERTEX_ATTRIB_ARRAY_POINTER': '0x8645',
  'STENCIL_BACK_FUNC': '0x8800',
  'STENCIL_BACK_FAIL': '0x8801',
  'STENCIL_BACK_PASS_DEPTH_FAIL': '0x8802',
  'STENCIL_BACK_PASS_DEPTH_PASS': '0x8803',
  'MAX_DRAW_BUFFERS': '0x8824',
  'DRAW_BUFFER0': '0x8825',
  'DRAW_BUFFER1': '0x8826',
  'DRAW_BUFFER2': '0x8827',
  'DRAW_BUFFER3': '0x8828',
  'DRAW_BUFFER4': '0x8829',
  'DRAW_BUFFER5': '0x882A',
  'DRAW_BUFFER6': '0x882B',
  'DRAW_BUFFER7': '0x882C',
  'DRAW_BUFFER8': '0x882D',
  'DRAW_BUFFER9': '0x882E',
  'DRAW_BUFFER10': '0x882F',
  'DRAW_BUFFER11': '0x8830',
  'DRAW_BUFFER12': '0x8831',
  'DRAW_BUFFER13': '0x8832',
  'DRAW_BUFFER14': '0x8833',
  'DRAW_BUFFER15': '0x8834',
  'BLEND_EQUATION_ALPHA': '0x883D',
  'POINT_SPRITE': '0x8861',
  'COORD_REPLACE': '0x8862',
  'MAX_VERTEX_ATTRIBS': '0x8869',
  'VERTEX_ATTRIB_ARRAY_NORMALIZED': '0x886A',
  'MAX_TEXTURE_COORDS': '0x8871',
  'MAX_TEXTURE_IMAGE_UNITS': '0x8872',
  'FRAGMENT_SHADER': '0x8B30',
  'VERTEX_SHADER': '0x8B31',
  'MAX_FRAGMENT_UNIFORM_COMPONENTS': '0x8B49',
  'MAX_VERTEX_UNIFORM_COMPONENTS': '0x8B4A',
  'MAX_VARYING_FLOATS': '0x8B4B',
  'MAX_VERTEX_TEXTURE_IMAGE_UNITS': '0x8B4C',
  'MAX_COMBINED_TEXTURE_IMAGE_UNITS': '0x8B4D',
  'SHADER_TYPE': '0x8B4F',
  'FLOAT_VEC2': '0x8B50',
  'FLOAT_VEC3': '0x8B51',
  'FLOAT_VEC4': '0x8B52',
  'INT_VEC2': '0x8B53',
  'INT_VEC3': '0x8B54',
  'INT_VEC4': '0x8B55',
  'BOOL': '0x8B56',
  'BOOL_VEC2': '0x8B57',
  'BOOL_VEC3': '0x8B58',
  'BOOL_VEC4': '0x8B59',
  'FLOAT_MAT2': '0x8B5A',
  'FLOAT_MAT3': '0x8B5B',
  'FLOAT_MAT4': '0x8B5C',
  'SAMPLER_1D': '0x8B5D',
  'SAMPLER_2D': '0x8B5E',
  'SAMPLER_3D': '0x8B5F',
  'SAMPLER_CUBE': '0x8B60',
  'SAMPLER_1D_SHADOW': '0x8B61',
  'SAMPLER_2D_SHADOW': '0x8B62',
  'DELETE_STATUS': '0x8B80',
  'COMPILE_STATUS': '0x8B81',
  'LINK_STATUS': '0x8B82',
  'VALIDATE_STATUS': '0x8B83',
  'INFO_LOG_LENGTH': '0x8B84',
  'ATTACHED_SHADERS': '0x8B85',
  'ACTIVE_UNIFORMS': '0x8B86',
  'ACTIVE_UNIFORM_MAX_LENGTH': '0x8B87',
  'SHADER_SOURCE_LENGTH': '0x8B88',
  'ACTIVE_ATTRIBUTES': '0x8B89',
  'ACTIVE_ATTRIBUTE_MAX_LENGTH': '0x8B8A',
  'FRAGMENT_SHADER_DERIVATIVE_HINT': '0x8B8B',
  'SHADING_LANGUAGE_VERSION': '0x8B8C',
  'CURRENT_PROGRAM': '0x8B8D',
  'POINT_SPRITE_COORD_ORIGIN': '0x8CA0',
  'LOWER_LEFT': '0x8CA1',
  'UPPER_LEFT': '0x8CA2',
  'STENCIL_BACK_REF': '0x8CA3',
  'STENCIL_BACK_VALUE_MASK': '0x8CA4',
  'STENCIL_BACK_WRITEMASK': '0x8CA5',
  'CURRENT_RASTER_SECONDARY_COLOR': '0x845F',
  'PIXEL_PACK_BUFFER': '0x88EB',
  'PIXEL_UNPACK_BUFFER': '0x88EC',
  'PIXEL_PACK_BUFFER_BINDING': '0x88ED',
  'PIXEL_UNPACK_BUFFER_BINDING': '0x88EF',
  'FLOAT_MAT2x3': '0x8B65',
  'FLOAT_MAT2x4': '0x8B66',
  'FLOAT_MAT3x2': '0x8B67',
  'FLOAT_MAT3x4': '0x8B68',
  'FLOAT_MAT4x2': '0x8B69',
  'FLOAT_MAT4x3': '0x8B6A',
  'SRGB': '0x8C40',
  'SRGB8': '0x8C41',
  'SRGB_ALPHA': '0x8C42',
  'SRGB8_ALPHA8': '0x8C43',
  'SLUMINANCE_ALPHA': '0x8C44',
  'SLUMINANCE8_ALPHA8': '0x8C45',
  'SLUMINANCE': '0x8C46',
  'SLUMINANCE8': '0x8C47',
  'COMPRESSED_SRGB': '0x8C48',
  'COMPRESSED_SRGB_ALPHA': '0x8C49',
  'COMPRESSED_SLUMINANCE': '0x8C4A',
  'COMPRESSED_SLUMINANCE_ALPHA': '0x8C4B',
  'CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT': '0x0001',
  'MAJOR_VERSION': '0x821B',
  'MINOR_VERSION': '0x821C',
  'NUM_EXTENSIONS': '0x821D',
  'CONTEXT_FLAGS': '0x821E',
  'DEPTH_BUFFER': '0x8223',
  'STENCIL_BUFFER': '0x8224',
  'COMPRESSED_RED': '0x8225',
  'COMPRESSED_RG': '0x8226',
  'RGBA32F': '0x8814',
  'RGB32F': '0x8815',
  'RGBA16F': '0x881A',
  'RGB16F': '0x881B',
  'VERTEX_ATTRIB_ARRAY_INTEGER': '0x88FD',
  'MAX_ARRAY_TEXTURE_LAYERS': '0x88FF',
  'MIN_PROGRAM_TEXEL_OFFSET': '0x8904',
  'MAX_PROGRAM_TEXEL_OFFSET': '0x8905',
  'CLAMP_VERTEX_COLOR': '0x891A',
  'CLAMP_FRAGMENT_COLOR': '0x891B',
  'CLAMP_READ_COLOR': '0x891C',
  'FIXED_ONLY': '0x891D',
  'TEXTURE_RED_TYPE': '0x8C10',
  'TEXTURE_GREEN_TYPE': '0x8C11',
  'TEXTURE_BLUE_TYPE': '0x8C12',
  'TEXTURE_ALPHA_TYPE': '0x8C13',
  'TEXTURE_LUMINANCE_TYPE': '0x8C14',
  'TEXTURE_INTENSITY_TYPE': '0x8C15',
  'TEXTURE_DEPTH_TYPE': '0x8C16',
  'UNSIGNED_NORMALIZED': '0x8C17',
  'TEXTURE_1D_ARRAY': '0x8C18',
  'PROXY_TEXTURE_1D_ARRAY': '0x8C19',
  'TEXTURE_2D_ARRAY': '0x8C1A',
  'PROXY_TEXTURE_2D_ARRAY': '0x8C1B',
  'TEXTURE_BINDING_1D_ARRAY': '0x8C1C',
  'TEXTURE_BINDING_2D_ARRAY': '0x8C1D',
  'R11F_G11F_B10F': '0x8C3A',
  'UNSIGNED_INT_10F_11F_11F_REV': '0x8C3B',
  'RGB9_E5': '0x8C3D',
  'UNSIGNED_INT_5_9_9_9_REV': '0x8C3E',
  'TEXTURE_SHARED_SIZE': '0x8C3F',
  'TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH': '0x8C76',
  'TRANSFORM_FEEDBACK_BUFFER_MODE': '0x8C7F',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS': '0x8C80',
  'TRANSFORM_FEEDBACK_VARYINGS': '0x8C83',
  'TRANSFORM_FEEDBACK_BUFFER_START': '0x8C84',
  'TRANSFORM_FEEDBACK_BUFFER_SIZE': '0x8C85',
  'PRIMITIVES_GENERATED': '0x8C87',
  'TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN': '0x8C88',
  'RASTERIZER_DISCARD': '0x8C89',
  'MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS': '0x8C8A',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS': '0x8C8B',
  'INTERLEAVED_ATTRIBS': '0x8C8C',
  'SEPARATE_ATTRIBS': '0x8C8D',
  'TRANSFORM_FEEDBACK_BUFFER': '0x8C8E',
  'TRANSFORM_FEEDBACK_BUFFER_BINDING': '0x8C8F',
  'RGBA32UI': '0x8D70',
  'RGB32UI': '0x8D71',
  'RGBA16UI': '0x8D76',
  'RGB16UI': '0x8D77',
  'RGBA8UI': '0x8D7C',
  'RGB8UI': '0x8D7D',
  'RGBA32I': '0x8D82',
  'RGB32I': '0x8D83',
  'RGBA16I': '0x8D88',
  'RGB16I': '0x8D89',
  'RGBA8I': '0x8D8E',
  'RGB8I': '0x8D8F',
  'RED_INTEGER': '0x8D94',
  'GREEN_INTEGER': '0x8D95',
  'BLUE_INTEGER': '0x8D96',
  'ALPHA_INTEGER': '0x8D97',
  'RGB_INTEGER': '0x8D98',
  'RGBA_INTEGER': '0x8D99',
  'BGR_INTEGER': '0x8D9A',
  'BGRA_INTEGER': '0x8D9B',
  'SAMPLER_1D_ARRAY': '0x8DC0',
  'SAMPLER_2D_ARRAY': '0x8DC1',
  'SAMPLER_1D_ARRAY_SHADOW': '0x8DC3',
  'SAMPLER_2D_ARRAY_SHADOW': '0x8DC4',
  'SAMPLER_CUBE_SHADOW': '0x8DC5',
  'UNSIGNED_INT_VEC2': '0x8DC6',
  'UNSIGNED_INT_VEC3': '0x8DC7',
  'UNSIGNED_INT_VEC4': '0x8DC8',
  'INT_SAMPLER_1D': '0x8DC9',
  'INT_SAMPLER_2D': '0x8DCA',
  'INT_SAMPLER_3D': '0x8DCB',
  'INT_SAMPLER_CUBE': '0x8DCC',
  'INT_SAMPLER_1D_ARRAY': '0x8DCE',
  'INT_SAMPLER_2D_ARRAY': '0x8DCF',
  'UNSIGNED_INT_SAMPLER_1D': '0x8DD1',
  'UNSIGNED_INT_SAMPLER_2D': '0x8DD2',
  'UNSIGNED_INT_SAMPLER_3D': '0x8DD3',
  'UNSIGNED_INT_SAMPLER_CUBE': '0x8DD4',
  'UNSIGNED_INT_SAMPLER_1D_ARRAY': '0x8DD6',
  'UNSIGNED_INT_SAMPLER_2D_ARRAY': '0x8DD7',
  'QUERY_WAIT': '0x8E13',
  'QUERY_NO_WAIT': '0x8E14',
  'QUERY_BY_REGION_WAIT': '0x8E15',
  'QUERY_BY_REGION_NO_WAIT': '0x8E16',
  'MULTISAMPLE_3DFX': '0x86B2',
  'SAMPLE_BUFFERS_3DFX': '0x86B3',
  'SAMPLES_3DFX': '0x86B4',
  'MULTISAMPLE_BIT_3DFX': '0x20000000',
  'COMPRESSED_RGB_FXT1_3DFX': '0x86B0',
  'COMPRESSED_RGBA_FXT1_3DFX': '0x86B1',
  'UNPACK_CLIENT_STORAGE_APPLE': '0x85B2',
  'ELEMENT_ARRAY_APPLE': '0x8768',
  'ELEMENT_ARRAY_TYPE_APPLE': '0x8769',
  'ELEMENT_ARRAY_POINTER_APPLE': '0x876A',
  'HALF_APPLE': '0x140B',
  'RGBA_FLOAT32_APPLE': '0x8814',
  'RGB_FLOAT32_APPLE': '0x8815',
  'ALPHA_FLOAT32_APPLE': '0x8816',
  'INTENSITY_FLOAT32_APPLE': '0x8817',
  'LUMINANCE_FLOAT32_APPLE': '0x8818',
  'LUMINANCE_ALPHA_FLOAT32_APPLE': '0x8819',
  'RGBA_FLOAT16_APPLE': '0x881A',
  'RGB_FLOAT16_APPLE': '0x881B',
  'ALPHA_FLOAT16_APPLE': '0x881C',
  'INTENSITY_FLOAT16_APPLE': '0x881D',
  'LUMINANCE_FLOAT16_APPLE': '0x881E',
  'LUMINANCE_ALPHA_FLOAT16_APPLE': '0x881F',
  'COLOR_FLOAT_APPLE': '0x8A0F',
  'BUFFER_SERIALIZED_MODIFY_APPLE': '0x8A12',
  'BUFFER_FLUSHING_UNMAP_APPLE': '0x8A13',
  'MIN_PBUFFER_VIEWPORT_DIMS_APPLE': '0x8A10',
  'LIGHT_MODEL_SPECULAR_VECTOR_APPLE': '0x85B0',
  'TEXTURE_RANGE_LENGTH_APPLE': '0x85B7',
  'TEXTURE_RANGE_POINTER_APPLE': '0x85B8',
  'TEXTURE_STORAGE_HINT_APPLE': '0x85BC',
  'STORAGE_PRIVATE_APPLE': '0x85BD',
  'STORAGE_CACHED_APPLE': '0x85BE',
  'STORAGE_SHARED_APPLE': '0x85BF',
  'TRANSFORM_HINT_APPLE': '0x85B1',
  'VERTEX_ARRAY_BINDING_APPLE': '0x85B5',
  'VERTEX_ARRAY_RANGE_APPLE': '0x851D',
  'VERTEX_ARRAY_RANGE_LENGTH_APPLE': '0x851E',
  'VERTEX_ARRAY_STORAGE_HINT_APPLE': '0x851F',
  'MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE': '0x8520',
  'VERTEX_ARRAY_RANGE_POINTER_APPLE': '0x8521',
  'STORAGE_CACHED_APPLE': '0x85BE',
  'STORAGE_SHARED_APPLE': '0x85BF',
  'YCBCR_422_APPLE': '0x85B9',
  'UNSIGNED_SHORT_8_8_APPLE': '0x85BA',
  'UNSIGNED_SHORT_8_8_REV_APPLE': '0x85BB',
  'RGBA_FLOAT_MODE_ARB': '0x8820',
  'CLAMP_VERTEX_COLOR_ARB': '0x891A',
  'CLAMP_FRAGMENT_COLOR_ARB': '0x891B',
  'CLAMP_READ_COLOR_ARB': '0x891C',
  'FIXED_ONLY_ARB': '0x891D',
  'DEPTH_COMPONENT32F': '0x8CAC',
  'DEPTH32F_STENCIL8': '0x8CAD',
  'FLOAT_32_UNSIGNED_INT_24_8_REV': '0x8DAD',
  'DEPTH_COMPONENT16_ARB': '0x81A5',
  'DEPTH_COMPONENT24_ARB': '0x81A6',
  'DEPTH_COMPONENT32_ARB': '0x81A7',
  'TEXTURE_DEPTH_SIZE_ARB': '0x884A',
  'DEPTH_TEXTURE_MODE_ARB': '0x884B',
  'MAX_DRAW_BUFFERS_ARB': '0x8824',
  'DRAW_BUFFER0_ARB': '0x8825',
  'DRAW_BUFFER1_ARB': '0x8826',
  'DRAW_BUFFER2_ARB': '0x8827',
  'DRAW_BUFFER3_ARB': '0x8828',
  'DRAW_BUFFER4_ARB': '0x8829',
  'DRAW_BUFFER5_ARB': '0x882A',
  'DRAW_BUFFER6_ARB': '0x882B',
  'DRAW_BUFFER7_ARB': '0x882C',
  'DRAW_BUFFER8_ARB': '0x882D',
  'DRAW_BUFFER9_ARB': '0x882E',
  'DRAW_BUFFER10_ARB': '0x882F',
  'DRAW_BUFFER11_ARB': '0x8830',
  'DRAW_BUFFER12_ARB': '0x8831',
  'DRAW_BUFFER13_ARB': '0x8832',
  'DRAW_BUFFER14_ARB': '0x8833',
  'DRAW_BUFFER15_ARB': '0x8834',
  'FRAGMENT_PROGRAM_ARB': '0x8804',
  'PROGRAM_ALU_INSTRUCTIONS_ARB': '0x8805',
  'PROGRAM_TEX_INSTRUCTIONS_ARB': '0x8806',
  'PROGRAM_TEX_INDIRECTIONS_ARB': '0x8807',
  'PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB': '0x8808',
  'PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB': '0x8809',
  'PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB': '0x880A',
  'MAX_PROGRAM_ALU_INSTRUCTIONS_ARB': '0x880B',
  'MAX_PROGRAM_TEX_INSTRUCTIONS_ARB': '0x880C',
  'MAX_PROGRAM_TEX_INDIRECTIONS_ARB': '0x880D',
  'MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB': '0x880E',
  'MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB': '0x880F',
  'MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB': '0x8810',
  'MAX_TEXTURE_COORDS_ARB': '0x8871',
  'MAX_TEXTURE_IMAGE_UNITS_ARB': '0x8872',
  'FRAGMENT_SHADER_ARB': '0x8B30',
  'MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB': '0x8B49',
  'FRAGMENT_SHADER_DERIVATIVE_HINT_ARB': '0x8B8B',
  'INVALID_FRAMEBUFFER_OPERATION': '0x0506',
  'FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING': '0x8210',
  'FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE': '0x8211',
  'FRAMEBUFFER_ATTACHMENT_RED_SIZE': '0x8212',
  'FRAMEBUFFER_ATTACHMENT_GREEN_SIZE': '0x8213',
  'FRAMEBUFFER_ATTACHMENT_BLUE_SIZE': '0x8214',
  'FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE': '0x8215',
  'FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE': '0x8216',
  'FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE': '0x8217',
  'FRAMEBUFFER_DEFAULT': '0x8218',
  'FRAMEBUFFER_UNDEFINED': '0x8219',
  'DEPTH_STENCIL_ATTACHMENT': '0x821A',
  'INDEX': '0x8222',
  'MAX_RENDERBUFFER_SIZE': '0x84E8',
  'DEPTH_STENCIL': '0x84F9',
  'UNSIGNED_INT_24_8': '0x84FA',
  'DEPTH24_STENCIL8': '0x88F0',
  'TEXTURE_STENCIL_SIZE': '0x88F1',
  'UNSIGNED_NORMALIZED': '0x8C17',
  'SRGB': '0x8C40',
  'DRAW_FRAMEBUFFER_BINDING': '0x8CA6',
  'FRAMEBUFFER_BINDING': '0x8CA6',
  'RENDERBUFFER_BINDING': '0x8CA7',
  'READ_FRAMEBUFFER': '0x8CA8',
  'DRAW_FRAMEBUFFER': '0x8CA9',
  'READ_FRAMEBUFFER_BINDING': '0x8CAA',
  'RENDERBUFFER_SAMPLES': '0x8CAB',
  'FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE': '0x8CD0',
  'FRAMEBUFFER_ATTACHMENT_OBJECT_NAME': '0x8CD1',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL': '0x8CD2',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE': '0x8CD3',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER': '0x8CD4',
  'FRAMEBUFFER_COMPLETE': '0x8CD5',
  'FRAMEBUFFER_INCOMPLETE_ATTACHMENT': '0x8CD6',
  'FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT': '0x8CD7',
  'FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER': '0x8CDB',
  'FRAMEBUFFER_INCOMPLETE_READ_BUFFER': '0x8CDC',
  'FRAMEBUFFER_UNSUPPORTED': '0x8CDD',
  'MAX_COLOR_ATTACHMENTS': '0x8CDF',
  'COLOR_ATTACHMENT0': '0x8CE0',
  'COLOR_ATTACHMENT1': '0x8CE1',
  'COLOR_ATTACHMENT2': '0x8CE2',
  'COLOR_ATTACHMENT3': '0x8CE3',
  'COLOR_ATTACHMENT4': '0x8CE4',
  'COLOR_ATTACHMENT5': '0x8CE5',
  'COLOR_ATTACHMENT6': '0x8CE6',
  'COLOR_ATTACHMENT7': '0x8CE7',
  'COLOR_ATTACHMENT8': '0x8CE8',
  'COLOR_ATTACHMENT9': '0x8CE9',
  'COLOR_ATTACHMENT10': '0x8CEA',
  'COLOR_ATTACHMENT11': '0x8CEB',
  'COLOR_ATTACHMENT12': '0x8CEC',
  'COLOR_ATTACHMENT13': '0x8CED',
  'COLOR_ATTACHMENT14': '0x8CEE',
  'COLOR_ATTACHMENT15': '0x8CEF',
  'DEPTH_ATTACHMENT': '0x8D00',
  'STENCIL_ATTACHMENT': '0x8D20',
  'FRAMEBUFFER': '0x8D40',
  'RENDERBUFFER': '0x8D41',
  'RENDERBUFFER_WIDTH': '0x8D42',
  'RENDERBUFFER_HEIGHT': '0x8D43',
  'RENDERBUFFER_INTERNAL_FORMAT': '0x8D44',
  'STENCIL_INDEX1': '0x8D46',
  'STENCIL_INDEX4': '0x8D47',
  'STENCIL_INDEX8': '0x8D48',
  'STENCIL_INDEX16': '0x8D49',
  'RENDERBUFFER_RED_SIZE': '0x8D50',
  'RENDERBUFFER_GREEN_SIZE': '0x8D51',
  'RENDERBUFFER_BLUE_SIZE': '0x8D52',
  'RENDERBUFFER_ALPHA_SIZE': '0x8D53',
  'RENDERBUFFER_DEPTH_SIZE': '0x8D54',
  'RENDERBUFFER_STENCIL_SIZE': '0x8D55',
  'FRAMEBUFFER_INCOMPLETE_MULTISAMPLE': '0x8D56',
  'MAX_SAMPLES': '0x8D57',
  'FRAMEBUFFER_SRGB': '0x8DB9',
  'LINES_ADJACENCY_ARB': '0xA',
  'LINE_STRIP_ADJACENCY_ARB': '0xB',
  'TRIANGLES_ADJACENCY_ARB': '0xC',
  'TRIANGLE_STRIP_ADJACENCY_ARB': '0xD',
  'PROGRAM_POINT_SIZE_ARB': '0x8642',
  'MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB': '0x8C29',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER': '0x8CD4',
  'FRAMEBUFFER_ATTACHMENT_LAYERED_ARB': '0x8DA7',
  'FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB': '0x8DA8',
  'FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB': '0x8DA9',
  'GEOMETRY_SHADER_ARB': '0x8DD9',
  'GEOMETRY_VERTICES_OUT_ARB': '0x8DDA',
  'GEOMETRY_INPUT_TYPE_ARB': '0x8DDB',
  'GEOMETRY_OUTPUT_TYPE_ARB': '0x8DDC',
  'MAX_GEOMETRY_VARYING_COMPONENTS_ARB': '0x8DDD',
  'MAX_VERTEX_VARYING_COMPONENTS_ARB': '0x8DDE',
  'MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB': '0x8DDF',
  'MAX_GEOMETRY_OUTPUT_VERTICES_ARB': '0x8DE0',
  'MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB': '0x8DE1',
  'HALF_FLOAT_ARB': '0x140B',
  'HALF_FLOAT': '0x140B',
  'CONSTANT_COLOR': '0x8001',
  'ONE_MINUS_CONSTANT_COLOR': '0x8002',
  'CONSTANT_ALPHA': '0x8003',
  'ONE_MINUS_CONSTANT_ALPHA': '0x8004',
  'BLEND_COLOR': '0x8005',
  'FUNC_ADD': '0x8006',
  'MIN': '0x8007',
  'MAX': '0x8008',
  'BLEND_EQUATION': '0x8009',
  'FUNC_SUBTRACT': '0x800A',
  'FUNC_REVERSE_SUBTRACT': '0x800B',
  'CONVOLUTION_1D': '0x8010',
  'CONVOLUTION_2D': '0x8011',
  'SEPARABLE_2D': '0x8012',
  'CONVOLUTION_BORDER_MODE': '0x8013',
  'CONVOLUTION_FILTER_SCALE': '0x8014',
  'CONVOLUTION_FILTER_BIAS': '0x8015',
  'REDUCE': '0x8016',
  'CONVOLUTION_FORMAT': '0x8017',
  'CONVOLUTION_WIDTH': '0x8018',
  'CONVOLUTION_HEIGHT': '0x8019',
  'MAX_CONVOLUTION_WIDTH': '0x801A',
  'MAX_CONVOLUTION_HEIGHT': '0x801B',
  'POST_CONVOLUTION_RED_SCALE': '0x801C',
  'POST_CONVOLUTION_GREEN_SCALE': '0x801D',
  'POST_CONVOLUTION_BLUE_SCALE': '0x801E',
  'POST_CONVOLUTION_ALPHA_SCALE': '0x801F',
  'POST_CONVOLUTION_RED_BIAS': '0x8020',
  'POST_CONVOLUTION_GREEN_BIAS': '0x8021',
  'POST_CONVOLUTION_BLUE_BIAS': '0x8022',
  'POST_CONVOLUTION_ALPHA_BIAS': '0x8023',
  'HISTOGRAM': '0x8024',
  'PROXY_HISTOGRAM': '0x8025',
  'HISTOGRAM_WIDTH': '0x8026',
  'HISTOGRAM_FORMAT': '0x8027',
  'HISTOGRAM_RED_SIZE': '0x8028',
  'HISTOGRAM_GREEN_SIZE': '0x8029',
  'HISTOGRAM_BLUE_SIZE': '0x802A',
  'HISTOGRAM_ALPHA_SIZE': '0x802B',
  'HISTOGRAM_LUMINANCE_SIZE': '0x802C',
  'HISTOGRAM_SINK': '0x802D',
  'MINMAX': '0x802E',
  'MINMAX_FORMAT': '0x802F',
  'MINMAX_SINK': '0x8030',
  'TABLE_TOO_LARGE': '0x8031',
  'COLOR_MATRIX': '0x80B1',
  'COLOR_MATRIX_STACK_DEPTH': '0x80B2',
  'MAX_COLOR_MATRIX_STACK_DEPTH': '0x80B3',
  'POST_COLOR_MATRIX_RED_SCALE': '0x80B4',
  'POST_COLOR_MATRIX_GREEN_SCALE': '0x80B5',
  'POST_COLOR_MATRIX_BLUE_SCALE': '0x80B6',
  'POST_COLOR_MATRIX_ALPHA_SCALE': '0x80B7',
  'POST_COLOR_MATRIX_RED_BIAS': '0x80B8',
  'POST_COLOR_MATRIX_GREEN_BIAS': '0x80B9',
  'POST_COLOR_MATRIX_BLUE_BIAS': '0x80BA',
  'POST_COLOR_MATRIX_ALPHA_BIAS': '0x80BB',
  'COLOR_TABLE': '0x80D0',
  'POST_CONVOLUTION_COLOR_TABLE': '0x80D1',
  'POST_COLOR_MATRIX_COLOR_TABLE': '0x80D2',
  'PROXY_COLOR_TABLE': '0x80D3',
  'PROXY_POST_CONVOLUTION_COLOR_TABLE': '0x80D4',
  'PROXY_POST_COLOR_MATRIX_COLOR_TABLE': '0x80D5',
  'COLOR_TABLE_SCALE': '0x80D6',
  'COLOR_TABLE_BIAS': '0x80D7',
  'COLOR_TABLE_FORMAT': '0x80D8',
  'COLOR_TABLE_WIDTH': '0x80D9',
  'COLOR_TABLE_RED_SIZE': '0x80DA',
  'COLOR_TABLE_GREEN_SIZE': '0x80DB',
  'COLOR_TABLE_BLUE_SIZE': '0x80DC',
  'COLOR_TABLE_ALPHA_SIZE': '0x80DD',
  'COLOR_TABLE_LUMINANCE_SIZE': '0x80DE',
  'COLOR_TABLE_INTENSITY_SIZE': '0x80DF',
  'IGNORE_BORDER': '0x8150',
  'CONSTANT_BORDER': '0x8151',
  'WRAP_BORDER': '0x8152',
  'REPLICATE_BORDER': '0x8153',
  'CONVOLUTION_BORDER_COLOR': '0x8154',
  'VERTEX_ATTRIB_ARRAY_DIVISOR_ARB': '0x88FE',
  'MAP_READ_BIT': '0x0001',
  'MAP_WRITE_BIT': '0x0002',
  'MAP_INVALIDATE_RANGE_BIT': '0x0004',
  'MAP_INVALIDATE_BUFFER_BIT': '0x0008',
  'MAP_FLUSH_EXPLICIT_BIT': '0x0010',
  'MAP_UNSYNCHRONIZED_BIT': '0x0020',
  'MATRIX_PALETTE_ARB': '0x8840',
  'MAX_MATRIX_PALETTE_STACK_DEPTH_ARB': '0x8841',
  'MAX_PALETTE_MATRICES_ARB': '0x8842',
  'CURRENT_PALETTE_MATRIX_ARB': '0x8843',
  'MATRIX_INDEX_ARRAY_ARB': '0x8844',
  'CURRENT_MATRIX_INDEX_ARB': '0x8845',
  'MATRIX_INDEX_ARRAY_SIZE_ARB': '0x8846',
  'MATRIX_INDEX_ARRAY_TYPE_ARB': '0x8847',
  'MATRIX_INDEX_ARRAY_STRIDE_ARB': '0x8848',
  'MATRIX_INDEX_ARRAY_POINTER_ARB': '0x8849',
  'MULTISAMPLE_ARB': '0x809D',
  'SAMPLE_ALPHA_TO_COVERAGE_ARB': '0x809E',
  'SAMPLE_ALPHA_TO_ONE_ARB': '0x809F',
  'SAMPLE_COVERAGE_ARB': '0x80A0',
  'SAMPLE_BUFFERS_ARB': '0x80A8',
  'SAMPLES_ARB': '0x80A9',
  'SAMPLE_COVERAGE_VALUE_ARB': '0x80AA',
  'SAMPLE_COVERAGE_INVERT_ARB': '0x80AB',
  'MULTISAMPLE_BIT_ARB': '0x20000000',
  'TEXTURE0_ARB': '0x84C0',
  'TEXTURE1_ARB': '0x84C1',
  'TEXTURE2_ARB': '0x84C2',
  'TEXTURE3_ARB': '0x84C3',
  'TEXTURE4_ARB': '0x84C4',
  'TEXTURE5_ARB': '0x84C5',
  'TEXTURE6_ARB': '0x84C6',
  'TEXTURE7_ARB': '0x84C7',
  'TEXTURE8_ARB': '0x84C8',
  'TEXTURE9_ARB': '0x84C9',
  'TEXTURE10_ARB': '0x84CA',
  'TEXTURE11_ARB': '0x84CB',
  'TEXTURE12_ARB': '0x84CC',
  'TEXTURE13_ARB': '0x84CD',
  'TEXTURE14_ARB': '0x84CE',
  'TEXTURE15_ARB': '0x84CF',
  'TEXTURE16_ARB': '0x84D0',
  'TEXTURE17_ARB': '0x84D1',
  'TEXTURE18_ARB': '0x84D2',
  'TEXTURE19_ARB': '0x84D3',
  'TEXTURE20_ARB': '0x84D4',
  'TEXTURE21_ARB': '0x84D5',
  'TEXTURE22_ARB': '0x84D6',
  'TEXTURE23_ARB': '0x84D7',
  'TEXTURE24_ARB': '0x84D8',
  'TEXTURE25_ARB': '0x84D9',
  'TEXTURE26_ARB': '0x84DA',
  'TEXTURE27_ARB': '0x84DB',
  'TEXTURE28_ARB': '0x84DC',
  'TEXTURE29_ARB': '0x84DD',
  'TEXTURE30_ARB': '0x84DE',
  'TEXTURE31_ARB': '0x84DF',
  'ACTIVE_TEXTURE_ARB': '0x84E0',
  'CLIENT_ACTIVE_TEXTURE_ARB': '0x84E1',
  'MAX_TEXTURE_UNITS_ARB': '0x84E2',
  'QUERY_COUNTER_BITS_ARB': '0x8864',
  'CURRENT_QUERY_ARB': '0x8865',
  'QUERY_RESULT_ARB': '0x8866',
  'QUERY_RESULT_AVAILABLE_ARB': '0x8867',
  'SAMPLES_PASSED_ARB': '0x8914',
  'PIXEL_PACK_BUFFER_ARB': '0x88EB',
  'PIXEL_UNPACK_BUFFER_ARB': '0x88EC',
  'PIXEL_PACK_BUFFER_BINDING_ARB': '0x88ED',
  'PIXEL_UNPACK_BUFFER_BINDING_ARB': '0x88EF',
  'POINT_SIZE_MIN_ARB': '0x8126',
  'POINT_SIZE_MAX_ARB': '0x8127',
  'POINT_FADE_THRESHOLD_SIZE_ARB': '0x8128',
  'POINT_DISTANCE_ATTENUATION_ARB': '0x8129',
  'POINT_SPRITE_ARB': '0x8861',
  'COORD_REPLACE_ARB': '0x8862',
  'PROGRAM_OBJECT_ARB': '0x8B40',
  'SHADER_OBJECT_ARB': '0x8B48',
  'OBJECT_TYPE_ARB': '0x8B4E',
  'OBJECT_SUBTYPE_ARB': '0x8B4F',
  'FLOAT_VEC2_ARB': '0x8B50',
  'FLOAT_VEC3_ARB': '0x8B51',
  'FLOAT_VEC4_ARB': '0x8B52',
  'INT_VEC2_ARB': '0x8B53',
  'INT_VEC3_ARB': '0x8B54',
  'INT_VEC4_ARB': '0x8B55',
  'BOOL_ARB': '0x8B56',
  'BOOL_VEC2_ARB': '0x8B57',
  'BOOL_VEC3_ARB': '0x8B58',
  'BOOL_VEC4_ARB': '0x8B59',
  'FLOAT_MAT2_ARB': '0x8B5A',
  'FLOAT_MAT3_ARB': '0x8B5B',
  'FLOAT_MAT4_ARB': '0x8B5C',
  'SAMPLER_1D_ARB': '0x8B5D',
  'SAMPLER_2D_ARB': '0x8B5E',
  'SAMPLER_3D_ARB': '0x8B5F',
  'SAMPLER_CUBE_ARB': '0x8B60',
  'SAMPLER_1D_SHADOW_ARB': '0x8B61',
  'SAMPLER_2D_SHADOW_ARB': '0x8B62',
  'SAMPLER_2D_RECT_ARB': '0x8B63',
  'SAMPLER_2D_RECT_SHADOW_ARB': '0x8B64',
  'OBJECT_DELETE_STATUS_ARB': '0x8B80',
  'OBJECT_COMPILE_STATUS_ARB': '0x8B81',
  'OBJECT_LINK_STATUS_ARB': '0x8B82',
  'OBJECT_VALIDATE_STATUS_ARB': '0x8B83',
  'OBJECT_INFO_LOG_LENGTH_ARB': '0x8B84',
  'OBJECT_ATTACHED_OBJECTS_ARB': '0x8B85',
  'OBJECT_ACTIVE_UNIFORMS_ARB': '0x8B86',
  'OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB': '0x8B87',
  'OBJECT_SHADER_SOURCE_LENGTH_ARB': '0x8B88',
  'SHADING_LANGUAGE_VERSION_ARB': '0x8B8C',
  'TEXTURE_COMPARE_MODE_ARB': '0x884C',
  'TEXTURE_COMPARE_FUNC_ARB': '0x884D',
  'COMPARE_R_TO_TEXTURE_ARB': '0x884E',
  'TEXTURE_COMPARE_FAIL_VALUE_ARB': '0x80BF',
  'CLAMP_TO_BORDER_ARB': '0x812D',
  'TEXTURE_BUFFER_ARB': '0x8C2A',
  'MAX_TEXTURE_BUFFER_SIZE_ARB': '0x8C2B',
  'TEXTURE_BINDING_BUFFER_ARB': '0x8C2C',
  'TEXTURE_BUFFER_DATA_STORE_BINDING_ARB': '0x8C2D',
  'TEXTURE_BUFFER_FORMAT_ARB': '0x8C2E',
  'COMPRESSED_ALPHA_ARB': '0x84E9',
  'COMPRESSED_LUMINANCE_ARB': '0x84EA',
  'COMPRESSED_LUMINANCE_ALPHA_ARB': '0x84EB',
  'COMPRESSED_INTENSITY_ARB': '0x84EC',
  'COMPRESSED_RGB_ARB': '0x84ED',
  'COMPRESSED_RGBA_ARB': '0x84EE',
  'TEXTURE_COMPRESSION_HINT_ARB': '0x84EF',
  'TEXTURE_COMPRESSED_IMAGE_SIZE_ARB': '0x86A0',
  'TEXTURE_COMPRESSED_ARB': '0x86A1',
  'NUM_COMPRESSED_TEXTURE_FORMATS_ARB': '0x86A2',
  'COMPRESSED_TEXTURE_FORMATS_ARB': '0x86A3',
  'COMPRESSED_RED_RGTC1': '0x8DBB',
  'COMPRESSED_SIGNED_RED_RGTC1': '0x8DBC',
  'COMPRESSED_RG_RGTC2': '0x8DBD',
  'COMPRESSED_SIGNED_RG_RGTC2': '0x8DBE',
  'NORMAL_MAP_ARB': '0x8511',
  'REFLECTION_MAP_ARB': '0x8512',
  'TEXTURE_CUBE_MAP_ARB': '0x8513',
  'TEXTURE_BINDING_CUBE_MAP_ARB': '0x8514',
  'TEXTURE_CUBE_MAP_POSITIVE_X_ARB': '0x8515',
  'TEXTURE_CUBE_MAP_NEGATIVE_X_ARB': '0x8516',
  'TEXTURE_CUBE_MAP_POSITIVE_Y_ARB': '0x8517',
  'TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB': '0x8518',
  'TEXTURE_CUBE_MAP_POSITIVE_Z_ARB': '0x8519',
  'TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB': '0x851A',
  'PROXY_TEXTURE_CUBE_MAP_ARB': '0x851B',
  'MAX_CUBE_MAP_TEXTURE_SIZE_ARB': '0x851C',
  'SUBTRACT_ARB': '0x84E7',
  'COMBINE_ARB': '0x8570',
  'COMBINE_RGB_ARB': '0x8571',
  'COMBINE_ALPHA_ARB': '0x8572',
  'RGB_SCALE_ARB': '0x8573',
  'ADD_SIGNED_ARB': '0x8574',
  'INTERPOLATE_ARB': '0x8575',
  'CONSTANT_ARB': '0x8576',
  'PRIMARY_COLOR_ARB': '0x8577',
  'PREVIOUS_ARB': '0x8578',
  'SOURCE0_RGB_ARB': '0x8580',
  'SOURCE1_RGB_ARB': '0x8581',
  'SOURCE2_RGB_ARB': '0x8582',
  'SOURCE0_ALPHA_ARB': '0x8588',
  'SOURCE1_ALPHA_ARB': '0x8589',
  'SOURCE2_ALPHA_ARB': '0x858A',
  'OPERAND0_RGB_ARB': '0x8590',
  'OPERAND1_RGB_ARB': '0x8591',
  'OPERAND2_RGB_ARB': '0x8592',
  'OPERAND0_ALPHA_ARB': '0x8598',
  'OPERAND1_ALPHA_ARB': '0x8599',
  'OPERAND2_ALPHA_ARB': '0x859A',
  'DOT3_RGB_ARB': '0x86AE',
  'DOT3_RGBA_ARB': '0x86AF',
  'RGBA32F_ARB': '0x8814',
  'RGB32F_ARB': '0x8815',
  'ALPHA32F_ARB': '0x8816',
  'INTENSITY32F_ARB': '0x8817',
  'LUMINANCE32F_ARB': '0x8818',
  'LUMINANCE_ALPHA32F_ARB': '0x8819',
  'RGBA16F_ARB': '0x881A',
  'RGB16F_ARB': '0x881B',
  'ALPHA16F_ARB': '0x881C',
  'INTENSITY16F_ARB': '0x881D',
  'LUMINANCE16F_ARB': '0x881E',
  'LUMINANCE_ALPHA16F_ARB': '0x881F',
  'TEXTURE_RED_TYPE_ARB': '0x8C10',
  'TEXTURE_GREEN_TYPE_ARB': '0x8C11',
  'TEXTURE_BLUE_TYPE_ARB': '0x8C12',
  'TEXTURE_ALPHA_TYPE_ARB': '0x8C13',
  'TEXTURE_LUMINANCE_TYPE_ARB': '0x8C14',
  'TEXTURE_INTENSITY_TYPE_ARB': '0x8C15',
  'TEXTURE_DEPTH_TYPE_ARB': '0x8C16',
  'UNSIGNED_NORMALIZED_ARB': '0x8C17',
  'MIRRORED_REPEAT_ARB': '0x8370',
  'TEXTURE_RECTANGLE_ARB': '0x84F5',
  'TEXTURE_BINDING_RECTANGLE_ARB': '0x84F6',
  'PROXY_TEXTURE_RECTANGLE_ARB': '0x84F7',
  'MAX_RECTANGLE_TEXTURE_SIZE_ARB': '0x84F8',
  'SAMPLER_2D_RECT_ARB': '0x8B63',
  'SAMPLER_2D_RECT_SHADOW_ARB': '0x8B64',
  'RED': '0x1903',
  'RG': '0x8227',
  'RG_INTEGER': '0x8228',
  'R8': '0x8229',
  'R16': '0x822A',
  'RG8': '0x822B',
  'RG16': '0x822C',
  'R16F': '0x822D',
  'R32F': '0x822E',
  'RG16F': '0x822F',
  'RG32F': '0x8230',
  'R8I': '0x8231',
  'R8UI': '0x8232',
  'R16I': '0x8233',
  'R16UI': '0x8234',
  'R32I': '0x8235',
  'R32UI': '0x8236',
  'RG8I': '0x8237',
  'RG8UI': '0x8238',
  'RG16I': '0x8239',
  'RG16UI': '0x823A',
  'RG32I': '0x823B',
  'RG32UI': '0x823C',
  'TRANSPOSE_MODELVIEW_MATRIX_ARB': '0x84E3',
  'TRANSPOSE_PROJECTION_MATRIX_ARB': '0x84E4',
  'TRANSPOSE_TEXTURE_MATRIX_ARB': '0x84E5',
  'TRANSPOSE_COLOR_MATRIX_ARB': '0x84E6',
  'VERTEX_ARRAY_BINDING': '0x85B5',
  'MODELVIEW0_ARB': '0x1700',
  'MODELVIEW1_ARB': '0x850A',
  'MAX_VERTEX_UNITS_ARB': '0x86A4',
  'ACTIVE_VERTEX_UNITS_ARB': '0x86A5',
  'WEIGHT_SUM_UNITY_ARB': '0x86A6',
  'VERTEX_BLEND_ARB': '0x86A7',
  'CURRENT_WEIGHT_ARB': '0x86A8',
  'WEIGHT_ARRAY_TYPE_ARB': '0x86A9',
  'WEIGHT_ARRAY_STRIDE_ARB': '0x86AA',
  'WEIGHT_ARRAY_SIZE_ARB': '0x86AB',
  'WEIGHT_ARRAY_POINTER_ARB': '0x86AC',
  'WEIGHT_ARRAY_ARB': '0x86AD',
  'MODELVIEW2_ARB': '0x8722',
  'MODELVIEW3_ARB': '0x8723',
  'MODELVIEW4_ARB': '0x8724',
  'MODELVIEW5_ARB': '0x8725',
  'MODELVIEW6_ARB': '0x8726',
  'MODELVIEW7_ARB': '0x8727',
  'MODELVIEW8_ARB': '0x8728',
  'MODELVIEW9_ARB': '0x8729',
  'MODELVIEW10_ARB': '0x872A',
  'MODELVIEW11_ARB': '0x872B',
  'MODELVIEW12_ARB': '0x872C',
  'MODELVIEW13_ARB': '0x872D',
  'MODELVIEW14_ARB': '0x872E',
  'MODELVIEW15_ARB': '0x872F',
  'MODELVIEW16_ARB': '0x8730',
  'MODELVIEW17_ARB': '0x8731',
  'MODELVIEW18_ARB': '0x8732',
  'MODELVIEW19_ARB': '0x8733',
  'MODELVIEW20_ARB': '0x8734',
  'MODELVIEW21_ARB': '0x8735',
  'MODELVIEW22_ARB': '0x8736',
  'MODELVIEW23_ARB': '0x8737',
  'MODELVIEW24_ARB': '0x8738',
  'MODELVIEW25_ARB': '0x8739',
  'MODELVIEW26_ARB': '0x873A',
  'MODELVIEW27_ARB': '0x873B',
  'MODELVIEW28_ARB': '0x873C',
  'MODELVIEW29_ARB': '0x873D',
  'MODELVIEW30_ARB': '0x873E',
  'MODELVIEW31_ARB': '0x873F',
  'BUFFER_SIZE_ARB': '0x8764',
  'BUFFER_USAGE_ARB': '0x8765',
  'ARRAY_BUFFER_ARB': '0x8892',
  'ELEMENT_ARRAY_BUFFER_ARB': '0x8893',
  'ARRAY_BUFFER_BINDING_ARB': '0x8894',
  'ELEMENT_ARRAY_BUFFER_BINDING_ARB': '0x8895',
  'VERTEX_ARRAY_BUFFER_BINDING_ARB': '0x8896',
  'NORMAL_ARRAY_BUFFER_BINDING_ARB': '0x8897',
  'COLOR_ARRAY_BUFFER_BINDING_ARB': '0x8898',
  'INDEX_ARRAY_BUFFER_BINDING_ARB': '0x8899',
  'TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB': '0x889A',
  'EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB': '0x889B',
  'SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB': '0x889C',
  'FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB': '0x889D',
  'WEIGHT_ARRAY_BUFFER_BINDING_ARB': '0x889E',
  'VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB': '0x889F',
  'READ_ONLY_ARB': '0x88B8',
  'WRITE_ONLY_ARB': '0x88B9',
  'READ_WRITE_ARB': '0x88BA',
  'BUFFER_ACCESS_ARB': '0x88BB',
  'BUFFER_MAPPED_ARB': '0x88BC',
  'BUFFER_MAP_POINTER_ARB': '0x88BD',
  'STREAM_DRAW_ARB': '0x88E0',
  'STREAM_READ_ARB': '0x88E1',
  'STREAM_COPY_ARB': '0x88E2',
  'STATIC_DRAW_ARB': '0x88E4',
  'STATIC_READ_ARB': '0x88E5',
  'STATIC_COPY_ARB': '0x88E6',
  'DYNAMIC_DRAW_ARB': '0x88E8',
  'DYNAMIC_READ_ARB': '0x88E9',
  'DYNAMIC_COPY_ARB': '0x88EA',
  'COLOR_SUM_ARB': '0x8458',
  'VERTEX_PROGRAM_ARB': '0x8620',
  'VERTEX_ATTRIB_ARRAY_ENABLED_ARB': '0x8622',
  'VERTEX_ATTRIB_ARRAY_SIZE_ARB': '0x8623',
  'VERTEX_ATTRIB_ARRAY_STRIDE_ARB': '0x8624',
  'VERTEX_ATTRIB_ARRAY_TYPE_ARB': '0x8625',
  'CURRENT_VERTEX_ATTRIB_ARB': '0x8626',
  'PROGRAM_LENGTH_ARB': '0x8627',
  'PROGRAM_STRING_ARB': '0x8628',
  'MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB': '0x862E',
  'MAX_PROGRAM_MATRICES_ARB': '0x862F',
  'CURRENT_MATRIX_STACK_DEPTH_ARB': '0x8640',
  'CURRENT_MATRIX_ARB': '0x8641',
  'VERTEX_PROGRAM_POINT_SIZE_ARB': '0x8642',
  'VERTEX_PROGRAM_TWO_SIDE_ARB': '0x8643',
  'VERTEX_ATTRIB_ARRAY_POINTER_ARB': '0x8645',
  'PROGRAM_ERROR_POSITION_ARB': '0x864B',
  'PROGRAM_BINDING_ARB': '0x8677',
  'MAX_VERTEX_ATTRIBS_ARB': '0x8869',
  'VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB': '0x886A',
  'PROGRAM_ERROR_STRING_ARB': '0x8874',
  'PROGRAM_FORMAT_ASCII_ARB': '0x8875',
  'PROGRAM_FORMAT_ARB': '0x8876',
  'PROGRAM_INSTRUCTIONS_ARB': '0x88A0',
  'MAX_PROGRAM_INSTRUCTIONS_ARB': '0x88A1',
  'PROGRAM_NATIVE_INSTRUCTIONS_ARB': '0x88A2',
  'MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB': '0x88A3',
  'PROGRAM_TEMPORARIES_ARB': '0x88A4',
  'MAX_PROGRAM_TEMPORARIES_ARB': '0x88A5',
  'PROGRAM_NATIVE_TEMPORARIES_ARB': '0x88A6',
  'MAX_PROGRAM_NATIVE_TEMPORARIES_ARB': '0x88A7',
  'PROGRAM_PARAMETERS_ARB': '0x88A8',
  'MAX_PROGRAM_PARAMETERS_ARB': '0x88A9',
  'PROGRAM_NATIVE_PARAMETERS_ARB': '0x88AA',
  'MAX_PROGRAM_NATIVE_PARAMETERS_ARB': '0x88AB',
  'PROGRAM_ATTRIBS_ARB': '0x88AC',
  'MAX_PROGRAM_ATTRIBS_ARB': '0x88AD',
  'PROGRAM_NATIVE_ATTRIBS_ARB': '0x88AE',
  'MAX_PROGRAM_NATIVE_ATTRIBS_ARB': '0x88AF',
  'PROGRAM_ADDRESS_REGISTERS_ARB': '0x88B0',
  'MAX_PROGRAM_ADDRESS_REGISTERS_ARB': '0x88B1',
  'PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB': '0x88B2',
  'MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB': '0x88B3',
  'MAX_PROGRAM_LOCAL_PARAMETERS_ARB': '0x88B4',
  'MAX_PROGRAM_ENV_PARAMETERS_ARB': '0x88B5',
  'PROGRAM_UNDER_NATIVE_LIMITS_ARB': '0x88B6',
  'TRANSPOSE_CURRENT_MATRIX_ARB': '0x88B7',
  'MATRIX0_ARB': '0x88C0',
  'MATRIX1_ARB': '0x88C1',
  'MATRIX2_ARB': '0x88C2',
  'MATRIX3_ARB': '0x88C3',
  'MATRIX4_ARB': '0x88C4',
  'MATRIX5_ARB': '0x88C5',
  'MATRIX6_ARB': '0x88C6',
  'MATRIX7_ARB': '0x88C7',
  'MATRIX8_ARB': '0x88C8',
  'MATRIX9_ARB': '0x88C9',
  'MATRIX10_ARB': '0x88CA',
  'MATRIX11_ARB': '0x88CB',
  'MATRIX12_ARB': '0x88CC',
  'MATRIX13_ARB': '0x88CD',
  'MATRIX14_ARB': '0x88CE',
  'MATRIX15_ARB': '0x88CF',
  'MATRIX16_ARB': '0x88D0',
  'MATRIX17_ARB': '0x88D1',
  'MATRIX18_ARB': '0x88D2',
  'MATRIX19_ARB': '0x88D3',
  'MATRIX20_ARB': '0x88D4',
  'MATRIX21_ARB': '0x88D5',
  'MATRIX22_ARB': '0x88D6',
  'MATRIX23_ARB': '0x88D7',
  'MATRIX24_ARB': '0x88D8',
  'MATRIX25_ARB': '0x88D9',
  'MATRIX26_ARB': '0x88DA',
  'MATRIX27_ARB': '0x88DB',
  'MATRIX28_ARB': '0x88DC',
  'MATRIX29_ARB': '0x88DD',
  'MATRIX30_ARB': '0x88DE',
  'MATRIX31_ARB': '0x88DF',
  'VERTEX_SHADER_ARB': '0x8B31',
  'MAX_VERTEX_UNIFORM_COMPONENTS_ARB': '0x8B4A',
  'MAX_VARYING_FLOATS_ARB': '0x8B4B',
  'MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB': '0x8B4C',
  'MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB': '0x8B4D',
  'OBJECT_ACTIVE_ATTRIBUTES_ARB': '0x8B89',
  'OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB': '0x8B8A',
  'TEXTURE_POINT_MODE_ATIX': '0x60B0',
  'TEXTURE_POINT_ONE_COORD_ATIX': '0x60B1',
  'TEXTURE_POINT_SPRITE_ATIX': '0x60B2',
  'POINT_SPRITE_CULL_MODE_ATIX': '0x60B3',
  'POINT_SPRITE_CULL_CENTER_ATIX': '0x60B4',
  'POINT_SPRITE_CULL_CLIP_ATIX': '0x60B5',
  'MODULATE_ADD_ATIX': '0x8744',
  'MODULATE_SIGNED_ADD_ATIX': '0x8745',
  'MODULATE_SUBTRACT_ATIX': '0x8746',
  'SECONDARY_COLOR_ATIX': '0x8747',
  'TEXTURE_OUTPUT_RGB_ATIX': '0x8748',
  'TEXTURE_OUTPUT_ALPHA_ATIX': '0x8749',
  'OUTPUT_POINT_SIZE_ATIX': '0x610E',
  'MAX_DRAW_BUFFERS_ATI': '0x8824',
  'DRAW_BUFFER0_ATI': '0x8825',
  'DRAW_BUFFER1_ATI': '0x8826',
  'DRAW_BUFFER2_ATI': '0x8827',
  'DRAW_BUFFER3_ATI': '0x8828',
  'DRAW_BUFFER4_ATI': '0x8829',
  'DRAW_BUFFER5_ATI': '0x882A',
  'DRAW_BUFFER6_ATI': '0x882B',
  'DRAW_BUFFER7_ATI': '0x882C',
  'DRAW_BUFFER8_ATI': '0x882D',
  'DRAW_BUFFER9_ATI': '0x882E',
  'DRAW_BUFFER10_ATI': '0x882F',
  'DRAW_BUFFER11_ATI': '0x8830',
  'DRAW_BUFFER12_ATI': '0x8831',
  'DRAW_BUFFER13_ATI': '0x8832',
  'DRAW_BUFFER14_ATI': '0x8833',
  'DRAW_BUFFER15_ATI': '0x8834',
  'ELEMENT_ARRAY_ATI': '0x8768',
  'ELEMENT_ARRAY_TYPE_ATI': '0x8769',
  'ELEMENT_ARRAY_POINTER_ATI': '0x876A',
  'BUMP_ROT_MATRIX_ATI': '0x8775',
  'BUMP_ROT_MATRIX_SIZE_ATI': '0x8776',
  'BUMP_NUM_TEX_UNITS_ATI': '0x8777',
  'BUMP_TEX_UNITS_ATI': '0x8778',
  'DUDV_ATI': '0x8779',
  'DU8DV8_ATI': '0x877A',
  'BUMP_ENVMAP_ATI': '0x877B',
  'BUMP_TARGET_ATI': '0x877C',
  'RED_BIT_ATI': '0x00000001',
  '2X_BIT_ATI': '0x00000001',
  '4X_BIT_ATI': '0x00000002',
  'GREEN_BIT_ATI': '0x00000002',
  'COMP_BIT_ATI': '0x00000002',
  'BLUE_BIT_ATI': '0x00000004',
  '8X_BIT_ATI': '0x00000004',
  'NEGATE_BIT_ATI': '0x00000004',
  'BIAS_BIT_ATI': '0x00000008',
  'HALF_BIT_ATI': '0x00000008',
  'QUARTER_BIT_ATI': '0x00000010',
  'EIGHTH_BIT_ATI': '0x00000020',
  'SATURATE_BIT_ATI': '0x00000040',
  'FRAGMENT_SHADER_ATI': '0x8920',
  'REG_0_ATI': '0x8921',
  'REG_1_ATI': '0x8922',
  'REG_2_ATI': '0x8923',
  'REG_3_ATI': '0x8924',
  'REG_4_ATI': '0x8925',
  'REG_5_ATI': '0x8926',
  'CON_0_ATI': '0x8941',
  'CON_1_ATI': '0x8942',
  'CON_2_ATI': '0x8943',
  'CON_3_ATI': '0x8944',
  'CON_4_ATI': '0x8945',
  'CON_5_ATI': '0x8946',
  'CON_6_ATI': '0x8947',
  'CON_7_ATI': '0x8948',
  'MOV_ATI': '0x8961',
  'ADD_ATI': '0x8963',
  'MUL_ATI': '0x8964',
  'SUB_ATI': '0x8965',
  'DOT3_ATI': '0x8966',
  'DOT4_ATI': '0x8967',
  'MAD_ATI': '0x8968',
  'LERP_ATI': '0x8969',
  'CND_ATI': '0x896A',
  'CND0_ATI': '0x896B',
  'DOT2_ADD_ATI': '0x896C',
  'SECONDARY_INTERPOLATOR_ATI': '0x896D',
  'NUM_FRAGMENT_REGISTERS_ATI': '0x896E',
  'NUM_FRAGMENT_CONSTANTS_ATI': '0x896F',
  'NUM_PASSES_ATI': '0x8970',
  'NUM_INSTRUCTIONS_PER_PASS_ATI': '0x8971',
  'NUM_INSTRUCTIONS_TOTAL_ATI': '0x8972',
  'NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI': '0x8973',
  'NUM_LOOPBACK_COMPONENTS_ATI': '0x8974',
  'COLOR_ALPHA_PAIRING_ATI': '0x8975',
  'SWIZZLE_STR_ATI': '0x8976',
  'SWIZZLE_STQ_ATI': '0x8977',
  'SWIZZLE_STR_DR_ATI': '0x8978',
  'SWIZZLE_STQ_DQ_ATI': '0x8979',
  'SWIZZLE_STRQ_ATI': '0x897A',
  'SWIZZLE_STRQ_DQ_ATI': '0x897B',
  'PN_TRIANGLES_ATI': '0x87F0',
  'MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI': '0x87F1',
  'PN_TRIANGLES_POINT_MODE_ATI': '0x87F2',
  'PN_TRIANGLES_NORMAL_MODE_ATI': '0x87F3',
  'PN_TRIANGLES_TESSELATION_LEVEL_ATI': '0x87F4',
  'PN_TRIANGLES_POINT_MODE_LINEAR_ATI': '0x87F5',
  'PN_TRIANGLES_POINT_MODE_CUBIC_ATI': '0x87F6',
  'PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI': '0x87F7',
  'PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI': '0x87F8',
  'STENCIL_BACK_FUNC_ATI': '0x8800',
  'STENCIL_BACK_FAIL_ATI': '0x8801',
  'STENCIL_BACK_PASS_DEPTH_FAIL_ATI': '0x8802',
  'STENCIL_BACK_PASS_DEPTH_PASS_ATI': '0x8803',
  'TEXT_FRAGMENT_SHADER_ATI': '0x8200',
  'COMPRESSED_LUMINANCE_ALPHA_3DC_ATI': '0x8837',
  'MODULATE_ADD_ATI': '0x8744',
  'MODULATE_SIGNED_ADD_ATI': '0x8745',
  'MODULATE_SUBTRACT_ATI': '0x8746',
  'RGBA_FLOAT32_ATI': '0x8814',
  'RGB_FLOAT32_ATI': '0x8815',
  'ALPHA_FLOAT32_ATI': '0x8816',
  'INTENSITY_FLOAT32_ATI': '0x8817',
  'LUMINANCE_FLOAT32_ATI': '0x8818',
  'LUMINANCE_ALPHA_FLOAT32_ATI': '0x8819',
  'RGBA_FLOAT16_ATI': '0x881A',
  'RGB_FLOAT16_ATI': '0x881B',
  'ALPHA_FLOAT16_ATI': '0x881C',
  'INTENSITY_FLOAT16_ATI': '0x881D',
  'LUMINANCE_FLOAT16_ATI': '0x881E',
  'LUMINANCE_ALPHA_FLOAT16_ATI': '0x881F',
  'MIRROR_CLAMP_ATI': '0x8742',
  'MIRROR_CLAMP_TO_EDGE_ATI': '0x8743',
  'STATIC_ATI': '0x8760',
  'DYNAMIC_ATI': '0x8761',
  'PRESERVE_ATI': '0x8762',
  'DISCARD_ATI': '0x8763',
  'OBJECT_BUFFER_SIZE_ATI': '0x8764',
  'OBJECT_BUFFER_USAGE_ATI': '0x8765',
  'ARRAY_OBJECT_BUFFER_ATI': '0x8766',
  'ARRAY_OBJECT_OFFSET_ATI': '0x8767',
  'MAX_VERTEX_STREAMS_ATI': '0x876B',
  'VERTEX_SOURCE_ATI': '0x876C',
  'VERTEX_STREAM0_ATI': '0x876D',
  'VERTEX_STREAM1_ATI': '0x876E',
  'VERTEX_STREAM2_ATI': '0x876F',
  'VERTEX_STREAM3_ATI': '0x8770',
  'VERTEX_STREAM4_ATI': '0x8771',
  'VERTEX_STREAM5_ATI': '0x8772',
  'VERTEX_STREAM6_ATI': '0x8773',
  'VERTEX_STREAM7_ATI': '0x8774',
  '422_EXT': '0x80CC',
  '422_REV_EXT': '0x80CD',
  '422_AVERAGE_EXT': '0x80CE',
  '422_REV_AVERAGE_EXT': '0x80CF',
  'CG_VERTEX_SHADER_EXT': '0x890E',
  'CG_FRAGMENT_SHADER_EXT': '0x890F',
  'ABGR_EXT': '0x8000',
  'BGR_EXT': '0x80E0',
  'BGRA_EXT': '0x80E1',
  'MAX_VERTEX_BINDABLE_UNIFORMS_EXT': '0x8DE2',
  'MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT': '0x8DE3',
  'MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT': '0x8DE4',
  'MAX_BINDABLE_UNIFORM_SIZE_EXT': '0x8DED',
  'UNIFORM_BUFFER_EXT': '0x8DEE',
  'UNIFORM_BUFFER_BINDING_EXT': '0x8DEF',
  'CONSTANT_COLOR_EXT': '0x8001',
  'ONE_MINUS_CONSTANT_COLOR_EXT': '0x8002',
  'CONSTANT_ALPHA_EXT': '0x8003',
  'ONE_MINUS_CONSTANT_ALPHA_EXT': '0x8004',
  'BLEND_COLOR_EXT': '0x8005',
  'BLEND_EQUATION_RGB_EXT': '0x8009',
  'BLEND_EQUATION_ALPHA_EXT': '0x883D',
  'BLEND_DST_RGB_EXT': '0x80C8',
  'BLEND_SRC_RGB_EXT': '0x80C9',
  'BLEND_DST_ALPHA_EXT': '0x80CA',
  'BLEND_SRC_ALPHA_EXT': '0x80CB',
  'FUNC_ADD_EXT': '0x8006',
  'MIN_EXT': '0x8007',
  'MAX_EXT': '0x8008',
  'BLEND_EQUATION_EXT': '0x8009',
  'FUNC_SUBTRACT_EXT': '0x800A',
  'FUNC_REVERSE_SUBTRACT_EXT': '0x800B',
  'CLIP_VOLUME_CLIPPING_HINT_EXT': '0x80F0',
  'CMYK_EXT': '0x800C',
  'CMYKA_EXT': '0x800D',
  'PACK_CMYK_HINT_EXT': '0x800E',
  'UNPACK_CMYK_HINT_EXT': '0x800F',
  'ARRAY_ELEMENT_LOCK_FIRST_EXT': '0x81A8',
  'ARRAY_ELEMENT_LOCK_COUNT_EXT': '0x81A9',
  'CONVOLUTION_1D_EXT': '0x8010',
  'CONVOLUTION_2D_EXT': '0x8011',
  'SEPARABLE_2D_EXT': '0x8012',
  'CONVOLUTION_BORDER_MODE_EXT': '0x8013',
  'CONVOLUTION_FILTER_SCALE_EXT': '0x8014',
  'CONVOLUTION_FILTER_BIAS_EXT': '0x8015',
  'REDUCE_EXT': '0x8016',
  'CONVOLUTION_FORMAT_EXT': '0x8017',
  'CONVOLUTION_WIDTH_EXT': '0x8018',
  'CONVOLUTION_HEIGHT_EXT': '0x8019',
  'MAX_CONVOLUTION_WIDTH_EXT': '0x801A',
  'MAX_CONVOLUTION_HEIGHT_EXT': '0x801B',
  'POST_CONVOLUTION_RED_SCALE_EXT': '0x801C',
  'POST_CONVOLUTION_GREEN_SCALE_EXT': '0x801D',
  'POST_CONVOLUTION_BLUE_SCALE_EXT': '0x801E',
  'POST_CONVOLUTION_ALPHA_SCALE_EXT': '0x801F',
  'POST_CONVOLUTION_RED_BIAS_EXT': '0x8020',
  'POST_CONVOLUTION_GREEN_BIAS_EXT': '0x8021',
  'POST_CONVOLUTION_BLUE_BIAS_EXT': '0x8022',
  'POST_CONVOLUTION_ALPHA_BIAS_EXT': '0x8023',
  'TANGENT_ARRAY_EXT': '0x8439',
  'BINORMAL_ARRAY_EXT': '0x843A',
  'CURRENT_TANGENT_EXT': '0x843B',
  'CURRENT_BINORMAL_EXT': '0x843C',
  'TANGENT_ARRAY_TYPE_EXT': '0x843E',
  'TANGENT_ARRAY_STRIDE_EXT': '0x843F',
  'BINORMAL_ARRAY_TYPE_EXT': '0x8440',
  'BINORMAL_ARRAY_STRIDE_EXT': '0x8441',
  'TANGENT_ARRAY_POINTER_EXT': '0x8442',
  'BINORMAL_ARRAY_POINTER_EXT': '0x8443',
  'MAP1_TANGENT_EXT': '0x8444',
  'MAP2_TANGENT_EXT': '0x8445',
  'MAP1_BINORMAL_EXT': '0x8446',
  'MAP2_BINORMAL_EXT': '0x8447',
  'DEPTH_BOUNDS_TEST_EXT': '0x8890',
  'DEPTH_BOUNDS_EXT': '0x8891',
  'PROGRAM_MATRIX_EXT': '0x8E2D',
  'TRANSPOSE_PROGRAM_MATRIX_EXT': '0x8E2E',
  'PROGRAM_MATRIX_STACK_DEPTH_EXT': '0x8E2F',
  'MAX_ELEMENTS_VERTICES': '0x80E8',
  'MAX_ELEMENTS_INDICES': '0x80E9',
  'FOG_COORDINATE_SOURCE_EXT': '0x8450',
  'FOG_COORDINATE_EXT': '0x8451',
  'FRAGMENT_DEPTH_EXT': '0x8452',
  'CURRENT_FOG_COORDINATE_EXT': '0x8453',
  'FOG_COORDINATE_ARRAY_TYPE_EXT': '0x8454',
  'FOG_COORDINATE_ARRAY_STRIDE_EXT': '0x8455',
  'FOG_COORDINATE_ARRAY_POINTER_EXT': '0x8456',
  'FOG_COORDINATE_ARRAY_EXT': '0x8457',
  'FRAGMENT_LIGHTING_EXT': '0x8400',
  'FRAGMENT_COLOR_MATERIAL_EXT': '0x8401',
  'FRAGMENT_COLOR_MATERIAL_FACE_EXT': '0x8402',
  'FRAGMENT_COLOR_MATERIAL_PARAMETER_EXT': '0x8403',
  'MAX_FRAGMENT_LIGHTS_EXT': '0x8404',
  'MAX_ACTIVE_LIGHTS_EXT': '0x8405',
  'CURRENT_RASTER_NORMAL_EXT': '0x8406',
  'LIGHT_ENV_MODE_EXT': '0x8407',
  'FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_EXT': '0x8408',
  'FRAGMENT_LIGHT_MODEL_TWO_SIDE_EXT': '0x8409',
  'FRAGMENT_LIGHT_MODEL_AMBIENT_EXT': '0x840A',
  'FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_EXT': '0x840B',
  'FRAGMENT_LIGHT0_EXT': '0x840C',
  'FRAGMENT_LIGHT7_EXT': '0x8413',
  'DRAW_FRAMEBUFFER_BINDING_EXT': '0x8CA6',
  'READ_FRAMEBUFFER_EXT': '0x8CA8',
  'DRAW_FRAMEBUFFER_EXT': '0x8CA9',
  'READ_FRAMEBUFFER_BINDING_EXT': '0x8CAA',
  'RENDERBUFFER_SAMPLES_EXT': '0x8CAB',
  'FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT': '0x8D56',
  'MAX_SAMPLES_EXT': '0x8D57',
  'INVALID_FRAMEBUFFER_OPERATION_EXT': '0x0506',
  'MAX_RENDERBUFFER_SIZE_EXT': '0x84E8',
  'FRAMEBUFFER_BINDING_EXT': '0x8CA6',
  'RENDERBUFFER_BINDING_EXT': '0x8CA7',
  'FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT': '0x8CD0',
  'FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT': '0x8CD1',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT': '0x8CD2',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT': '0x8CD3',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT': '0x8CD4',
  'FRAMEBUFFER_COMPLETE_EXT': '0x8CD5',
  'FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT': '0x8CD6',
  'FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT': '0x8CD7',
  'FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT': '0x8CD9',
  'FRAMEBUFFER_INCOMPLETE_FORMATS_EXT': '0x8CDA',
  'FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT': '0x8CDB',
  'FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT': '0x8CDC',
  'FRAMEBUFFER_UNSUPPORTED_EXT': '0x8CDD',
  'MAX_COLOR_ATTACHMENTS_EXT': '0x8CDF',
  'COLOR_ATTACHMENT0_EXT': '0x8CE0',
  'COLOR_ATTACHMENT1_EXT': '0x8CE1',
  'COLOR_ATTACHMENT2_EXT': '0x8CE2',
  'COLOR_ATTACHMENT3_EXT': '0x8CE3',
  'COLOR_ATTACHMENT4_EXT': '0x8CE4',
  'COLOR_ATTACHMENT5_EXT': '0x8CE5',
  'COLOR_ATTACHMENT6_EXT': '0x8CE6',
  'COLOR_ATTACHMENT7_EXT': '0x8CE7',
  'COLOR_ATTACHMENT8_EXT': '0x8CE8',
  'COLOR_ATTACHMENT9_EXT': '0x8CE9',
  'COLOR_ATTACHMENT10_EXT': '0x8CEA',
  'COLOR_ATTACHMENT11_EXT': '0x8CEB',
  'COLOR_ATTACHMENT12_EXT': '0x8CEC',
  'COLOR_ATTACHMENT13_EXT': '0x8CED',
  'COLOR_ATTACHMENT14_EXT': '0x8CEE',
  'COLOR_ATTACHMENT15_EXT': '0x8CEF',
  'DEPTH_ATTACHMENT_EXT': '0x8D00',
  'STENCIL_ATTACHMENT_EXT': '0x8D20',
  'FRAMEBUFFER_EXT': '0x8D40',
  'RENDERBUFFER_EXT': '0x8D41',
  'RENDERBUFFER_WIDTH_EXT': '0x8D42',
  'RENDERBUFFER_HEIGHT_EXT': '0x8D43',
  'RENDERBUFFER_INTERNAL_FORMAT_EXT': '0x8D44',
  'STENCIL_INDEX1_EXT': '0x8D46',
  'STENCIL_INDEX4_EXT': '0x8D47',
  'STENCIL_INDEX8_EXT': '0x8D48',
  'STENCIL_INDEX16_EXT': '0x8D49',
  'RENDERBUFFER_RED_SIZE_EXT': '0x8D50',
  'RENDERBUFFER_GREEN_SIZE_EXT': '0x8D51',
  'RENDERBUFFER_BLUE_SIZE_EXT': '0x8D52',
  'RENDERBUFFER_ALPHA_SIZE_EXT': '0x8D53',
  'RENDERBUFFER_DEPTH_SIZE_EXT': '0x8D54',
  'RENDERBUFFER_STENCIL_SIZE_EXT': '0x8D55',
  'FRAMEBUFFER_SRGB_EXT': '0x8DB9',
  'FRAMEBUFFER_SRGB_CAPABLE_EXT': '0x8DBA',
  'LINES_ADJACENCY_EXT': '0xA',
  'LINE_STRIP_ADJACENCY_EXT': '0xB',
  'TRIANGLES_ADJACENCY_EXT': '0xC',
  'TRIANGLE_STRIP_ADJACENCY_EXT': '0xD',
  'PROGRAM_POINT_SIZE_EXT': '0x8642',
  'MAX_VARYING_COMPONENTS_EXT': '0x8B4B',
  'MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT': '0x8C29',
  'FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT': '0x8CD4',
  'FRAMEBUFFER_ATTACHMENT_LAYERED_EXT': '0x8DA7',
  'FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT': '0x8DA8',
  'FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT': '0x8DA9',
  'GEOMETRY_SHADER_EXT': '0x8DD9',
  'GEOMETRY_VERTICES_OUT_EXT': '0x8DDA',
  'GEOMETRY_INPUT_TYPE_EXT': '0x8DDB',
  'GEOMETRY_OUTPUT_TYPE_EXT': '0x8DDC',
  'MAX_GEOMETRY_VARYING_COMPONENTS_EXT': '0x8DDD',
  'MAX_VERTEX_VARYING_COMPONENTS_EXT': '0x8DDE',
  'MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT': '0x8DDF',
  'MAX_GEOMETRY_OUTPUT_VERTICES_EXT': '0x8DE0',
  'MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT': '0x8DE1',
  'VERTEX_ATTRIB_ARRAY_INTEGER_EXT': '0x88FD',
  'SAMPLER_1D_ARRAY_EXT': '0x8DC0',
  'SAMPLER_2D_ARRAY_EXT': '0x8DC1',
  'SAMPLER_BUFFER_EXT': '0x8DC2',
  'SAMPLER_1D_ARRAY_SHADOW_EXT': '0x8DC3',
  'SAMPLER_2D_ARRAY_SHADOW_EXT': '0x8DC4',
  'SAMPLER_CUBE_SHADOW_EXT': '0x8DC5',
  'UNSIGNED_INT_VEC2_EXT': '0x8DC6',
  'UNSIGNED_INT_VEC3_EXT': '0x8DC7',
  'UNSIGNED_INT_VEC4_EXT': '0x8DC8',
  'INT_SAMPLER_1D_EXT': '0x8DC9',
  'INT_SAMPLER_2D_EXT': '0x8DCA',
  'INT_SAMPLER_3D_EXT': '0x8DCB',
  'INT_SAMPLER_CUBE_EXT': '0x8DCC',
  'INT_SAMPLER_2D_RECT_EXT': '0x8DCD',
  'INT_SAMPLER_1D_ARRAY_EXT': '0x8DCE',
  'INT_SAMPLER_2D_ARRAY_EXT': '0x8DCF',
  'INT_SAMPLER_BUFFER_EXT': '0x8DD0',
  'UNSIGNED_INT_SAMPLER_1D_EXT': '0x8DD1',
  'UNSIGNED_INT_SAMPLER_2D_EXT': '0x8DD2',
  'UNSIGNED_INT_SAMPLER_3D_EXT': '0x8DD3',
  'UNSIGNED_INT_SAMPLER_CUBE_EXT': '0x8DD4',
  'UNSIGNED_INT_SAMPLER_2D_RECT_EXT': '0x8DD5',
  'UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT': '0x8DD6',
  'UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT': '0x8DD7',
  'UNSIGNED_INT_SAMPLER_BUFFER_EXT': '0x8DD8',
  'HISTOGRAM_EXT': '0x8024',
  'PROXY_HISTOGRAM_EXT': '0x8025',
  'HISTOGRAM_WIDTH_EXT': '0x8026',
  'HISTOGRAM_FORMAT_EXT': '0x8027',
  'HISTOGRAM_RED_SIZE_EXT': '0x8028',
  'HISTOGRAM_GREEN_SIZE_EXT': '0x8029',
  'HISTOGRAM_BLUE_SIZE_EXT': '0x802A',
  'HISTOGRAM_ALPHA_SIZE_EXT': '0x802B',
  'HISTOGRAM_LUMINANCE_SIZE_EXT': '0x802C',
  'HISTOGRAM_SINK_EXT': '0x802D',
  'MINMAX_EXT': '0x802E',
  'MINMAX_FORMAT_EXT': '0x802F',
  'MINMAX_SINK_EXT': '0x8030',
  'FRAGMENT_MATERIAL_EXT': '0x8349',
  'FRAGMENT_NORMAL_EXT': '0x834A',
  'FRAGMENT_COLOR_EXT': '0x834C',
  'ATTENUATION_EXT': '0x834D',
  'SHADOW_ATTENUATION_EXT': '0x834E',
  'TEXTURE_APPLICATION_MODE_EXT': '0x834F',
  'TEXTURE_LIGHT_EXT': '0x8350',
  'TEXTURE_MATERIAL_FACE_EXT': '0x8351',
  'TEXTURE_MATERIAL_PARAMETER_EXT': '0x8352',
  'FRAGMENT_DEPTH_EXT': '0x8452',
  'MULTISAMPLE_EXT': '0x809D',
  'SAMPLE_ALPHA_TO_MASK_EXT': '0x809E',
  'SAMPLE_ALPHA_TO_ONE_EXT': '0x809F',
  'SAMPLE_MASK_EXT': '0x80A0',
  '1PASS_EXT': '0x80A1',
  '2PASS_0_EXT': '0x80A2',
  '2PASS_1_EXT': '0x80A3',
  '4PASS_0_EXT': '0x80A4',
  '4PASS_1_EXT': '0x80A5',
  '4PASS_2_EXT': '0x80A6',
  '4PASS_3_EXT': '0x80A7',
  'SAMPLE_BUFFERS_EXT': '0x80A8',
  'SAMPLES_EXT': '0x80A9',
  'SAMPLE_MASK_VALUE_EXT': '0x80AA',
  'SAMPLE_MASK_INVERT_EXT': '0x80AB',
  'SAMPLE_PATTERN_EXT': '0x80AC',
  'MULTISAMPLE_BIT_EXT': '0x20000000',
  'DEPTH_STENCIL_EXT': '0x84F9',
  'UNSIGNED_INT_24_8_EXT': '0x84FA',
  'DEPTH24_STENCIL8_EXT': '0x88F0',
  'TEXTURE_STENCIL_SIZE_EXT': '0x88F1',
  'R11F_G11F_B10F_EXT': '0x8C3A',
  'UNSIGNED_INT_10F_11F_11F_REV_EXT': '0x8C3B',
  'RGBA_SIGNED_COMPONENTS_EXT': '0x8C3C',
  'UNSIGNED_BYTE_3_3_2_EXT': '0x8032',
  'UNSIGNED_SHORT_4_4_4_4_EXT': '0x8033',
  'UNSIGNED_SHORT_5_5_5_1_EXT': '0x8034',
  'UNSIGNED_INT_8_8_8_8_EXT': '0x8035',
  'UNSIGNED_INT_10_10_10_2_EXT': '0x8036',
  'TEXTURE_1D': '0x0DE0',
  'TEXTURE_2D': '0x0DE1',
  'PROXY_TEXTURE_1D': '0x8063',
  'PROXY_TEXTURE_2D': '0x8064',
  'TEXTURE_3D_EXT': '0x806F',
  'PROXY_TEXTURE_3D_EXT': '0x8070',
  'COLOR_TABLE_FORMAT_EXT': '0x80D8',
  'COLOR_TABLE_WIDTH_EXT': '0x80D9',
  'COLOR_TABLE_RED_SIZE_EXT': '0x80DA',
  'COLOR_TABLE_GREEN_SIZE_EXT': '0x80DB',
  'COLOR_TABLE_BLUE_SIZE_EXT': '0x80DC',
  'COLOR_TABLE_ALPHA_SIZE_EXT': '0x80DD',
  'COLOR_TABLE_LUMINANCE_SIZE_EXT': '0x80DE',
  'COLOR_TABLE_INTENSITY_SIZE_EXT': '0x80DF',
  'COLOR_INDEX1_EXT': '0x80E2',
  'COLOR_INDEX2_EXT': '0x80E3',
  'COLOR_INDEX4_EXT': '0x80E4',
  'COLOR_INDEX8_EXT': '0x80E5',
  'COLOR_INDEX12_EXT': '0x80E6',
  'COLOR_INDEX16_EXT': '0x80E7',
  'TEXTURE_INDEX_SIZE_EXT': '0x80ED',
  'TEXTURE_CUBE_MAP_ARB': '0x8513',
  'PROXY_TEXTURE_CUBE_MAP_ARB': '0x851B',
  'PIXEL_PACK_BUFFER_EXT': '0x88EB',
  'PIXEL_UNPACK_BUFFER_EXT': '0x88EC',
  'PIXEL_PACK_BUFFER_BINDING_EXT': '0x88ED',
  'PIXEL_UNPACK_BUFFER_BINDING_EXT': '0x88EF',
  'PIXEL_TRANSFORM_2D_EXT': '0x8330',
  'PIXEL_MAG_FILTER_EXT': '0x8331',
  'PIXEL_MIN_FILTER_EXT': '0x8332',
  'PIXEL_CUBIC_WEIGHT_EXT': '0x8333',
  'CUBIC_EXT': '0x8334',
  'AVERAGE_EXT': '0x8335',
  'PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT': '0x8336',
  'MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT': '0x8337',
  'PIXEL_TRANSFORM_2D_MATRIX_EXT': '0x8338',
  'POINT_SIZE_MIN_EXT': '0x8126',
  'POINT_SIZE_MAX_EXT': '0x8127',
  'POINT_FADE_THRESHOLD_SIZE_EXT': '0x8128',
  'DISTANCE_ATTENUATION_EXT': '0x8129',
  'POLYGON_OFFSET_EXT': '0x8037',
  'POLYGON_OFFSET_FACTOR_EXT': '0x8038',
  'POLYGON_OFFSET_BIAS_EXT': '0x8039',
  'RESCALE_NORMAL_EXT': '0x803A',
  'COLOR_SUM_EXT': '0x8458',
  'CURRENT_SECONDARY_COLOR_EXT': '0x8459',
  'SECONDARY_COLOR_ARRAY_SIZE_EXT': '0x845A',
  'SECONDARY_COLOR_ARRAY_TYPE_EXT': '0x845B',
  'SECONDARY_COLOR_ARRAY_STRIDE_EXT': '0x845C',
  'SECONDARY_COLOR_ARRAY_POINTER_EXT': '0x845D',
  'SECONDARY_COLOR_ARRAY_EXT': '0x845E',
  'LIGHT_MODEL_COLOR_CONTROL_EXT': '0x81F8',
  'SINGLE_COLOR_EXT': '0x81F9',
  'SEPARATE_SPECULAR_COLOR_EXT': '0x81FA',
  'SHARED_TEXTURE_PALETTE_EXT': '0x81FB',
  'STENCIL_TAG_BITS_EXT': '0x88F2',
  'STENCIL_CLEAR_TAG_VALUE_EXT': '0x88F3',
  'STENCIL_TEST_TWO_SIDE_EXT': '0x8910',
  'ACTIVE_STENCIL_FACE_EXT': '0x8911',
  'INCR_WRAP_EXT': '0x8507',
  'DECR_WRAP_EXT': '0x8508',
  'ALPHA4_EXT': '0x803B',
  'ALPHA8_EXT': '0x803C',
  'ALPHA12_EXT': '0x803D',
  'ALPHA16_EXT': '0x803E',
  'LUMINANCE4_EXT': '0x803F',
  'LUMINANCE8_EXT': '0x8040',
  'LUMINANCE12_EXT': '0x8041',
  'LUMINANCE16_EXT': '0x8042',
  'LUMINANCE4_ALPHA4_EXT': '0x8043',
  'LUMINANCE6_ALPHA2_EXT': '0x8044',
  'LUMINANCE8_ALPHA8_EXT': '0x8045',
  'LUMINANCE12_ALPHA4_EXT': '0x8046',
  'LUMINANCE12_ALPHA12_EXT': '0x8047',
  'LUMINANCE16_ALPHA16_EXT': '0x8048',
  'INTENSITY_EXT': '0x8049',
  'INTENSITY4_EXT': '0x804A',
  'INTENSITY8_EXT': '0x804B',
  'INTENSITY12_EXT': '0x804C',
  'INTENSITY16_EXT': '0x804D',
  'RGB2_EXT': '0x804E',
  'RGB4_EXT': '0x804F',
  'RGB5_EXT': '0x8050',
  'RGB8_EXT': '0x8051',
  'RGB10_EXT': '0x8052',
  'RGB12_EXT': '0x8053',
  'RGB16_EXT': '0x8054',
  'RGBA2_EXT': '0x8055',
  'RGBA4_EXT': '0x8056',
  'RGB5_A1_EXT': '0x8057',
  'RGBA8_EXT': '0x8058',
  'RGB10_A2_EXT': '0x8059',
  'RGBA12_EXT': '0x805A',
  'RGBA16_EXT': '0x805B',
  'TEXTURE_RED_SIZE_EXT': '0x805C',
  'TEXTURE_GREEN_SIZE_EXT': '0x805D',
  'TEXTURE_BLUE_SIZE_EXT': '0x805E',
  'TEXTURE_ALPHA_SIZE_EXT': '0x805F',
  'TEXTURE_LUMINANCE_SIZE_EXT': '0x8060',
  'TEXTURE_INTENSITY_SIZE_EXT': '0x8061',
  'REPLACE_EXT': '0x8062',
  'PROXY_TEXTURE_1D_EXT': '0x8063',
  'PROXY_TEXTURE_2D_EXT': '0x8064',
  'PACK_SKIP_IMAGES_EXT': '0x806B',
  'PACK_IMAGE_HEIGHT_EXT': '0x806C',
  'UNPACK_SKIP_IMAGES_EXT': '0x806D',
  'UNPACK_IMAGE_HEIGHT_EXT': '0x806E',
  'TEXTURE_3D_EXT': '0x806F',
  'PROXY_TEXTURE_3D_EXT': '0x8070',
  'TEXTURE_DEPTH_EXT': '0x8071',
  'TEXTURE_WRAP_R_EXT': '0x8072',
  'MAX_3D_TEXTURE_SIZE_EXT': '0x8073',
  'COMPARE_REF_DEPTH_TO_TEXTURE_EXT': '0x884E',
  'MAX_ARRAY_TEXTURE_LAYERS_EXT': '0x88FF',
  'TEXTURE_1D_ARRAY_EXT': '0x8C18',
  'PROXY_TEXTURE_1D_ARRAY_EXT': '0x8C19',
  'TEXTURE_2D_ARRAY_EXT': '0x8C1A',
  'PROXY_TEXTURE_2D_ARRAY_EXT': '0x8C1B',
  'TEXTURE_BINDING_1D_ARRAY_EXT': '0x8C1C',
  'TEXTURE_BINDING_2D_ARRAY_EXT': '0x8C1D',
  'TEXTURE_BUFFER_EXT': '0x8C2A',
  'MAX_TEXTURE_BUFFER_SIZE_EXT': '0x8C2B',
  'TEXTURE_BINDING_BUFFER_EXT': '0x8C2C',
  'TEXTURE_BUFFER_DATA_STORE_BINDING_EXT': '0x8C2D',
  'TEXTURE_BUFFER_FORMAT_EXT': '0x8C2E',
  'COMPRESSED_RGB_S3TC_DXT1_EXT': '0x83F0',
  'COMPRESSED_RGBA_S3TC_DXT1_EXT': '0x83F1',
  'COMPRESSED_LUMINANCE_LATC1_EXT': '0x8C70',
  'COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT': '0x8C71',
  'COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT': '0x8C72',
  'COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT': '0x8C73',
  'COMPRESSED_RED_RGTC1_EXT': '0x8DBB',
  'COMPRESSED_SIGNED_RED_RGTC1_EXT': '0x8DBC',
  'COMPRESSED_RED_GREEN_RGTC2_EXT': '0x8DBD',
  'COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT': '0x8DBE',
  'COMPRESSED_RGB_S3TC_DXT1_EXT': '0x83F0',
  'COMPRESSED_RGBA_S3TC_DXT1_EXT': '0x83F1',
  'COMPRESSED_RGBA_S3TC_DXT3_EXT': '0x83F2',
  'COMPRESSED_RGBA_S3TC_DXT5_EXT': '0x83F3',
  'NORMAL_MAP_EXT': '0x8511',
  'REFLECTION_MAP_EXT': '0x8512',
  'TEXTURE_CUBE_MAP_EXT': '0x8513',
  'TEXTURE_BINDING_CUBE_MAP_EXT': '0x8514',
  'TEXTURE_CUBE_MAP_POSITIVE_X_EXT': '0x8515',
  'TEXTURE_CUBE_MAP_NEGATIVE_X_EXT': '0x8516',
  'TEXTURE_CUBE_MAP_POSITIVE_Y_EXT': '0x8517',
  'TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT': '0x8518',
  'TEXTURE_CUBE_MAP_POSITIVE_Z_EXT': '0x8519',
  'TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT': '0x851A',
  'PROXY_TEXTURE_CUBE_MAP_EXT': '0x851B',
  'MAX_CUBE_MAP_TEXTURE_SIZE_EXT': '0x851C',
  'CLAMP_TO_EDGE_EXT': '0x812F',
  'COMBINE_EXT': '0x8570',
  'COMBINE_RGB_EXT': '0x8571',
  'COMBINE_ALPHA_EXT': '0x8572',
  'RGB_SCALE_EXT': '0x8573',
  'ADD_SIGNED_EXT': '0x8574',
  'INTERPOLATE_EXT': '0x8575',
  'CONSTANT_EXT': '0x8576',
  'PRIMARY_COLOR_EXT': '0x8577',
  'PREVIOUS_EXT': '0x8578',
  'SOURCE0_RGB_EXT': '0x8580',
  'SOURCE1_RGB_EXT': '0x8581',
  'SOURCE2_RGB_EXT': '0x8582',
  'SOURCE0_ALPHA_EXT': '0x8588',
  'SOURCE1_ALPHA_EXT': '0x8589',
  'SOURCE2_ALPHA_EXT': '0x858A',
  'OPERAND0_RGB_EXT': '0x8590',
  'OPERAND1_RGB_EXT': '0x8591',
  'OPERAND2_RGB_EXT': '0x8592',
  'OPERAND0_ALPHA_EXT': '0x8598',
  'OPERAND1_ALPHA_EXT': '0x8599',
  'OPERAND2_ALPHA_EXT': '0x859A',
  'DOT3_RGB_EXT': '0x8740',
  'DOT3_RGBA_EXT': '0x8741',
  'TEXTURE_MAX_ANISOTROPY_EXT': '0x84FE',
  'MAX_TEXTURE_MAX_ANISOTROPY_EXT': '0x84FF',
  'RGBA32UI_EXT': '0x8D70',
  'RGB32UI_EXT': '0x8D71',
  'ALPHA32UI_EXT': '0x8D72',
  'INTENSITY32UI_EXT': '0x8D73',
  'LUMINANCE32UI_EXT': '0x8D74',
  'LUMINANCE_ALPHA32UI_EXT': '0x8D75',
  'RGBA16UI_EXT': '0x8D76',
  'RGB16UI_EXT': '0x8D77',
  'ALPHA16UI_EXT': '0x8D78',
  'INTENSITY16UI_EXT': '0x8D79',
  'LUMINANCE16UI_EXT': '0x8D7A',
  'LUMINANCE_ALPHA16UI_EXT': '0x8D7B',
  'RGBA8UI_EXT': '0x8D7C',
  'RGB8UI_EXT': '0x8D7D',
  'ALPHA8UI_EXT': '0x8D7E',
  'INTENSITY8UI_EXT': '0x8D7F',
  'LUMINANCE8UI_EXT': '0x8D80',
  'LUMINANCE_ALPHA8UI_EXT': '0x8D81',
  'RGBA32I_EXT': '0x8D82',
  'RGB32I_EXT': '0x8D83',
  'ALPHA32I_EXT': '0x8D84',
  'INTENSITY32I_EXT': '0x8D85',
  'LUMINANCE32I_EXT': '0x8D86',
  'LUMINANCE_ALPHA32I_EXT': '0x8D87',
  'RGBA16I_EXT': '0x8D88',
  'RGB16I_EXT': '0x8D89',
  'ALPHA16I_EXT': '0x8D8A',
  'INTENSITY16I_EXT': '0x8D8B',
  'LUMINANCE16I_EXT': '0x8D8C',
  'LUMINANCE_ALPHA16I_EXT': '0x8D8D',
  'RGBA8I_EXT': '0x8D8E',
  'RGB8I_EXT': '0x8D8F',
  'ALPHA8I_EXT': '0x8D90',
  'INTENSITY8I_EXT': '0x8D91',
  'LUMINANCE8I_EXT': '0x8D92',
  'LUMINANCE_ALPHA8I_EXT': '0x8D93',
  'RED_INTEGER_EXT': '0x8D94',
  'GREEN_INTEGER_EXT': '0x8D95',
  'BLUE_INTEGER_EXT': '0x8D96',
  'ALPHA_INTEGER_EXT': '0x8D97',
  'RGB_INTEGER_EXT': '0x8D98',
  'RGBA_INTEGER_EXT': '0x8D99',
  'BGR_INTEGER_EXT': '0x8D9A',
  'BGRA_INTEGER_EXT': '0x8D9B',
  'LUMINANCE_INTEGER_EXT': '0x8D9C',
  'LUMINANCE_ALPHA_INTEGER_EXT': '0x8D9D',
  'RGBA_INTEGER_MODE_EXT': '0x8D9E',
  'MAX_TEXTURE_LOD_BIAS_EXT': '0x84FD',
  'TEXTURE_FILTER_CONTROL_EXT': '0x8500',
  'TEXTURE_LOD_BIAS_EXT': '0x8501',
  'MIRROR_CLAMP_EXT': '0x8742',
  'MIRROR_CLAMP_TO_EDGE_EXT': '0x8743',
  'MIRROR_CLAMP_TO_BORDER_EXT': '0x8912',
  'TEXTURE_PRIORITY_EXT': '0x8066',
  'TEXTURE_RESIDENT_EXT': '0x8067',
  'TEXTURE_1D_BINDING_EXT': '0x8068',
  'TEXTURE_2D_BINDING_EXT': '0x8069',
  'TEXTURE_3D_BINDING_EXT': '0x806A',
  'PERTURB_EXT': '0x85AE',
  'TEXTURE_NORMAL_EXT': '0x85AF',
  'TEXTURE_RECTANGLE_EXT': '0x84F5',
  'TEXTURE_BINDING_RECTANGLE_EXT': '0x84F6',
  'PROXY_TEXTURE_RECTANGLE_EXT': '0x84F7',
  'MAX_RECTANGLE_TEXTURE_SIZE_EXT': '0x84F8',
  'SRGB_EXT': '0x8C40',
  'SRGB8_EXT': '0x8C41',
  'SRGB_ALPHA_EXT': '0x8C42',
  'SRGB8_ALPHA8_EXT': '0x8C43',
  'SLUMINANCE_ALPHA_EXT': '0x8C44',
  'SLUMINANCE8_ALPHA8_EXT': '0x8C45',
  'SLUMINANCE_EXT': '0x8C46',
  'SLUMINANCE8_EXT': '0x8C47',
  'COMPRESSED_SRGB_EXT': '0x8C48',
  'COMPRESSED_SRGB_ALPHA_EXT': '0x8C49',
  'COMPRESSED_SLUMINANCE_EXT': '0x8C4A',
  'COMPRESSED_SLUMINANCE_ALPHA_EXT': '0x8C4B',
  'COMPRESSED_SRGB_S3TC_DXT1_EXT': '0x8C4C',
  'COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT': '0x8C4D',
  'COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT': '0x8C4E',
  'COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT': '0x8C4F',
  'RGB9_E5_EXT': '0x8C3D',
  'UNSIGNED_INT_5_9_9_9_REV_EXT': '0x8C3E',
  'TEXTURE_SHARED_SIZE_EXT': '0x8C3F',
  'TEXTURE_SWIZZLE_R_EXT': '0x8E42',
  'TEXTURE_SWIZZLE_G_EXT': '0x8E43',
  'TEXTURE_SWIZZLE_B_EXT': '0x8E44',
  'TEXTURE_SWIZZLE_A_EXT': '0x8E45',
  'TEXTURE_SWIZZLE_RGBA_EXT': '0x8E46',
  'TIME_ELAPSED_EXT': '0x88BF',
  'TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT': '0x8C76',
  'TRANSFORM_FEEDBACK_BUFFER_MODE_EXT': '0x8C7F',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT': '0x8C80',
  'TRANSFORM_FEEDBACK_VARYINGS_EXT': '0x8C83',
  'TRANSFORM_FEEDBACK_BUFFER_START_EXT': '0x8C84',
  'TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT': '0x8C85',
  'PRIMITIVES_GENERATED_EXT': '0x8C87',
  'TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT': '0x8C88',
  'RASTERIZER_DISCARD_EXT': '0x8C89',
  'MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT': '0x8C8A',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT': '0x8C8B',
  'INTERLEAVED_ATTRIBS_EXT': '0x8C8C',
  'SEPARATE_ATTRIBS_EXT': '0x8C8D',
  'TRANSFORM_FEEDBACK_BUFFER_EXT': '0x8C8E',
  'TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT': '0x8C8F',
  'DOUBLE_EXT': '0x140A',
  'VERTEX_ARRAY_EXT': '0x8074',
  'NORMAL_ARRAY_EXT': '0x8075',
  'COLOR_ARRAY_EXT': '0x8076',
  'INDEX_ARRAY_EXT': '0x8077',
  'TEXTURE_COORD_ARRAY_EXT': '0x8078',
  'EDGE_FLAG_ARRAY_EXT': '0x8079',
  'VERTEX_ARRAY_SIZE_EXT': '0x807A',
  'VERTEX_ARRAY_TYPE_EXT': '0x807B',
  'VERTEX_ARRAY_STRIDE_EXT': '0x807C',
  'VERTEX_ARRAY_COUNT_EXT': '0x807D',
  'NORMAL_ARRAY_TYPE_EXT': '0x807E',
  'NORMAL_ARRAY_STRIDE_EXT': '0x807F',
  'NORMAL_ARRAY_COUNT_EXT': '0x8080',
  'COLOR_ARRAY_SIZE_EXT': '0x8081',
  'COLOR_ARRAY_TYPE_EXT': '0x8082',
  'COLOR_ARRAY_STRIDE_EXT': '0x8083',
  'COLOR_ARRAY_COUNT_EXT': '0x8084',
  'INDEX_ARRAY_TYPE_EXT': '0x8085',
  'INDEX_ARRAY_STRIDE_EXT': '0x8086',
  'INDEX_ARRAY_COUNT_EXT': '0x8087',
  'TEXTURE_COORD_ARRAY_SIZE_EXT': '0x8088',
  'TEXTURE_COORD_ARRAY_TYPE_EXT': '0x8089',
  'TEXTURE_COORD_ARRAY_STRIDE_EXT': '0x808A',
  'TEXTURE_COORD_ARRAY_COUNT_EXT': '0x808B',
  'EDGE_FLAG_ARRAY_STRIDE_EXT': '0x808C',
  'EDGE_FLAG_ARRAY_COUNT_EXT': '0x808D',
  'VERTEX_ARRAY_POINTER_EXT': '0x808E',
  'NORMAL_ARRAY_POINTER_EXT': '0x808F',
  'COLOR_ARRAY_POINTER_EXT': '0x8090',
  'INDEX_ARRAY_POINTER_EXT': '0x8091',
  'TEXTURE_COORD_ARRAY_POINTER_EXT': '0x8092',
  'EDGE_FLAG_ARRAY_POINTER_EXT': '0x8093',
  'BGRA': '0x80E1',
  'VERTEX_SHADER_EXT': '0x8780',
  'VERTEX_SHADER_BINDING_EXT': '0x8781',
  'OP_INDEX_EXT': '0x8782',
  'OP_NEGATE_EXT': '0x8783',
  'OP_DOT3_EXT': '0x8784',
  'OP_DOT4_EXT': '0x8785',
  'OP_MUL_EXT': '0x8786',
  'OP_ADD_EXT': '0x8787',
  'OP_MADD_EXT': '0x8788',
  'OP_FRAC_EXT': '0x8789',
  'OP_MAX_EXT': '0x878A',
  'OP_MIN_EXT': '0x878B',
  'OP_SET_GE_EXT': '0x878C',
  'OP_SET_LT_EXT': '0x878D',
  'OP_CLAMP_EXT': '0x878E',
  'OP_FLOOR_EXT': '0x878F',
  'OP_ROUND_EXT': '0x8790',
  'OP_EXP_BASE_2_EXT': '0x8791',
  'OP_LOG_BASE_2_EXT': '0x8792',
  'OP_POWER_EXT': '0x8793',
  'OP_RECIP_EXT': '0x8794',
  'OP_RECIP_SQRT_EXT': '0x8795',
  'OP_SUB_EXT': '0x8796',
  'OP_CROSS_PRODUCT_EXT': '0x8797',
  'OP_MULTIPLY_MATRIX_EXT': '0x8798',
  'OP_MOV_EXT': '0x8799',
  'OUTPUT_VERTEX_EXT': '0x879A',
  'OUTPUT_COLOR0_EXT': '0x879B',
  'OUTPUT_COLOR1_EXT': '0x879C',
  'OUTPUT_TEXTURE_COORD0_EXT': '0x879D',
  'OUTPUT_TEXTURE_COORD1_EXT': '0x879E',
  'OUTPUT_TEXTURE_COORD2_EXT': '0x879F',
  'OUTPUT_TEXTURE_COORD3_EXT': '0x87A0',
  'OUTPUT_TEXTURE_COORD4_EXT': '0x87A1',
  'OUTPUT_TEXTURE_COORD5_EXT': '0x87A2',
  'OUTPUT_TEXTURE_COORD6_EXT': '0x87A3',
  'OUTPUT_TEXTURE_COORD7_EXT': '0x87A4',
  'OUTPUT_TEXTURE_COORD8_EXT': '0x87A5',
  'OUTPUT_TEXTURE_COORD9_EXT': '0x87A6',
  'OUTPUT_TEXTURE_COORD10_EXT': '0x87A7',
  'OUTPUT_TEXTURE_COORD11_EXT': '0x87A8',
  'OUTPUT_TEXTURE_COORD12_EXT': '0x87A9',
  'OUTPUT_TEXTURE_COORD13_EXT': '0x87AA',
  'OUTPUT_TEXTURE_COORD14_EXT': '0x87AB',
  'OUTPUT_TEXTURE_COORD15_EXT': '0x87AC',
  'OUTPUT_TEXTURE_COORD16_EXT': '0x87AD',
  'OUTPUT_TEXTURE_COORD17_EXT': '0x87AE',
  'OUTPUT_TEXTURE_COORD18_EXT': '0x87AF',
  'OUTPUT_TEXTURE_COORD19_EXT': '0x87B0',
  'OUTPUT_TEXTURE_COORD20_EXT': '0x87B1',
  'OUTPUT_TEXTURE_COORD21_EXT': '0x87B2',
  'OUTPUT_TEXTURE_COORD22_EXT': '0x87B3',
  'OUTPUT_TEXTURE_COORD23_EXT': '0x87B4',
  'OUTPUT_TEXTURE_COORD24_EXT': '0x87B5',
  'OUTPUT_TEXTURE_COORD25_EXT': '0x87B6',
  'OUTPUT_TEXTURE_COORD26_EXT': '0x87B7',
  'OUTPUT_TEXTURE_COORD27_EXT': '0x87B8',
  'OUTPUT_TEXTURE_COORD28_EXT': '0x87B9',
  'OUTPUT_TEXTURE_COORD29_EXT': '0x87BA',
  'OUTPUT_TEXTURE_COORD30_EXT': '0x87BB',
  'OUTPUT_TEXTURE_COORD31_EXT': '0x87BC',
  'OUTPUT_FOG_EXT': '0x87BD',
  'SCALAR_EXT': '0x87BE',
  'VECTOR_EXT': '0x87BF',
  'MATRIX_EXT': '0x87C0',
  'VARIANT_EXT': '0x87C1',
  'INVARIANT_EXT': '0x87C2',
  'LOCAL_CONSTANT_EXT': '0x87C3',
  'LOCAL_EXT': '0x87C4',
  'MAX_VERTEX_SHADER_INSTRUCTIONS_EXT': '0x87C5',
  'MAX_VERTEX_SHADER_VARIANTS_EXT': '0x87C6',
  'MAX_VERTEX_SHADER_INVARIANTS_EXT': '0x87C7',
  'MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT': '0x87C8',
  'MAX_VERTEX_SHADER_LOCALS_EXT': '0x87C9',
  'MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT': '0x87CA',
  'MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT': '0x87CB',
  'MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT': '0x87CC',
  'MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT': '0x87CD',
  'MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT': '0x87CE',
  'VERTEX_SHADER_INSTRUCTIONS_EXT': '0x87CF',
  'VERTEX_SHADER_VARIANTS_EXT': '0x87D0',
  'VERTEX_SHADER_INVARIANTS_EXT': '0x87D1',
  'VERTEX_SHADER_LOCAL_CONSTANTS_EXT': '0x87D2',
  'VERTEX_SHADER_LOCALS_EXT': '0x87D3',
  'VERTEX_SHADER_OPTIMIZED_EXT': '0x87D4',
  'X_EXT': '0x87D5',
  'Y_EXT': '0x87D6',
  'Z_EXT': '0x87D7',
  'W_EXT': '0x87D8',
  'NEGATIVE_X_EXT': '0x87D9',
  'NEGATIVE_Y_EXT': '0x87DA',
  'NEGATIVE_Z_EXT': '0x87DB',
  'NEGATIVE_W_EXT': '0x87DC',
  'ZERO_EXT': '0x87DD',
  'ONE_EXT': '0x87DE',
  'NEGATIVE_ONE_EXT': '0x87DF',
  'NORMALIZED_RANGE_EXT': '0x87E0',
  'FULL_RANGE_EXT': '0x87E1',
  'CURRENT_VERTEX_EXT': '0x87E2',
  'MVP_MATRIX_EXT': '0x87E3',
  'VARIANT_VALUE_EXT': '0x87E4',
  'VARIANT_DATATYPE_EXT': '0x87E5',
  'VARIANT_ARRAY_STRIDE_EXT': '0x87E6',
  'VARIANT_ARRAY_TYPE_EXT': '0x87E7',
  'VARIANT_ARRAY_EXT': '0x87E8',
  'VARIANT_ARRAY_POINTER_EXT': '0x87E9',
  'INVARIANT_VALUE_EXT': '0x87EA',
  'INVARIANT_DATATYPE_EXT': '0x87EB',
  'LOCAL_CONSTANT_VALUE_EXT': '0x87EC',
  'LOCAL_CONSTANT_DATATYPE_EXT': '0x87ED',
  'MODELVIEW0_STACK_DEPTH_EXT': '0x0BA3',
  'MODELVIEW0_MATRIX_EXT': '0x0BA6',
  'MODELVIEW0_EXT': '0x1700',
  'MODELVIEW1_STACK_DEPTH_EXT': '0x8502',
  'MODELVIEW1_MATRIX_EXT': '0x8506',
  'VERTEX_WEIGHTING_EXT': '0x8509',
  'MODELVIEW1_EXT': '0x850A',
  'CURRENT_VERTEX_WEIGHT_EXT': '0x850B',
  'VERTEX_WEIGHT_ARRAY_EXT': '0x850C',
  'VERTEX_WEIGHT_ARRAY_SIZE_EXT': '0x850D',
  'VERTEX_WEIGHT_ARRAY_TYPE_EXT': '0x850E',
  'VERTEX_WEIGHT_ARRAY_STRIDE_EXT': '0x850F',
  'VERTEX_WEIGHT_ARRAY_POINTER_EXT': '0x8510',
  'OCCLUSION_TEST_HP': '0x8165',
  'OCCLUSION_TEST_RESULT_HP': '0x8166',
  'MIRRORED_REPEAT_IBM': '0x8370',
  'RED_MIN_CLAMP_INGR': '0x8560',
  'GREEN_MIN_CLAMP_INGR': '0x8561',
  'BLUE_MIN_CLAMP_INGR': '0x8562',
  'ALPHA_MIN_CLAMP_INGR': '0x8563',
  'RED_MAX_CLAMP_INGR': '0x8564',
  'GREEN_MAX_CLAMP_INGR': '0x8565',
  'BLUE_MAX_CLAMP_INGR': '0x8566',
  'ALPHA_MAX_CLAMP_INGR': '0x8567',
  'INTERLACE_READ_INGR': '0x8568',
  'PARALLEL_ARRAYS_INTEL': '0x83F4',
  'VERTEX_ARRAY_PARALLEL_POINTERS_INTEL': '0x83F5',
  'NORMAL_ARRAY_PARALLEL_POINTERS_INTEL': '0x83F6',
  'COLOR_ARRAY_PARALLEL_POINTERS_INTEL': '0x83F7',
  'TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL': '0x83F8',
  'KTX_FRONT_REGION': '0x0',
  'KTX_BACK_REGION': '0x1',
  'KTX_Z_REGION': '0x2',
  'KTX_STENCIL_REGION': '0x3',
  'TEXTURE_1D_STACK_MESAX': '0x8759',
  'TEXTURE_2D_STACK_MESAX': '0x875A',
  'PROXY_TEXTURE_1D_STACK_MESAX': '0x875B',
  'PROXY_TEXTURE_2D_STACK_MESAX': '0x875C',
  'TEXTURE_1D_STACK_BINDING_MESAX': '0x875D',
  'TEXTURE_2D_STACK_BINDING_MESAX': '0x875E',
  'PACK_INVERT_MESA': '0x8758',
  'UNSIGNED_SHORT_8_8_MESA': '0x85BA',
  'UNSIGNED_SHORT_8_8_REV_MESA': '0x85BB',
  'YCBCR_MESA': '0x8757',
  'QUERY_WAIT_NV': '0x8E13',
  'QUERY_NO_WAIT_NV': '0x8E14',
  'QUERY_BY_REGION_WAIT_NV': '0x8E15',
  'QUERY_BY_REGION_NO_WAIT_NV': '0x8E16',
  'DEPTH_STENCIL_TO_RGBA_NV': '0x886E',
  'DEPTH_STENCIL_TO_BGRA_NV': '0x886F',
  'DEPTH_COMPONENT32F_NV': '0x8DAB',
  'DEPTH32F_STENCIL8_NV': '0x8DAC',
  'FLOAT_32_UNSIGNED_INT_24_8_REV_NV': '0x8DAD',
  'DEPTH_BUFFER_FLOAT_MODE_NV': '0x8DAF',
  'DEPTH_CLAMP_NV': '0x864F',
  'SAMPLE_COUNT_BITS_NV': '0x8864',
  'CURRENT_SAMPLE_COUNT_QUERY_NV': '0x8865',
  'QUERY_RESULT_NV': '0x8866',
  'QUERY_RESULT_AVAILABLE_NV': '0x8867',
  'SAMPLE_COUNT_NV': '0x8914',
  'EVAL_2D_NV': '0x86C0',
  'EVAL_TRIANGULAR_2D_NV': '0x86C1',
  'MAP_TESSELLATION_NV': '0x86C2',
  'MAP_ATTRIB_U_ORDER_NV': '0x86C3',
  'MAP_ATTRIB_V_ORDER_NV': '0x86C4',
  'EVAL_FRACTIONAL_TESSELLATION_NV': '0x86C5',
  'EVAL_VERTEX_ATTRIB0_NV': '0x86C6',
  'EVAL_VERTEX_ATTRIB1_NV': '0x86C7',
  'EVAL_VERTEX_ATTRIB2_NV': '0x86C8',
  'EVAL_VERTEX_ATTRIB3_NV': '0x86C9',
  'EVAL_VERTEX_ATTRIB4_NV': '0x86CA',
  'EVAL_VERTEX_ATTRIB5_NV': '0x86CB',
  'EVAL_VERTEX_ATTRIB6_NV': '0x86CC',
  'EVAL_VERTEX_ATTRIB7_NV': '0x86CD',
  'EVAL_VERTEX_ATTRIB8_NV': '0x86CE',
  'EVAL_VERTEX_ATTRIB9_NV': '0x86CF',
  'EVAL_VERTEX_ATTRIB10_NV': '0x86D0',
  'EVAL_VERTEX_ATTRIB11_NV': '0x86D1',
  'EVAL_VERTEX_ATTRIB12_NV': '0x86D2',
  'EVAL_VERTEX_ATTRIB13_NV': '0x86D3',
  'EVAL_VERTEX_ATTRIB14_NV': '0x86D4',
  'EVAL_VERTEX_ATTRIB15_NV': '0x86D5',
  'MAX_MAP_TESSELLATION_NV': '0x86D6',
  'MAX_RATIONAL_EVAL_ORDER_NV': '0x86D7',
  'SAMPLE_POSITION_NV': '0x8E50',
  'SAMPLE_MASK_NV': '0x8E51',
  'SAMPLE_MASK_VALUE_NV': '0x8E52',
  'TEXTURE_BINDING_RENDERBUFFER_NV': '0x8E53',
  'TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV': '0x8E54',
  'TEXTURE_RENDERBUFFER_NV': '0x8E55',
  'SAMPLER_RENDERBUFFER_NV': '0x8E56',
  'INT_SAMPLER_RENDERBUFFER_NV': '0x8E57',
  'UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV': '0x8E58',
  'MAX_SAMPLE_MASK_WORDS_NV': '0x8E59',
  'ALL_COMPLETED_NV': '0x84F2',
  'FENCE_STATUS_NV': '0x84F3',
  'FENCE_CONDITION_NV': '0x84F4',
  'FLOAT_R_NV': '0x8880',
  'FLOAT_RG_NV': '0x8881',
  'FLOAT_RGB_NV': '0x8882',
  'FLOAT_RGBA_NV': '0x8883',
  'FLOAT_R16_NV': '0x8884',
  'FLOAT_R32_NV': '0x8885',
  'FLOAT_RG16_NV': '0x8886',
  'FLOAT_RG32_NV': '0x8887',
  'FLOAT_RGB16_NV': '0x8888',
  'FLOAT_RGB32_NV': '0x8889',
  'FLOAT_RGBA16_NV': '0x888A',
  'FLOAT_RGBA32_NV': '0x888B',
  'TEXTURE_FLOAT_COMPONENTS_NV': '0x888C',
  'FLOAT_CLEAR_COLOR_VALUE_NV': '0x888D',
  'FLOAT_RGBA_MODE_NV': '0x888E',
  'FOG_DISTANCE_MODE_NV': '0x855A',
  'EYE_RADIAL_NV': '0x855B',
  'EYE_PLANE_ABSOLUTE_NV': '0x855C',
  'MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV': '0x8868',
  'FRAGMENT_PROGRAM_NV': '0x8870',
  'MAX_TEXTURE_COORDS_NV': '0x8871',
  'MAX_TEXTURE_IMAGE_UNITS_NV': '0x8872',
  'FRAGMENT_PROGRAM_BINDING_NV': '0x8873',
  'PROGRAM_ERROR_STRING_NV': '0x8874',
  'MAX_PROGRAM_EXEC_INSTRUCTIONS_NV': '0x88F4',
  'MAX_PROGRAM_CALL_DEPTH_NV': '0x88F5',
  'MAX_PROGRAM_IF_DEPTH_NV': '0x88F6',
  'MAX_PROGRAM_LOOP_DEPTH_NV': '0x88F7',
  'MAX_PROGRAM_LOOP_COUNT_NV': '0x88F8',
  'RENDERBUFFER_COVERAGE_SAMPLES_NV': '0x8CAB',
  'RENDERBUFFER_COLOR_SAMPLES_NV': '0x8E10',
  'MAX_MULTISAMPLE_COVERAGE_MODES_NV': '0x8E11',
  'MULTISAMPLE_COVERAGE_MODES_NV': '0x8E12',
  'GEOMETRY_PROGRAM_NV': '0x8C26',
  'MAX_PROGRAM_OUTPUT_VERTICES_NV': '0x8C27',
  'MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV': '0x8C28',
  'MIN_PROGRAM_TEXEL_OFFSET_NV': '0x8904',
  'MAX_PROGRAM_TEXEL_OFFSET_NV': '0x8905',
  'PROGRAM_ATTRIB_COMPONENTS_NV': '0x8906',
  'PROGRAM_RESULT_COMPONENTS_NV': '0x8907',
  'MAX_PROGRAM_ATTRIB_COMPONENTS_NV': '0x8908',
  'MAX_PROGRAM_RESULT_COMPONENTS_NV': '0x8909',
  'MAX_PROGRAM_GENERIC_ATTRIBS_NV': '0x8DA5',
  'MAX_PROGRAM_GENERIC_RESULTS_NV': '0x8DA6',
  'HALF_FLOAT_NV': '0x140B',
  'MAX_SHININESS_NV': '0x8504',
  'MAX_SPOT_EXPONENT_NV': '0x8505',
  'MULTISAMPLE_FILTER_HINT_NV': '0x8534',
  'PIXEL_COUNTER_BITS_NV': '0x8864',
  'CURRENT_OCCLUSION_QUERY_ID_NV': '0x8865',
  'PIXEL_COUNT_NV': '0x8866',
  'PIXEL_COUNT_AVAILABLE_NV': '0x8867',
  'DEPTH_STENCIL_NV': '0x84F9',
  'UNSIGNED_INT_24_8_NV': '0x84FA',
  'MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV': '0x8DA0',
  'MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV': '0x8DA1',
  'VERTEX_PROGRAM_PARAMETER_BUFFER_NV': '0x8DA2',
  'GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV': '0x8DA3',
  'FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV': '0x8DA4',
  'WRITE_PIXEL_DATA_RANGE_NV': '0x8878',
  'READ_PIXEL_DATA_RANGE_NV': '0x8879',
  'WRITE_PIXEL_DATA_RANGE_LENGTH_NV': '0x887A',
  'READ_PIXEL_DATA_RANGE_LENGTH_NV': '0x887B',
  'WRITE_PIXEL_DATA_RANGE_POINTER_NV': '0x887C',
  'READ_PIXEL_DATA_RANGE_POINTER_NV': '0x887D',
  'POINT_SPRITE_NV': '0x8861',
  'COORD_REPLACE_NV': '0x8862',
  'POINT_SPRITE_R_MODE_NV': '0x8863',
  'FRAME_NV': '0x8E26',
  'FIELDS_NV': '0x8E27',
  'CURRENT_TIME_NV': '0x8E28',
  'NUM_FILL_STREAMS_NV': '0x8E29',
  'PRESENT_TIME_NV': '0x8E2A',
  'PRESENT_DURATION_NV': '0x8E2B',
  'PRIMITIVE_RESTART_NV': '0x8558',
  'PRIMITIVE_RESTART_INDEX_NV': '0x8559',
  'REGISTER_COMBINERS_NV': '0x8522',
  'VARIABLE_A_NV': '0x8523',
  'VARIABLE_B_NV': '0x8524',
  'VARIABLE_C_NV': '0x8525',
  'VARIABLE_D_NV': '0x8526',
  'VARIABLE_E_NV': '0x8527',
  'VARIABLE_F_NV': '0x8528',
  'VARIABLE_G_NV': '0x8529',
  'CONSTANT_COLOR0_NV': '0x852A',
  'CONSTANT_COLOR1_NV': '0x852B',
  'PRIMARY_COLOR_NV': '0x852C',
  'SECONDARY_COLOR_NV': '0x852D',
  'SPARE0_NV': '0x852E',
  'SPARE1_NV': '0x852F',
  'DISCARD_NV': '0x8530',
  'E_TIMES_F_NV': '0x8531',
  'SPARE0_PLUS_SECONDARY_COLOR_NV': '0x8532',
  'UNSIGNED_IDENTITY_NV': '0x8536',
  'UNSIGNED_INVERT_NV': '0x8537',
  'EXPAND_NORMAL_NV': '0x8538',
  'EXPAND_NEGATE_NV': '0x8539',
  'HALF_BIAS_NORMAL_NV': '0x853A',
  'HALF_BIAS_NEGATE_NV': '0x853B',
  'SIGNED_IDENTITY_NV': '0x853C',
  'SIGNED_NEGATE_NV': '0x853D',
  'SCALE_BY_TWO_NV': '0x853E',
  'SCALE_BY_FOUR_NV': '0x853F',
  'SCALE_BY_ONE_HALF_NV': '0x8540',
  'BIAS_BY_NEGATIVE_ONE_HALF_NV': '0x8541',
  'COMBINER_INPUT_NV': '0x8542',
  'COMBINER_MAPPING_NV': '0x8543',
  'COMBINER_COMPONENT_USAGE_NV': '0x8544',
  'COMBINER_AB_DOT_PRODUCT_NV': '0x8545',
  'COMBINER_CD_DOT_PRODUCT_NV': '0x8546',
  'COMBINER_MUX_SUM_NV': '0x8547',
  'COMBINER_SCALE_NV': '0x8548',
  'COMBINER_BIAS_NV': '0x8549',
  'COMBINER_AB_OUTPUT_NV': '0x854A',
  'COMBINER_CD_OUTPUT_NV': '0x854B',
  'COMBINER_SUM_OUTPUT_NV': '0x854C',
  'MAX_GENERAL_COMBINERS_NV': '0x854D',
  'NUM_GENERAL_COMBINERS_NV': '0x854E',
  'COLOR_SUM_CLAMP_NV': '0x854F',
  'COMBINER0_NV': '0x8550',
  'COMBINER1_NV': '0x8551',
  'COMBINER2_NV': '0x8552',
  'COMBINER3_NV': '0x8553',
  'COMBINER4_NV': '0x8554',
  'COMBINER5_NV': '0x8555',
  'COMBINER6_NV': '0x8556',
  'COMBINER7_NV': '0x8557',
  'PER_STAGE_CONSTANTS_NV': '0x8535',
  'EMBOSS_LIGHT_NV': '0x855D',
  'EMBOSS_CONSTANT_NV': '0x855E',
  'EMBOSS_MAP_NV': '0x855F',
  'NORMAL_MAP_NV': '0x8511',
  'REFLECTION_MAP_NV': '0x8512',
  'COMBINE4_NV': '0x8503',
  'SOURCE3_RGB_NV': '0x8583',
  'SOURCE3_ALPHA_NV': '0x858B',
  'OPERAND3_RGB_NV': '0x8593',
  'OPERAND3_ALPHA_NV': '0x859B',
  'TEXTURE_UNSIGNED_REMAP_MODE_NV': '0x888F',
  'TEXTURE_RECTANGLE_NV': '0x84F5',
  'TEXTURE_BINDING_RECTANGLE_NV': '0x84F6',
  'PROXY_TEXTURE_RECTANGLE_NV': '0x84F7',
  'MAX_RECTANGLE_TEXTURE_SIZE_NV': '0x84F8',
  'OFFSET_TEXTURE_RECTANGLE_NV': '0x864C',
  'OFFSET_TEXTURE_RECTANGLE_SCALE_NV': '0x864D',
  'DOT_PRODUCT_TEXTURE_RECTANGLE_NV': '0x864E',
  'RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV': '0x86D9',
  'UNSIGNED_INT_S8_S8_8_8_NV': '0x86DA',
  'UNSIGNED_INT_8_8_S8_S8_REV_NV': '0x86DB',
  'DSDT_MAG_INTENSITY_NV': '0x86DC',
  'SHADER_CONSISTENT_NV': '0x86DD',
  'TEXTURE_SHADER_NV': '0x86DE',
  'SHADER_OPERATION_NV': '0x86DF',
  'CULL_MODES_NV': '0x86E0',
  'OFFSET_TEXTURE_2D_MATRIX_NV': '0x86E1',
  'OFFSET_TEXTURE_MATRIX_NV': '0x86E1',
  'OFFSET_TEXTURE_2D_SCALE_NV': '0x86E2',
  'OFFSET_TEXTURE_SCALE_NV': '0x86E2',
  'OFFSET_TEXTURE_BIAS_NV': '0x86E3',
  'OFFSET_TEXTURE_2D_BIAS_NV': '0x86E3',
  'PREVIOUS_TEXTURE_INPUT_NV': '0x86E4',
  'CONST_EYE_NV': '0x86E5',
  'PASS_THROUGH_NV': '0x86E6',
  'CULL_FRAGMENT_NV': '0x86E7',
  'OFFSET_TEXTURE_2D_NV': '0x86E8',
  'DEPENDENT_AR_TEXTURE_2D_NV': '0x86E9',
  'DEPENDENT_GB_TEXTURE_2D_NV': '0x86EA',
  'DOT_PRODUCT_NV': '0x86EC',
  'DOT_PRODUCT_DEPTH_REPLACE_NV': '0x86ED',
  'DOT_PRODUCT_TEXTURE_2D_NV': '0x86EE',
  'DOT_PRODUCT_TEXTURE_CUBE_MAP_NV': '0x86F0',
  'DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV': '0x86F1',
  'DOT_PRODUCT_REFLECT_CUBE_MAP_NV': '0x86F2',
  'DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV': '0x86F3',
  'HILO_NV': '0x86F4',
  'DSDT_NV': '0x86F5',
  'DSDT_MAG_NV': '0x86F6',
  'DSDT_MAG_VIB_NV': '0x86F7',
  'HILO16_NV': '0x86F8',
  'SIGNED_HILO_NV': '0x86F9',
  'SIGNED_HILO16_NV': '0x86FA',
  'SIGNED_RGBA_NV': '0x86FB',
  'SIGNED_RGBA8_NV': '0x86FC',
  'SIGNED_RGB_NV': '0x86FE',
  'SIGNED_RGB8_NV': '0x86FF',
  'SIGNED_LUMINANCE_NV': '0x8701',
  'SIGNED_LUMINANCE8_NV': '0x8702',
  'SIGNED_LUMINANCE_ALPHA_NV': '0x8703',
  'SIGNED_LUMINANCE8_ALPHA8_NV': '0x8704',
  'SIGNED_ALPHA_NV': '0x8705',
  'SIGNED_ALPHA8_NV': '0x8706',
  'SIGNED_INTENSITY_NV': '0x8707',
  'SIGNED_INTENSITY8_NV': '0x8708',
  'DSDT8_NV': '0x8709',
  'DSDT8_MAG8_NV': '0x870A',
  'DSDT8_MAG8_INTENSITY8_NV': '0x870B',
  'SIGNED_RGB_UNSIGNED_ALPHA_NV': '0x870C',
  'SIGNED_RGB8_UNSIGNED_ALPHA8_NV': '0x870D',
  'HI_SCALE_NV': '0x870E',
  'LO_SCALE_NV': '0x870F',
  'DS_SCALE_NV': '0x8710',
  'DT_SCALE_NV': '0x8711',
  'MAGNITUDE_SCALE_NV': '0x8712',
  'VIBRANCE_SCALE_NV': '0x8713',
  'HI_BIAS_NV': '0x8714',
  'LO_BIAS_NV': '0x8715',
  'DS_BIAS_NV': '0x8716',
  'DT_BIAS_NV': '0x8717',
  'MAGNITUDE_BIAS_NV': '0x8718',
  'VIBRANCE_BIAS_NV': '0x8719',
  'TEXTURE_BORDER_VALUES_NV': '0x871A',
  'TEXTURE_HI_SIZE_NV': '0x871B',
  'TEXTURE_LO_SIZE_NV': '0x871C',
  'TEXTURE_DS_SIZE_NV': '0x871D',
  'TEXTURE_DT_SIZE_NV': '0x871E',
  'TEXTURE_MAG_SIZE_NV': '0x871F',
  'UNSIGNED_INT_S8_S8_8_8_NV': '0x86DA',
  'UNSIGNED_INT_8_8_S8_S8_REV_NV': '0x86DB',
  'DSDT_MAG_INTENSITY_NV': '0x86DC',
  'DOT_PRODUCT_TEXTURE_3D_NV': '0x86EF',
  'HILO_NV': '0x86F4',
  'DSDT_NV': '0x86F5',
  'DSDT_MAG_NV': '0x86F6',
  'DSDT_MAG_VIB_NV': '0x86F7',
  'HILO16_NV': '0x86F8',
  'SIGNED_HILO_NV': '0x86F9',
  'SIGNED_HILO16_NV': '0x86FA',
  'SIGNED_RGBA_NV': '0x86FB',
  'SIGNED_RGBA8_NV': '0x86FC',
  'SIGNED_RGB_NV': '0x86FE',
  'SIGNED_RGB8_NV': '0x86FF',
  'SIGNED_LUMINANCE_NV': '0x8701',
  'SIGNED_LUMINANCE8_NV': '0x8702',
  'SIGNED_LUMINANCE_ALPHA_NV': '0x8703',
  'SIGNED_LUMINANCE8_ALPHA8_NV': '0x8704',
  'SIGNED_ALPHA_NV': '0x8705',
  'SIGNED_ALPHA8_NV': '0x8706',
  'SIGNED_INTENSITY_NV': '0x8707',
  'SIGNED_INTENSITY8_NV': '0x8708',
  'DSDT8_NV': '0x8709',
  'DSDT8_MAG8_NV': '0x870A',
  'DSDT8_MAG8_INTENSITY8_NV': '0x870B',
  'SIGNED_RGB_UNSIGNED_ALPHA_NV': '0x870C',
  'SIGNED_RGB8_UNSIGNED_ALPHA8_NV': '0x870D',
  'OFFSET_PROJECTIVE_TEXTURE_2D_NV': '0x8850',
  'OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV': '0x8851',
  'OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV': '0x8852',
  'OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV': '0x8853',
  'OFFSET_HILO_TEXTURE_2D_NV': '0x8854',
  'OFFSET_HILO_TEXTURE_RECTANGLE_NV': '0x8855',
  'OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV': '0x8856',
  'OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV': '0x8857',
  'DEPENDENT_HILO_TEXTURE_2D_NV': '0x8858',
  'DEPENDENT_RGB_TEXTURE_3D_NV': '0x8859',
  'DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV': '0x885A',
  'DOT_PRODUCT_PASS_THROUGH_NV': '0x885B',
  'DOT_PRODUCT_TEXTURE_1D_NV': '0x885C',
  'DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV': '0x885D',
  'HILO8_NV': '0x885E',
  'SIGNED_HILO8_NV': '0x885F',
  'FORCE_BLUE_TO_ONE_NV': '0x8860',
  'BACK_PRIMARY_COLOR_NV': '0x8C77',
  'BACK_SECONDARY_COLOR_NV': '0x8C78',
  'TEXTURE_COORD_NV': '0x8C79',
  'CLIP_DISTANCE_NV': '0x8C7A',
  'VERTEX_ID_NV': '0x8C7B',
  'PRIMITIVE_ID_NV': '0x8C7C',
  'GENERIC_ATTRIB_NV': '0x8C7D',
  'TRANSFORM_FEEDBACK_ATTRIBS_NV': '0x8C7E',
  'TRANSFORM_FEEDBACK_BUFFER_MODE_NV': '0x8C7F',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV': '0x8C80',
  'ACTIVE_VARYINGS_NV': '0x8C81',
  'ACTIVE_VARYING_MAX_LENGTH_NV': '0x8C82',
  'TRANSFORM_FEEDBACK_VARYINGS_NV': '0x8C83',
  'TRANSFORM_FEEDBACK_BUFFER_START_NV': '0x8C84',
  'TRANSFORM_FEEDBACK_BUFFER_SIZE_NV': '0x8C85',
  'TRANSFORM_FEEDBACK_RECORD_NV': '0x8C86',
  'PRIMITIVES_GENERATED_NV': '0x8C87',
  'TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV': '0x8C88',
  'RASTERIZER_DISCARD_NV': '0x8C89',
  'MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV': '0x8C8A',
  'MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV': '0x8C8B',
  'INTERLEAVED_ATTRIBS_NV': '0x8C8C',
  'SEPARATE_ATTRIBS_NV': '0x8C8D',
  'TRANSFORM_FEEDBACK_BUFFER_NV': '0x8C8E',
  'TRANSFORM_FEEDBACK_BUFFER_BINDING_NV': '0x8C8F',
  'VERTEX_ARRAY_RANGE_NV': '0x851D',
  'VERTEX_ARRAY_RANGE_LENGTH_NV': '0x851E',
  'VERTEX_ARRAY_RANGE_VALID_NV': '0x851F',
  'MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV': '0x8520',
  'VERTEX_ARRAY_RANGE_POINTER_NV': '0x8521',
  'VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV': '0x8533',
  'VERTEX_PROGRAM_NV': '0x8620',
  'VERTEX_STATE_PROGRAM_NV': '0x8621',
  'ATTRIB_ARRAY_SIZE_NV': '0x8623',
  'ATTRIB_ARRAY_STRIDE_NV': '0x8624',
  'ATTRIB_ARRAY_TYPE_NV': '0x8625',
  'CURRENT_ATTRIB_NV': '0x8626',
  'PROGRAM_LENGTH_NV': '0x8627',
  'PROGRAM_STRING_NV': '0x8628',
  'MODELVIEW_PROJECTION_NV': '0x8629',
  'IDENTITY_NV': '0x862A',
  'INVERSE_NV': '0x862B',
  'TRANSPOSE_NV': '0x862C',
  'INVERSE_TRANSPOSE_NV': '0x862D',
  'MAX_TRACK_MATRIX_STACK_DEPTH_NV': '0x862E',
  'MAX_TRACK_MATRICES_NV': '0x862F',
  'MATRIX0_NV': '0x8630',
  'MATRIX1_NV': '0x8631',
  'MATRIX2_NV': '0x8632',
  'MATRIX3_NV': '0x8633',
  'MATRIX4_NV': '0x8634',
  'MATRIX5_NV': '0x8635',
  'MATRIX6_NV': '0x8636',
  'MATRIX7_NV': '0x8637',
  'CURRENT_MATRIX_STACK_DEPTH_NV': '0x8640',
  'CURRENT_MATRIX_NV': '0x8641',
  'VERTEX_PROGRAM_POINT_SIZE_NV': '0x8642',
  'VERTEX_PROGRAM_TWO_SIDE_NV': '0x8643',
  'PROGRAM_PARAMETER_NV': '0x8644',
  'ATTRIB_ARRAY_POINTER_NV': '0x8645',
  'PROGRAM_TARGET_NV': '0x8646',
  'PROGRAM_RESIDENT_NV': '0x8647',
  'TRACK_MATRIX_NV': '0x8648',
  'TRACK_MATRIX_TRANSFORM_NV': '0x8649',
  'VERTEX_PROGRAM_BINDING_NV': '0x864A',
  'PROGRAM_ERROR_POSITION_NV': '0x864B',
  'VERTEX_ATTRIB_ARRAY0_NV': '0x8650',
  'VERTEX_ATTRIB_ARRAY1_NV': '0x8651',
  'VERTEX_ATTRIB_ARRAY2_NV': '0x8652',
  'VERTEX_ATTRIB_ARRAY3_NV': '0x8653',
  'VERTEX_ATTRIB_ARRAY4_NV': '0x8654',
  'VERTEX_ATTRIB_ARRAY5_NV': '0x8655',
  'VERTEX_ATTRIB_ARRAY6_NV': '0x8656',
  'VERTEX_ATTRIB_ARRAY7_NV': '0x8657',
  'VERTEX_ATTRIB_ARRAY8_NV': '0x8658',
  'VERTEX_ATTRIB_ARRAY9_NV': '0x8659',
  'VERTEX_ATTRIB_ARRAY10_NV': '0x865A',
  'VERTEX_ATTRIB_ARRAY11_NV': '0x865B',
  'VERTEX_ATTRIB_ARRAY12_NV': '0x865C',
  'VERTEX_ATTRIB_ARRAY13_NV': '0x865D',
  'VERTEX_ATTRIB_ARRAY14_NV': '0x865E',
  'VERTEX_ATTRIB_ARRAY15_NV': '0x865F',
  'MAP1_VERTEX_ATTRIB0_4_NV': '0x8660',
  'MAP1_VERTEX_ATTRIB1_4_NV': '0x8661',
  'MAP1_VERTEX_ATTRIB2_4_NV': '0x8662',
  'MAP1_VERTEX_ATTRIB3_4_NV': '0x8663',
  'MAP1_VERTEX_ATTRIB4_4_NV': '0x8664',
  'MAP1_VERTEX_ATTRIB5_4_NV': '0x8665',
  'MAP1_VERTEX_ATTRIB6_4_NV': '0x8666',
  'MAP1_VERTEX_ATTRIB7_4_NV': '0x8667',
  'MAP1_VERTEX_ATTRIB8_4_NV': '0x8668',
  'MAP1_VERTEX_ATTRIB9_4_NV': '0x8669',
  'MAP1_VERTEX_ATTRIB10_4_NV': '0x866A',
  'MAP1_VERTEX_ATTRIB11_4_NV': '0x866B',
  'MAP1_VERTEX_ATTRIB12_4_NV': '0x866C',
  'MAP1_VERTEX_ATTRIB13_4_NV': '0x866D',
  'MAP1_VERTEX_ATTRIB14_4_NV': '0x866E',
  'MAP1_VERTEX_ATTRIB15_4_NV': '0x866F',
  'MAP2_VERTEX_ATTRIB0_4_NV': '0x8670',
  'MAP2_VERTEX_ATTRIB1_4_NV': '0x8671',
  'MAP2_VERTEX_ATTRIB2_4_NV': '0x8672',
  'MAP2_VERTEX_ATTRIB3_4_NV': '0x8673',
  'MAP2_VERTEX_ATTRIB4_4_NV': '0x8674',
  'MAP2_VERTEX_ATTRIB5_4_NV': '0x8675',
  'MAP2_VERTEX_ATTRIB6_4_NV': '0x8676',
  'MAP2_VERTEX_ATTRIB7_4_NV': '0x8677',
  'MAP2_VERTEX_ATTRIB8_4_NV': '0x8678',
  'MAP2_VERTEX_ATTRIB9_4_NV': '0x8679',
  'MAP2_VERTEX_ATTRIB10_4_NV': '0x867A',
  'MAP2_VERTEX_ATTRIB11_4_NV': '0x867B',
  'MAP2_VERTEX_ATTRIB12_4_NV': '0x867C',
  'MAP2_VERTEX_ATTRIB13_4_NV': '0x867D',
  'MAP2_VERTEX_ATTRIB14_4_NV': '0x867E',
  'MAP2_VERTEX_ATTRIB15_4_NV': '0x867F',
  'MAX_PROGRAM_EXEC_INSTRUCTIONS_NV': '0x88F4',
  'MAX_PROGRAM_CALL_DEPTH_NV': '0x88F5',
  'MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB': '0x8B4C',
  'BYTE': '0x1400',
  'PALETTE4_RGB8_OES': '0x8B90',
  'PALETTE4_RGBA8_OES': '0x8B91',
  'PALETTE4_R5_G6_B5_OES': '0x8B92',
  'PALETTE4_RGBA4_OES': '0x8B93',
  'PALETTE4_RGB5_A1_OES': '0x8B94',
  'PALETTE8_RGB8_OES': '0x8B95',
  'PALETTE8_RGBA8_OES': '0x8B96',
  'PALETTE8_R5_G6_B5_OES': '0x8B97',
  'PALETTE8_RGBA4_OES': '0x8B98',
  'PALETTE8_RGB5_A1_OES': '0x8B99',
  'IMPLEMENTATION_COLOR_READ_TYPE_OES': '0x8B9A',
  'IMPLEMENTATION_COLOR_READ_FORMAT_OES': '0x8B9B',
  'INTERLACE_OML': '0x8980',
  'INTERLACE_READ_OML': '0x8981',
  'PACK_RESAMPLE_OML': '0x8984',
  'UNPACK_RESAMPLE_OML': '0x8985',
  'RESAMPLE_REPLICATE_OML': '0x8986',
  'RESAMPLE_ZERO_FILL_OML': '0x8987',
  'RESAMPLE_AVERAGE_OML': '0x8988',
  'RESAMPLE_DECIMATE_OML': '0x8989',
  'FORMAT_SUBSAMPLE_24_24_OML': '0x8982',
  'FORMAT_SUBSAMPLE_244_244_OML': '0x8983',
  'VERTEX23_BIT_PGI': '0x00000004',
  'VERTEX4_BIT_PGI': '0x00000008',
  'COLOR3_BIT_PGI': '0x00010000',
  'COLOR4_BIT_PGI': '0x00020000',
  'EDGEFLAG_BIT_PGI': '0x00040000',
  'INDEX_BIT_PGI': '0x00080000',
  'MAT_AMBIENT_BIT_PGI': '0x00100000',
  'MAT_AMBIENT_AND_DIFFUSE_BIT_PGI': '0x00200000',
  'MAT_DIFFUSE_BIT_PGI': '0x00400000',
  'MAT_EMISSION_BIT_PGI': '0x00800000',
  'MAT_COLOR_INDEXES_BIT_PGI': '0x01000000',
  'MAT_SHININESS_BIT_PGI': '0x02000000',
  'MAT_SPECULAR_BIT_PGI': '0x04000000',
  'NORMAL_BIT_PGI': '0x08000000',
  'TEXCOORD1_BIT_PGI': '0x10000000',
  'TEXCOORD2_BIT_PGI': '0x20000000',
  'TEXCOORD3_BIT_PGI': '0x40000000',
  'TEXCOORD4_BIT_PGI': '0x80000000',
  'SCREEN_COORDINATES_REND': '0x8490',
  'INVERTED_SCREEN_W_REND': '0x8491',
  'RGB_S3TC': '0x83A0',
  'RGB4_S3TC': '0x83A1',
  'RGBA_S3TC': '0x83A2',
  'RGBA4_S3TC': '0x83A3',
  'RGBA_DXT5_S3TC': '0x83A4',
  'RGBA4_DXT5_S3TC': '0x83A5',
  'EXTENDED_RANGE_SGIS': '0x85A5',
  'MIN_RED_SGIS': '0x85A6',
  'MAX_RED_SGIS': '0x85A7',
  'MIN_GREEN_SGIS': '0x85A8',
  'MAX_GREEN_SGIS': '0x85A9',
  'MIN_BLUE_SGIS': '0x85AA',
  'MAX_BLUE_SGIS': '0x85AB',
  'MIN_ALPHA_SGIS': '0x85AC',
  'MAX_ALPHA_SGIS': '0x85AD',
  'GENERATE_MIPMAP_SGIS': '0x8191',
  'GENERATE_MIPMAP_HINT_SGIS': '0x8192',
  'MULTISAMPLE_SGIS': '0x809D',
  'SAMPLE_ALPHA_TO_MASK_SGIS': '0x809E',
  'SAMPLE_ALPHA_TO_ONE_SGIS': '0x809F',
  'SAMPLE_MASK_SGIS': '0x80A0',
  '1PASS_SGIS': '0x80A1',
  '2PASS_0_SGIS': '0x80A2',
  '2PASS_1_SGIS': '0x80A3',
  '4PASS_0_SGIS': '0x80A4',
  '4PASS_1_SGIS': '0x80A5',
  '4PASS_2_SGIS': '0x80A6',
  '4PASS_3_SGIS': '0x80A7',
  'SAMPLE_BUFFERS_SGIS': '0x80A8',
  'SAMPLES_SGIS': '0x80A9',
  'SAMPLE_MASK_VALUE_SGIS': '0x80AA',
  'SAMPLE_MASK_INVERT_SGIS': '0x80AB',
  'SAMPLE_PATTERN_SGIS': '0x80AC',
  'MULTISAMPLE_BIT_EXT': '0x20000000',
  'EYE_DISTANCE_TO_POINT_SGIS': '0x81F0',
  'OBJECT_DISTANCE_TO_POINT_SGIS': '0x81F1',
  'EYE_DISTANCE_TO_LINE_SGIS': '0x81F2',
  'OBJECT_DISTANCE_TO_LINE_SGIS': '0x81F3',
  'EYE_POINT_SGIS': '0x81F4',
  'OBJECT_POINT_SGIS': '0x81F5',
  'EYE_LINE_SGIS': '0x81F6',
  'OBJECT_LINE_SGIS': '0x81F7',
  'CLAMP_TO_BORDER_SGIS': '0x812D',
  'CLAMP_TO_EDGE_SGIS': '0x812F',
  'TEXTURE_MIN_LOD_SGIS': '0x813A',
  'TEXTURE_MAX_LOD_SGIS': '0x813B',
  'TEXTURE_BASE_LEVEL_SGIS': '0x813C',
  'TEXTURE_MAX_LEVEL_SGIS': '0x813D',
  'ASYNC_MARKER_SGIX': '0x8329',
  'ASYNC_HISTOGRAM_SGIX': '0x832C',
  'MAX_ASYNC_HISTOGRAM_SGIX': '0x832D',
  'ASYNC_TEX_IMAGE_SGIX': '0x835C',
  'ASYNC_DRAW_PIXELS_SGIX': '0x835D',
  'ASYNC_READ_PIXELS_SGIX': '0x835E',
  'MAX_ASYNC_TEX_IMAGE_SGIX': '0x835F',
  'MAX_ASYNC_DRAW_PIXELS_SGIX': '0x8360',
  'MAX_ASYNC_READ_PIXELS_SGIX': '0x8361',
  'ALPHA_MIN_SGIX': '0x8320',
  'ALPHA_MAX_SGIX': '0x8321',
  'CONVOLUTION_HINT_SGIX': '0x8316',
  'DEPTH_COMPONENT16_SGIX': '0x81A5',
  'DEPTH_COMPONENT24_SGIX': '0x81A6',
  'DEPTH_COMPONENT32_SGIX': '0x81A7',
  'FOG_OFFSET_SGIX': '0x8198',
  'FOG_OFFSET_VALUE_SGIX': '0x8199',
  'INTERLACE_SGIX': '0x8094',
  'PACK_RESAMPLE_SGIX': '0x842E',
  'UNPACK_RESAMPLE_SGIX': '0x842F',
  'RESAMPLE_DECIMATE_SGIX': '0x8430',
  'RESAMPLE_REPLICATE_SGIX': '0x8433',
  'RESAMPLE_ZERO_FILL_SGIX': '0x8434',
  'TEXTURE_COMPARE_SGIX': '0x819A',
  'TEXTURE_COMPARE_OPERATOR_SGIX': '0x819B',
  'TEXTURE_LEQUAL_R_SGIX': '0x819C',
  'TEXTURE_GEQUAL_R_SGIX': '0x819D',
  'SHADOW_AMBIENT_SGIX': '0x80BF',
  'TEXTURE_MAX_CLAMP_S_SGIX': '0x8369',
  'TEXTURE_MAX_CLAMP_T_SGIX': '0x836A',
  'TEXTURE_MAX_CLAMP_R_SGIX': '0x836B',
  'TEXTURE_MULTI_BUFFER_HINT_SGIX': '0x812E',
  'RGB_SIGNED_SGIX': '0x85E0',
  'RGBA_SIGNED_SGIX': '0x85E1',
  'ALPHA_SIGNED_SGIX': '0x85E2',
  'LUMINANCE_SIGNED_SGIX': '0x85E3',
  'INTENSITY_SIGNED_SGIX': '0x85E4',
  'LUMINANCE_ALPHA_SIGNED_SGIX': '0x85E5',
  'RGB16_SIGNED_SGIX': '0x85E6',
  'RGBA16_SIGNED_SGIX': '0x85E7',
  'ALPHA16_SIGNED_SGIX': '0x85E8',
  'LUMINANCE16_SIGNED_SGIX': '0x85E9',
  'INTENSITY16_SIGNED_SGIX': '0x85EA',
  'LUMINANCE16_ALPHA16_SIGNED_SGIX': '0x85EB',
  'RGB_EXTENDED_RANGE_SGIX': '0x85EC',
  'RGBA_EXTENDED_RANGE_SGIX': '0x85ED',
  'ALPHA_EXTENDED_RANGE_SGIX': '0x85EE',
  'LUMINANCE_EXTENDED_RANGE_SGIX': '0x85EF',
  'INTENSITY_EXTENDED_RANGE_SGIX': '0x85F0',
  'LUMINANCE_ALPHA_EXTENDED_RANGE_SGIX': '0x85F1',
  'RGB16_EXTENDED_RANGE_SGIX': '0x85F2',
  'RGBA16_EXTENDED_RANGE_SGIX': '0x85F3',
  'ALPHA16_EXTENDED_RANGE_SGIX': '0x85F4',
  'LUMINANCE16_EXTENDED_RANGE_SGIX': '0x85F5',
  'INTENSITY16_EXTENDED_RANGE_SGIX': '0x85F6',
  'LUMINANCE16_ALPHA16_EXTENDED_RANGE_SGIX': '0x85F7',
  'MIN_LUMINANCE_SGIS': '0x85F8',
  'MAX_LUMINANCE_SGIS': '0x85F9',
  'MIN_INTENSITY_SGIS': '0x85FA',
  'MAX_INTENSITY_SGIS': '0x85FB',
  'POST_TEXTURE_FILTER_BIAS_SGIX': '0x8179',
  'POST_TEXTURE_FILTER_SCALE_SGIX': '0x817A',
  'POST_TEXTURE_FILTER_BIAS_RANGE_SGIX': '0x817B',
  'POST_TEXTURE_FILTER_SCALE_RANGE_SGIX': '0x817C',
  'VERTEX_PRECLIP_SGIX': '0x83EE',
  'VERTEX_PRECLIP_HINT_SGIX': '0x83EF',
  'VERTEX_PRECLIP_SGIX': '0x83EE',
  'VERTEX_PRECLIP_HINT_SGIX': '0x83EF',
  'COLOR_MATRIX_SGI': '0x80B1',
  'COLOR_MATRIX_STACK_DEPTH_SGI': '0x80B2',
  'MAX_COLOR_MATRIX_STACK_DEPTH_SGI': '0x80B3',
  'POST_COLOR_MATRIX_RED_SCALE_SGI': '0x80B4',
  'POST_COLOR_MATRIX_GREEN_SCALE_SGI': '0x80B5',
  'POST_COLOR_MATRIX_BLUE_SCALE_SGI': '0x80B6',
  'POST_COLOR_MATRIX_ALPHA_SCALE_SGI': '0x80B7',
  'POST_COLOR_MATRIX_RED_BIAS_SGI': '0x80B8',
  'POST_COLOR_MATRIX_GREEN_BIAS_SGI': '0x80B9',
  'POST_COLOR_MATRIX_BLUE_BIAS_SGI': '0x80BA',
  'POST_COLOR_MATRIX_ALPHA_BIAS_SGI': '0x80BB',
  'COLOR_TABLE_SGI': '0x80D0',
  'POST_CONVOLUTION_COLOR_TABLE_SGI': '0x80D1',
  'POST_COLOR_MATRIX_COLOR_TABLE_SGI': '0x80D2',
  'PROXY_COLOR_TABLE_SGI': '0x80D3',
  'PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI': '0x80D4',
  'PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI': '0x80D5',
  'COLOR_TABLE_SCALE_SGI': '0x80D6',
  'COLOR_TABLE_BIAS_SGI': '0x80D7',
  'COLOR_TABLE_FORMAT_SGI': '0x80D8',
  'COLOR_TABLE_WIDTH_SGI': '0x80D9',
  'COLOR_TABLE_RED_SIZE_SGI': '0x80DA',
  'COLOR_TABLE_GREEN_SIZE_SGI': '0x80DB',
  'COLOR_TABLE_BLUE_SIZE_SGI': '0x80DC',
  'COLOR_TABLE_ALPHA_SIZE_SGI': '0x80DD',
  'COLOR_TABLE_LUMINANCE_SIZE_SGI': '0x80DE',
  'COLOR_TABLE_INTENSITY_SIZE_SGI': '0x80DF',
  'TEXTURE_COLOR_TABLE_SGI': '0x80BC',
  'PROXY_TEXTURE_COLOR_TABLE_SGI': '0x80BD',
  'UNPACK_CONSTANT_DATA_SUNX': '0x81D5',
  'TEXTURE_CONSTANT_DATA_SUNX': '0x81D6',
  'WRAP_BORDER_SUN': '0x81D4',
  'GLOBAL_ALPHA_SUN': '0x81D9',
  'GLOBAL_ALPHA_FACTOR_SUN': '0x81DA',
  'QUAD_MESH_SUN': '0x8614',
  'TRIANGLE_MESH_SUN': '0x8615',
  'SLICE_ACCUM_SUN': '0x85CC',
  'RESTART_SUN': '0x01',
  'REPLACE_MIDDLE_SUN': '0x02',
  'REPLACE_OLDEST_SUN': '0x03',
  'TRIANGLE_LIST_SUN': '0x81D7',
  'REPLACEMENT_CODE_SUN': '0x81D8',
  'REPLACEMENT_CODE_ARRAY_SUN': '0x85C0',
  'REPLACEMENT_CODE_ARRAY_TYPE_SUN': '0x85C1',
  'REPLACEMENT_CODE_ARRAY_STRIDE_SUN': '0x85C2',
  'REPLACEMENT_CODE_ARRAY_POINTER_SUN': '0x85C3',
  'R1UI_V3F_SUN': '0x85C4',
  'R1UI_C4UB_V3F_SUN': '0x85C5',
  'R1UI_C3F_V3F_SUN': '0x85C6',
  'R1UI_N3F_V3F_SUN': '0x85C7',
  'R1UI_C4F_N3F_V3F_SUN': '0x85C8',
  'R1UI_T2F_V3F_SUN': '0x85C9',
  'R1UI_T2F_N3F_V3F_SUN': '0x85CA',
  'R1UI_T2F_C4F_N3F_V3F_SUN': '0x85CB',
  'PHONG_WIN': '0x80EA',
  'PHONG_HINT_WIN': '0x80EB',
  'FOG_SPECULAR_TEXTURE_WIN': '0x80EC'
};

(function() {
  function convertHexConstants(constants) {
    // Convert hex constants
    for (var name in constants) {
      constants[name] = parseInt(constants[name].substring(2), 16);
    }
  }
  convertHexConstants(desktopGL);
} ());



