/*
 * xmmplayer - mplayer plugin for xmms
 * Copyright (C) 2003 Hyriand - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"
#include "xmmplayer.h"
#include "window.h"

#include <gtk/gtk.h>
#include <xmms/configfile.h>

static GtkWidget *config_win, *vbox, *notebook;

static GtkWidget *xmmplayer_vbox, *options_frame, *options_vbox;
static GtkWidget *path_hbox, *path_label, *mplayer_path, *read_info,
  *fullscreen, *nocache;
static GtkWidget *win_frame, *win_vbox, *use_win, *use_autosize,
  *vw_scale, *use_autoclose;
static GtkWidget *tv_vbox, *tvopts_frame, *tvopts_vbox,
  *tv_c_hbox, *tv_c_label, *tv_command,
  *tv_w_hbox, *tv_w_label, *tv_width, 
  *tv_h_hbox, *tv_h_label, *tv_height;
static GtkWidget *mplayer_vbox, *mplayeropts_frame, *mplayeropts_vbox;
static GtkWidget *nocache, *noninterleaved, *noidx, *idx, *forceidx,
#ifdef LINUX_RTC
  *nortc,
#endif
  *vo_hbox, *vo_label, *vo_text, *ao_hbox, *ao_label, *ao_text;

static GtkWidget *bbox, *ok, *cancel;

void
xmmplayer_write_config (void)
{
  ConfigFile *cfgfile;
  cfgfile = xmms_cfg_open_default_file ();
  xmms_cfg_write_string (cfgfile, "XMMPlayer", "mplayer_path",
			 xmmplayer_config.mplayer_path);
  xmms_cfg_write_string (cfgfile, "XMMPlayer", "vo",
			 xmmplayer_config.vo);
  xmms_cfg_write_string (cfgfile, "XMMPlayer", "ao",
			 xmmplayer_config.ao);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "read_info",
			  xmmplayer_config.read_info);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "fullscreen",
			  xmmplayer_config.fullscreen);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "nocache",
			  xmmplayer_config.nocache);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "noninterleaved",
			  xmmplayer_config.noninterleaved);
  xmms_cfg_write_string (cfgfile, "XMMPlayer", "tv_command",
                          xmmplayer_config.tv_c);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "tv_width",
                      xmmplayer_config.tv_h);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "tv_height",
                      xmmplayer_config.tv_w);
#ifdef LINUX_RTC
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "nortc",
			  xmmplayer_config.nortc);
#endif
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "index", xmmplayer_config.index);

  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "videowin_resize",
			  xmmplayer_config.videowin_resize);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "videowin_visible",
			  xmmplayer_config.videowin_visible);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "videowin_autoclose",
			  xmmplayer_config.videowin_autoclose);
  xmms_cfg_write_boolean (cfgfile, "XMMPlayer", "videowin_scale",
			  xmmplayer_config.videowin_scale);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "videowin_width",
		      xmmplayer_config.videowin_width);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "videowin_height",
		      xmmplayer_config.videowin_height);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "videowin_x",
		      xmmplayer_config.videowin_x);
  xmms_cfg_write_int (cfgfile, "XMMPlayer", "videowin_y",
		      xmmplayer_config.videowin_y);

  xmms_cfg_write_default_file (cfgfile);
  xmms_cfg_free (cfgfile);
}

static void
configure_ok (GtkWidget * w, gpointer data)
{
  xmmplayer_config.read_info =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (read_info));
  xmmplayer_config.fullscreen =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fullscreen));
  xmmplayer_config.nocache =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nocache));
  g_free (xmmplayer_config.mplayer_path);
  xmmplayer_config.mplayer_path =
    g_strdup (gtk_entry_get_text (GTK_ENTRY (mplayer_path)));
  g_free (xmmplayer_config.vo);
  xmmplayer_config.vo =
    g_strdup (gtk_entry_get_text (GTK_ENTRY (vo_text)));
  g_free (xmmplayer_config.ao);
  xmmplayer_config.ao =
    g_strdup (gtk_entry_get_text (GTK_ENTRY (ao_text)));
  xmmplayer_config.noninterleaved =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (noninterleaved));
  g_free (xmmplayer_config.tv_c);
  xmmplayer_config.tv_c = g_strdup(gtk_entry_get_text(GTK_ENTRY (tv_command)));
  xmmplayer_config.tv_w = atoi(gtk_entry_get_text(GTK_ENTRY (tv_width)));
  xmmplayer_config.tv_h = atoi(gtk_entry_get_text(GTK_ENTRY (tv_height)));
#ifdef LINUX_RTC
  xmmplayer_config.nortc =
    !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nortc));
#endif
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (idx)))
    xmmplayer_config.index = 1;
  else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (forceidx)))
    xmmplayer_config.index = 2;
  else
    xmmplayer_config.index = 0;

  xmmplayer_config.videowin_visible =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_win));
  xmmplayer_config.videowin_autoclose =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_autoclose));
  xmmplayer_config.videowin_resize =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_autosize));
  xmmplayer_config.videowin_scale =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (vw_scale));

  xmmplayer_write_config ();
  gtk_widget_destroy (config_win);
}

static void
configure_cancel (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (config_win);
}

void
xmmplayer_configure (void)
{
  if (config_win != NULL)
    {
      gdk_window_raise (config_win->window);
      return;
    }

  config_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_container_set_border_width (GTK_CONTAINER (config_win), 10);
  gtk_window_set_title (GTK_WINDOW (config_win), "XMMPlayer Config");
  gtk_window_set_policy (GTK_WINDOW (config_win), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW (config_win), GTK_WIN_POS_MOUSE);;
  gtk_signal_connect (GTK_OBJECT (config_win), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &config_win);

  vbox = gtk_vbox_new (FALSE, 10);

  notebook = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);

  xmmplayer_vbox = gtk_vbox_new (FALSE, 5);
  options_frame = gtk_frame_new ("Options:");
  gtk_container_set_border_width (GTK_CONTAINER (options_frame), 5);
  options_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (options_vbox), 5);

  path_hbox = gtk_hbox_new (FALSE, 5);
  path_label = gtk_label_new ("Path to mplayer:");
  gtk_box_pack_start (GTK_BOX (path_hbox), path_label, FALSE, FALSE, 0);
  mplayer_path = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (mplayer_path),
		      xmmplayer_config.mplayer_path);
  gtk_box_pack_start (GTK_BOX (path_hbox), mplayer_path, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (options_vbox), path_hbox, FALSE, FALSE, 0);

  read_info =
    gtk_check_button_new_with_label
    ("Read info when requested (performace decrease)");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (read_info),
				xmmplayer_config.read_info);
  gtk_box_pack_start (GTK_BOX (options_vbox), read_info, FALSE, FALSE, 0);

  fullscreen = gtk_check_button_new_with_label ("Use Full-Screen by default");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fullscreen),
				xmmplayer_config.fullscreen);
  gtk_box_pack_start (GTK_BOX (options_vbox), fullscreen, FALSE, FALSE, 0);

  gtk_container_add (GTK_CONTAINER (options_frame), options_vbox);
  gtk_box_pack_start (GTK_BOX (xmmplayer_vbox), options_frame, TRUE, TRUE, 0);


  win_frame = gtk_frame_new ("XMMS skinned video window:");
  gtk_container_set_border_width (GTK_CONTAINER (win_frame), 5);
  win_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (win_vbox), 5);

  use_win = gtk_check_button_new_with_label ("Use XMMS skinned video window");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_win),
				xmmplayer_config.videowin_visible);
  gtk_box_pack_start (GTK_BOX (win_vbox), use_win, FALSE, FALSE, 0);

  use_autoclose = gtk_check_button_new_with_label ("Autoclose skinned window");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_autoclose),
				xmmplayer_config.videowin_autoclose);
  gtk_box_pack_start (GTK_BOX (win_vbox), use_autoclose, FALSE, FALSE, 0);

  use_autosize = gtk_check_button_new_with_label ("Auto-size video window");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_autosize),
				xmmplayer_config.videowin_resize);
  gtk_box_pack_start (GTK_BOX (win_vbox), use_autosize, FALSE, FALSE, 0);

  vw_scale = gtk_check_button_new_with_label ("Scale video in video window");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vw_scale),
				xmmplayer_config.videowin_scale);
  gtk_box_pack_start (GTK_BOX (win_vbox), vw_scale, FALSE, FALSE, 0);

  gtk_container_add (GTK_CONTAINER (win_frame), win_vbox);
  gtk_box_pack_start (GTK_BOX (xmmplayer_vbox), win_frame, TRUE, TRUE, 0);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), xmmplayer_vbox,
			    gtk_label_new ("XMMPlayer"));


  mplayer_vbox = gtk_vbox_new (FALSE, 5);
  mplayeropts_frame = gtk_frame_new ("MPlayer options:");
  gtk_container_set_border_width (GTK_CONTAINER (mplayeropts_frame), 5);
  mplayeropts_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (mplayeropts_vbox), 5);

  vo_hbox = gtk_hbox_new (FALSE, 5);
  vo_label = gtk_label_new("Override video output device:");
  gtk_box_pack_start (GTK_BOX (vo_hbox), vo_label, FALSE, FALSE, 0);
  vo_text = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY (vo_text),
		      xmmplayer_config.vo);
  gtk_box_pack_start (GTK_BOX (vo_hbox), vo_text, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), vo_hbox, FALSE, FALSE, 0);

  ao_hbox = gtk_hbox_new (FALSE, 5);
  ao_label = gtk_label_new("Override audio output device:");
  gtk_box_pack_start (GTK_BOX (ao_hbox), ao_label, FALSE, FALSE, 0);
  ao_text = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY (ao_text),
		      xmmplayer_config.ao);
  gtk_box_pack_start (GTK_BOX (ao_hbox), ao_text, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), ao_hbox, FALSE, FALSE, 0);
  
  nocache =
    gtk_check_button_new_with_label
    ("Disable mplayer cache (for broken AVI)");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (nocache),
				xmmplayer_config.nocache);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), nocache, FALSE, FALSE, 0);

  noninterleaved =
    gtk_check_button_new_with_label
    ("Force usage of non-interleaved .AVI parser");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (noninterleaved),
				xmmplayer_config.noninterleaved);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), noninterleaved, FALSE,
		      FALSE, 0);
  noidx =
    gtk_radio_button_new_with_label (NULL,
				     "Don't rebuild index of AVI files");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (noidx),
				xmmplayer_config.index == 0);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), noidx, FALSE, FALSE, 0);

  idx =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (noidx)),
				     "Rebuild index of AVI files");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (idx),
				xmmplayer_config.index == 1);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), idx, FALSE, FALSE, 0);

  forceidx =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (noidx)),
				     "Force rebuild index of AVI files");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (forceidx),
				xmmplayer_config.index == 2);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), forceidx, FALSE, FALSE, 0);

#ifdef LINUX_RTC
  nortc = gtk_check_button_new_with_label ("Use the Linux RTC for timing");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (nortc),
				!xmmplayer_config.nortc);
  gtk_box_pack_start (GTK_BOX (mplayeropts_vbox), nortc, FALSE, FALSE, 0);
#endif

  gtk_container_add (GTK_CONTAINER (mplayeropts_frame), mplayeropts_vbox);
  gtk_box_pack_start (GTK_BOX (mplayer_vbox), mplayeropts_frame, TRUE, TRUE,
		      0);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), mplayer_vbox,
			    gtk_label_new ("MPlayer"));


  tv_vbox = gtk_vbox_new (FALSE, 5);
  tvopts_frame = gtk_frame_new ("TV-mode options:");
  gtk_container_set_border_width (GTK_CONTAINER (tvopts_frame), 5);
  tvopts_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (tvopts_vbox), 5);

  tv_c_hbox = gtk_hbox_new (FALSE, 5);
  tv_c_label = gtk_label_new ("TV-mode driver:");
  gtk_box_pack_start (GTK_BOX (tv_c_hbox), tv_c_label, FALSE, FALSE, 0);
  tv_command = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (tv_command),
		      xmmplayer_config.tv_c);
  gtk_box_pack_start (GTK_BOX (tv_c_hbox), tv_command, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (tvopts_vbox), tv_c_hbox, FALSE, FALSE, 0);
  
  tv_w_hbox = gtk_hbox_new (FALSE, 5);
  tv_w_label = gtk_label_new ("TV-mode width:");
  gtk_box_pack_start (GTK_BOX (tv_w_hbox), tv_w_label, FALSE, FALSE, 0);
  tv_width = gtk_entry_new ();
  gchar *tv_w_tmp = g_strdup_printf("%i", xmmplayer_config.tv_w);
  gtk_entry_set_text (GTK_ENTRY (tv_width), tv_w_tmp);
  g_free(tv_w_tmp);
  gtk_box_pack_start (GTK_BOX (tv_w_hbox), tv_width, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (tvopts_vbox), tv_w_hbox, FALSE, FALSE, 0);

  tv_h_hbox = gtk_hbox_new (FALSE, 5);
  tv_h_label = gtk_label_new ("TV-mode height:");
  gtk_box_pack_start (GTK_BOX (tv_h_hbox), tv_h_label, FALSE, FALSE, 0);
  tv_height = gtk_entry_new ();
  gchar *tv_h_tmp = g_strdup_printf("%i", xmmplayer_config.tv_h);
  gtk_entry_set_text (GTK_ENTRY (tv_height), tv_h_tmp);
  g_free(tv_h_tmp);
  gtk_box_pack_start (GTK_BOX (tv_h_hbox), tv_height, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (tvopts_vbox), tv_h_hbox, FALSE, FALSE, 0);
  
  gtk_container_add (GTK_CONTAINER (tvopts_frame), tvopts_vbox);
  gtk_box_pack_start (GTK_BOX (tv_vbox), tvopts_frame, TRUE, TRUE, 0);
  
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tv_vbox,
			    gtk_label_new ("TV-mode"));


  bbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 5);
  gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);

  ok = gtk_button_new_with_label ("Ok");
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (configure_ok), NULL);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), ok, TRUE, TRUE, 0);

  cancel = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked",
		      GTK_SIGNAL_FUNC (configure_cancel), NULL);
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), cancel, TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (config_win), vbox);
  gtk_widget_show_all (config_win);
  gtk_widget_grab_default (ok);
}
