#include "bcpan.h"
#include "bcpixmap.h"
#include "bcpopup.h"
#include "bcresources.h"
#include "clip.h"
#include "colors.h"
#include "fonts.h"
#include "rotateframe.h"
#include "units.h"
#include "vframe.h"

#include <math.h>
#include <string.h>

#define PAN_DN 0
#define PAN_HI 1

BC_Pan::BC_Pan(int x, 
		int y, 
		int virtual_r, 
		float maxvalue, 
		int total_values, 
		int *value_positions, 
		int stick_x, 
		int stick_y,
		float *values)
 : BC_SubWindow(x, y, -1, -1, -1)
{
	this->virtual_r = virtual_r;
	this->maxvalue = maxvalue;
	this->total_values = total_values;
	this->values = new float[total_values];
	memcpy(this->values, values, sizeof(float) * total_values);
	this->value_positions = new int[total_values];
	memcpy(this->value_positions, value_positions, sizeof(int) * total_values);
	this->value_x = new int[total_values];
	this->value_y = new int[total_values];
	this->stick_x = stick_x;
	this->stick_y = stick_y;
	get_channel_positions();
	if(stick_x < 0 || stick_y < 0)
		calculate_stick_position(total_values, 
			value_positions, 
			values, 
			maxvalue, 
			virtual_r,
			this->stick_x,
			this->stick_y);
	highlighted = 0;
	popup = 0;
	active = 0;
}

BC_Pan::~BC_Pan()
{
//printf("BC_Pan::~BC_Pan 1\n");
	delete [] values;
//printf("BC_Pan::~BC_Pan 1\n");
	delete [] value_positions;
//printf("BC_Pan::~BC_Pan 1\n");
	delete [] value_x;
//printf("BC_Pan::~BC_Pan 1\n");
	delete [] value_y;
//printf("BC_Pan::~BC_Pan 1\n");
	delete picon_bg[PAN_DN];
//printf("BC_Pan::~BC_Pan 1\n");
	delete picon_bg[PAN_HI];
//printf("BC_Pan::~BC_Pan 1\n");
	delete popup_bg;
//printf("BC_Pan::~BC_Pan 1\n");
	delete handle_pixmap;
//printf("BC_Pan::~BC_Pan 1\n");
	if(popup) delete popup;
//printf("BC_Pan::~BC_Pan 1\n");
	delete temp_frame;
//printf("BC_Pan::~BC_Pan 1\n");
	delete rotater;
//printf("BC_Pan::~BC_Pan 2\n");
}

int BC_Pan::initialize()
{
	picon_bg[PAN_DN] = new BC_Pixmap(parent_window, 
		get_resources()->pan_dn, 
		PIXMAP_OPAQUE);
	picon_bg[PAN_HI] = new BC_Pixmap(parent_window, 
		get_resources()->pan_hi, 
		PIXMAP_OPAQUE);
	popup_bg = new BC_Pixmap(parent_window, 
		get_resources()->pan_popup, 
		PIXMAP_OPAQUE);
	handle_pixmap = new BC_Pixmap(parent_window, 
		get_resources()->pan_stick, 
		PIXMAP_ALPHA);


	w = picon_bg[PAN_DN]->get_w();
	h = picon_bg[PAN_DN]->get_h();
	BC_SubWindow::initialize();
	temp_frame = new VFrame(0, 
		get_resources()->pan_channel->get_w(),
		get_resources()->pan_channel->get_h(),
		get_resources()->pan_channel->get_color_model());
	rotater = new RotateFrame(1,
		get_resources()->pan_channel->get_w(),
		get_resources()->pan_channel->get_h());
	draw();
	return 0;
}

int BC_Pan::button_press_event()
{
	if(is_event_win())
	{
		activate();
		x_origin = get_cursor_x();
		y_origin = get_cursor_y();
		stick_x_origin = stick_x;
		stick_y_origin = stick_y;
		draw_popup();
		return 1;
	}
	return 0;
}

int BC_Pan::cursor_motion_event()
{
	if(active)
	{
		stick_x = stick_x_origin + get_cursor_x() - x_origin;
		stick_y = stick_y_origin + get_cursor_y() - y_origin;
		CLAMP(stick_x, 0, virtual_r * 2);
		CLAMP(stick_y, 0, virtual_r * 2);
		stick_to_values();
		draw_popup();
		handle_event();
		return 1;
	}
	return 0;
}

int BC_Pan::button_release_event()
{
	if(active)
	{
		deactivate();
		draw();
		return 1;
	}
	return 0;
}

int BC_Pan::cursor_enter_event()
{
	if(is_event_win() && !highlighted)
	{
		highlighted = 1;
		draw();
	}
	return 0;
}

int BC_Pan::cursor_leave_event()
{
	if(highlighted)
	{
		highlighted = 0;
		draw();
	}
	return 0;
}



int BC_Pan::deactivate()
{
	if(popup) delete popup;
	popup = 0;
	active = 0;
	return 0;
}

int BC_Pan::activate()
{
	int x, y;
	Window tempwin;

	active = 1;
	XTranslateCoordinates(top_level->display, 
			win, 
			top_level->rootwin, 
			0, 
			0, 
			&x, 
			&y, 
			&tempwin);

	x -= (popup_bg->get_w() - get_w()) / 2;
	y -= (popup_bg->get_h() - get_h()) / 2;
	popup = new BC_Popup(this, 
				x, 
				y, 
				popup_bg->get_w(), 
				popup_bg->get_h(), 
				0, 
				0, 
				popup_bg);
	flush();
	return 0;
}

int BC_Pan::update(int x, int y)
{
	stick_x = x;
	stick_y = y;
	stick_to_values();
	draw();
	return 0;
}

void BC_Pan::draw_popup()
{
	popup->draw_background(0, 0, popup->get_w(), popup->get_h());
	
	int x1, y1;
	float rotate_angle;
	float scale = (float)(popup->get_w() - 
		get_resources()->pan_channel->get_w()) / 
		(virtual_r * 2);
	set_color(YELLOW);
	set_font(SMALLFONT);
	for(int i = 0; i < total_values; i++)
	{
		x1 = (int)(value_x[i] * scale);
		y1 = (int)(value_y[i] * scale);
		rotate_angle = value_positions[i];
		rotate_angle = -rotate_angle;
		while(rotate_angle < 0) rotate_angle += 360;
		rotater->rotate(temp_frame, 
			get_resources()->pan_channel, 
			rotate_angle, 
			0);
		BC_Pixmap *temp_pixmap = new BC_Pixmap(popup, 
			temp_frame, 
			PIXMAP_ALPHA);
		popup->draw_pixmap(temp_pixmap, x1, y1);
		delete temp_pixmap;

		char string[BCTEXTLEN];
		float value = values[i] + 0.005;
		sprintf(string, "%.1f", value);
		popup->draw_text(x1, y1 + get_text_height(SMALLFONT), string);
	}
	
	x1 = (int)(stick_x * scale);
	y1 = (int)(stick_y * scale);
	popup->draw_pixmap(handle_pixmap, x1, y1);
	popup->flash();
}

#define PICON_W 6
#define PICON_H 6

void BC_Pan::draw()
{
	draw_pixmap(picon_bg[highlighted ? PAN_HI : PAN_DN]);
	get_channel_positions();

// draw channels
	int x1, y1, x2, y2, w, h, j;
	float scale = (float)(get_w() - PICON_W) / (virtual_r * 2);
	set_color(RED);

	for(int i = 0; i < total_values; i++)
	{
// printf("BC_Pan::draw 1 %d %d %d %d\n", 
// 	i, 
// 	value_positions[i], 
// 	value_x[i], 
// 	value_y[i]);
		x1 = (int)(value_x[i] * scale);
		y1 = (int)(value_y[i] * scale);
//printf("BC_Pan::draw 2 %d %d\n", x1, y1);
		CLAMP(x1, 0, get_w() - PICON_W);
		CLAMP(y1, 0, get_h() - PICON_H);
		draw_box(x1, y1, PICON_W, PICON_H);
	}

// draw stick
 	set_color(GREEN);
 	x1 = (int)(stick_x * scale);
 	y1 = (int)(stick_y * scale);

//printf("BC_Pan::draw 2 %d %d\n", x1, y1);
	CLAMP(x1, 0, get_w() - PICON_W);
	CLAMP(y1, 0, get_h() - PICON_H);
 	x2 = x1 + PICON_W;
 	y2 = y1 + PICON_H;
 	draw_line(x1, y1, x2, y2);
 	draw_line(x2, y1, x1, y2);

	flash();
}

int BC_Pan::stick_to_values()
{
// find shortest distance to a channel
	float shortest = 2 * virtual_r, test_distance;
	int i;

	for(i = 0; i < total_values; i++)
	{
		if((test_distance = distance(stick_x, value_x[i], stick_y, value_y[i])) < shortest)
			shortest = test_distance;
	}

// get values for channels
	if(shortest == 0)
	{
		for(i = 0; i < total_values; i++)
		{
			if(distance(stick_x, value_x[i], stick_y, value_y[i]) == shortest)
				values[i] = maxvalue;
			else
				values[i] = 0;
		}
	}
	else
	{
		for(i = 0; i < total_values; i++)
		{
			values[i] = shortest;
			values[i] -= (float)(distance(stick_x, value_x[i], stick_y, value_y[i]) - shortest);
			if(values[i] < 0) values[i] = 0;
			values[i] = values[i] / shortest * maxvalue;
		}
	}

	for(i = 0; i < total_values; i++)
	{
		values[i] = Units::quantize10(values[i]);
	}
	return 0;
}

float BC_Pan::distance(int x1, int x2, int y1, int y2)
{
	return hypot(x2 - x1, y2 - y1);
}

int BC_Pan::change_channels(int new_channels, int *value_positions)
{
	delete values;
	delete this->value_positions;
	delete value_x;
	delete value_y;
	
	values = new float[new_channels];
	this->value_positions = new int[new_channels];
	value_x = new int[new_channels];
	value_y = new int[new_channels];
	total_values = new_channels;
	for(int i = 0; i < new_channels; i++)
	{
		this->value_positions[i] = value_positions[i];
	}
	get_channel_positions();
	stick_to_values();
	draw();
	return 0;
}

int BC_Pan::get_channel_positions()
{
	for(int i = 0; i < total_values; i++)
	{
		rdtoxy(value_x[i], value_y[i], value_positions[i], virtual_r);
	}
	return 0;
}

int BC_Pan::get_total_values()
{
	return total_values;
}

float BC_Pan::get_value(int channel)
{
	return values[channel];
}

int BC_Pan::get_stick_x() 
{ 
	return stick_x; 
}

int BC_Pan::get_stick_y() 
{ 
	return stick_y; 
}

float* BC_Pan::get_values()
{
	return values;
}

int BC_Pan::rdtoxy(int &x, int &y, int a, int virtual_r)
{
	float radians = (float)a / 360 * 2 * M_PI;

	y = (int)(sin(radians) * virtual_r);
	x = (int)(cos(radians) * virtual_r);
	x += virtual_r;
	y = virtual_r - y;
	return 0;
}

void BC_Pan::calculate_stick_position(int total_values, 
	int *value_positions, 
	float *values, 
	float maxvalue, 
	int virtual_r,
	int &stick_x,
	int &stick_y)
{
// use highest value as location of stick
	float highest_value = 0;
	int angle = 0;
	int i, j;

	for(i = 0; i < total_values; i++)
	{
		if(values[i] > highest_value)
		{
			highest_value = values[i];
			angle = value_positions[i];
		}
	}

	rdtoxy(stick_x, stick_y, angle, virtual_r);
}

