/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class ResourceToI18n {

    /**
     * 
     */
    public static void main(String[] argv)
    {
	if (argv.length != 2) {
	    System.err.println("usage: ResourceToI18n resourcefile i18nfile");
	    System.exit(1);

	}

	try {
	    System.out.println(argv[0] + " -> " + argv[1]);
	    write(argv[0], argv[1]);
	}
	catch (IOException e) {
	    System.err.println("Error: " + e.getMessage());
	    System.exit(1);
	}
    }

    public static void write(String source, String dest)
	throws IOException
    {
	Properties props = new Properties();

	FileInputStream in = new FileInputStream(new File(source));
	props.load(in);
	in.close();

	Helper.writeI18nFile(dest, props);
    }

}

    
