/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.XNap;
import xnap.util.FileHelper;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;

public class AboutDialog extends DefaultDialog {
    
    //--- Data field(s) ---

    private static AboutDialog me = null;

    //--- Constructor(s) ---
    
    private AboutDialog()
    {
	super(BUTTON_CLOSE);

	// about tab
	JPanel jpAbout = new JPanel();
	jpAbout.setBackground(Color.white);
	jpAbout.setLayout(new BorderLayout());
	JLabel logoLabel = new JLabel(XNapFrame.getImage("xnap_logo.png"));
	logoLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
	jpAbout.add(logoLabel, "North");
	JTextArea jtaAbout= new JTextArea(5, 40);
	jtaAbout.setEditable (false);
	jtaAbout.setBorder(new EmptyBorder(5, 5, 5, 5));
	jpAbout.add(jtaAbout, "Center");
	JScrollPane about = new JScrollPane(jpAbout);
	showFile(jtaAbout, "README", XNap.tr("File README not found!"));

	// authors tab
	JTextArea jtaAuthors = new JTextArea(15, 40);
	jtaAuthors.setBorder(new EmptyBorder(5, 5, 5, 5));
	jtaAuthors.setEditable (false);
	JScrollPane authors = new JScrollPane(jtaAuthors);
	showFile(jtaAuthors, "AUTHORS", XNap.tr("File AUTHORS not found!"));

	// license tab
	JTextArea jtaLicense = new JTextArea(15, 40);
	jtaLicense.setBorder(new EmptyBorder(5, 5, 5, 5));
	jtaLicense.setEditable (false);
        jtaLicense.setFont(new Font("Monospaced", Font.PLAIN, 12));
	JScrollPane license = new JScrollPane(jtaLicense);
	showFile(jtaLicense, "COPYING", 
		 XNap.tr("File COPYING not found!\n\nXNap is GPLed :-)."));

	JTabbedPane pane = new JTabbedPane();
        pane.setPreferredSize(new Dimension(600, 300));
	pane.addTab(XNap.tr("About"), about);
	pane.addTab(XNap.tr("Authors"), authors);
	pane.addTab(XNap.tr("License Agreement"), license);
	
        setTitle(XNap.tr("About XNap", 0, 1) + XNap.VERSION);
	getMainPanel().setLayout(new BorderLayout());
	getMainPanel().add(pane, BorderLayout.CENTER);
        pack();
    }

    // --- Methods ---

    public static void showDialog(Component c)
    {
	if (me == null) {
	    me = new AboutDialog();
	}
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.show();
    }

    /* loads text from file and appends it to given JTextArea  */
    private void showFile(final JTextArea jta, final String filename, 
			  final String altText)
    {
	(new Thread("LoadFile " + filename)
	    {
		public void run()
		{
		    InputStream s = FileHelper.getResourceAsStream(filename);

		    if (s == null) {
			jta.append(altText);
			return;
		    }

		    try {
			BufferedReader in = new BufferedReader
			    (new InputStreamReader(s));
			
			while (in.ready()) {
			    jta.append(in.readLine() + "\n");
			}
		    }
		    catch(IOException io) {
		    }
		}
	    }
	 ).start();
    }

}
