/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;
import xnap.util.SearchFilter;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import org.apache.log4j.Logger;

public class OptionsBox extends Box
{

    //--- Constant(s) ---

    public static final int UNIT_BYTES = 0;
    public static final int UNIT_KILO_BYTES = 1;
    public static final int UNIT_MEGA_BYTES = 2;
    public static final int UNIT_GIGA_BYTES = 3;
    public static final String UNITS[] = { XNap.tr("B"), XNap.tr("KB"), XNap.tr("MB"), XNap.tr("GB") };

    //--- Data field(s) ---

    protected JComboBox jcCompare;
    protected JComboBox jcBitrate;
    protected JComboBox jcFilesizeCompare;
    protected ValidatedTextField jtFilesize;
    protected JComboBox jcUnits;

    protected int currentUnit = UNIT_MEGA_BYTES;

    private static Logger logger = Logger.getLogger(OptionsBox.class);

    //--- Constructor(s) ---

    public OptionsBox(int axis)
    {
	super(axis);
	initialize();
    }

    //--- Method(s) ---

    private void initialize() 
    {
	add(new JLabel(XNap.tr("Bitrate", 0, 1)));
	jcCompare = new JComboBox(SearchFilter.COMPARES);
	jcCompare.setMaximumSize(jcCompare.getPreferredSize());
	add(jcCompare);
	jcBitrate = new JComboBox(SearchFilter.BITRATES);
	jcBitrate.setMaximumSize(jcBitrate.getPreferredSize());
	add(jcBitrate);

	add(Box.createHorizontalStrut(10));

	add(new JLabel(XNap.tr("Filesize", 1, 1)));

	jcFilesizeCompare = new JComboBox(SearchFilter.COMPARES);
	jcFilesizeCompare.setMaximumSize(jcFilesizeCompare.getPreferredSize());
	add(jcFilesizeCompare);
	
	jtFilesize = new ValidatedTextField
	    ("", 5, ValidatedTextField.NUMBERS_INT);
	jtFilesize.setMaximumSize
	    (new Dimension(jtFilesize.getPreferredSize().width,
			   jtFilesize.getMaximumSize().height));
	add(jtFilesize);

	jcUnits = new JComboBox(UNITS);
	jcUnits.setMaximumSize(jcUnits.getPreferredSize());
	jcUnits.setSelectedIndex(currentUnit);
	jcUnits.addActionListener(new UnitSelectionListener());
	add(jcUnits);

	add(Box.createHorizontalGlue());
    }

    public int getBitrateCompare()
    {
	return jcCompare.getSelectedIndex();
    }

    public void setBitrateCompare(int index)
    {
	jcCompare.setSelectedIndex(index);
    }

    public int getBitrate()
    {
	return SearchFilter.getBitrateFromIndex(jcBitrate.getSelectedIndex());
    }
    
    public void setBitrate(int index)
    {
	jcBitrate.setSelectedIndex(index);
    }

    public int getFilesizeCompare()
    {
	return jcFilesizeCompare.getSelectedIndex();
    }
    
    /**
     * Enables or disables the bitrate and the bitrate compare comboboxes.
     */
    public void setBitrateEnabled(boolean enabled)
    {
	jcCompare.setEnabled(enabled);
	jcBitrate.setEnabled(enabled);
    }

    public boolean isBitrateEnabled()
    {
	return jcCompare.isEnabled();
    }

    public void setFilesizeCompare(int index)
    {
	jcFilesizeCompare.setSelectedIndex(index);
    }

    /**
     * Returns filesize in bytes.
     */
    public int getFilesize()
    {
	int size = jtFilesize.getIntValue();
	for (int i = 0; i < currentUnit; i++) {
	    size *= 1024;
	}
	return size;
    }
    
    public JTextField getFilesizeTextField()
    {
	return jtFilesize;
    }

    /**
     * @param size is exptected to be in bytes, the units combobox is set to
     * bytes.
     */
    public void setFilesize(long size)
    {
	jcUnits.setSelectedIndex(UNIT_BYTES);
	jtFilesize.setText(size + "");
    }

    /**
     * Changes value of textfield if unit is changed.
     */
    protected class UnitSelectionListener implements ActionListener
    {
	public void actionPerformed(ActionEvent e)
	{
	    int newUnit = jcUnits.getSelectedIndex();
	    if (newUnit <= currentUnit) {
		int value = jtFilesize.getIntValue();
		for (int i = newUnit; i < currentUnit; i++) {
		    value *= 1024;
		}
		jtFilesize.setText(value + "");
	    }
	    else {
		jtFilesize.setText("");
	    }
	    currentUnit = newUnit;
	}
    }
}
