/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.DirectoryPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.util.GUIHelper;
import xnap.gui.XNapFrame;
import xnap.util.SearchFilter;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class MediaDownloadDirPanel extends AbstractPreferencesPanel 
{

    //--- Data field(s) ---

    private MyDirectoryPanel dtfDir;
    private JComboBox mediatypes;
    private MyTableModel mtm;
    private JTable jta;
    private String[] types = new String[SearchFilter.media.length - 1];

    //--- Constructor(s) ---

    public MediaDownloadDirPanel()
    {
	setLayout(new GridBagLayout());

	// Multiple Download Directory list
	System.arraycopy(SearchFilter.media, 1, types, 0, types.length);

	// directory input field
	Box bxTop = new Box(BoxLayout.X_AXIS);
	mediatypes = new JComboBox(types);
	mediatypes.setToolTipText(GUIHelper.tt(XNap.tr("Choose the mediatype you would like to set a download directory for.")));
	mediatypes.addActionListener(new ComboListener());
	bxTop.add(mediatypes);
	dtfDir = new MyDirectoryPanel("", 20); 
	bxTop.add(dtfDir);
	JButton jbReset = new JButton(new ResetAction());
	jbReset.setMargin(new Insets(1, 1, 1, 1));
	bxTop.add(jbReset, BorderLayout.EAST);

	// directory table
	mtm = new MyTableModel();
	jta = mtm.createJTable();
	ListSelectionModel model = jta.getSelectionModel();
	model.addListSelectionListener(new TableListener());
	model.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	// set the height right
	jta.setPreferredScrollableViewportSize
	    (new Dimension(0, (SearchFilter.media.length - 1) 
			   * jta.getRowHeight()));

	// panel
	GridBagHelper.add(this, bxTop);
	GridBagHelper.addPanel(this, new JScrollPane(jta));
    }

    public void adjustWidth()
    {
	mtm.setColumnWidth(MyTableModel.MEDIA_TYPE, mediatypes.getWidth());
	mtm.setColumnWidth(MyTableModel.DOWNLOAD_DIR,
			   jta.getWidth() - mediatypes.getWidth());
	jta.doLayout();
    }

    public void apply() 
    {
	for (int i = 0; i < types.length; i++) {
	    prefs.setMediaTypeDownloadDir
		(types[i], (String)mtm.get(i, mtm.DOWNLOAD_DIR));
	}
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle()
    {
	return XNap.tr("Advanced");
    }

    private class MyTableModel extends AbstractDynamicTableModel
    {
	//--- Data field(s) ---
	
	public static final int MEDIA_TYPE = 0;
	public static final int DOWNLOAD_DIR = 1;
	
	private Column columns[] = new Column[] {
	    new Column(XNap.tr("Mediatype"), String.class),
	    new Column(XNap.tr("Download Directory"), String.class),
	};

	private String[] directories = new String[SearchFilter.media.length -1];

	//--- Constructor(s) ---

	public MyTableModel() 
	{
	    initialize();
	    setColumns(columns);
	    fireTableDataChanged();
	}

	//--- Method(s) ---

	private void initialize()
	{
	    for (int i = 0; i < types.length && i < SearchFilter.media.length 
		     - 1; i++) {
		directories[i] = 
		    prefs.getMediaTypeDownloadDir((String)SearchFilter.media[i + 1]);
	    }
	}

	public Object get(int i, int j) 
	{
	    if (j == MEDIA_TYPE) {
		return types[i];
	    }
	    else {
		return directories[i];
	    }
        }

	public String getTableName()
	{
	    return "";
	}

	public void setColumnWidth(int i, int width)
	{
	    columns[i].setPreferredWidth(width);
	    columns[i].setWidth(width);
	}

	public int mapFromIndex(int index)
	{
	    return revIndexes[index];
	}

	public int getRowCount() 
	{
	    return types.length;
	}

	public void set(String dir, int i, int j)
	{
	    if (j != DOWNLOAD_DIR)
		return;
	    directories[i] = dir;
	    fireTableRowsUpdated(i, i);
	}
    }

    protected class ComboListener implements ActionListener
    {
	public void actionPerformed(ActionEvent e) 
	{
	    int index = mtm.mapFromIndex(mediatypes.getSelectedIndex());
	    jta.setRowSelectionInterval(index, index);
	}
    }

    protected class TableListener implements ListSelectionListener
    {
	public void valueChanged(ListSelectionEvent e)
	{
	    int index = jta.getSelectedRow();
	    if (index != -1) {
		mediatypes.setSelectedIndex(mtm.mapToIndex(index));
		String dir = (String)mtm.get(index, mtm.DOWNLOAD_DIR);
		dtfDir.setDirectory(dir);
	    }
	}
       
    }

    private class MyDirectoryPanel extends DirectoryPanel
    {
	public MyDirectoryPanel(String text, int size) 
	{
	    super(text, size);
	    EnterAction ea = new EnterAction();
	    KeyStroke k = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
	    getTextField().getInputMap().put(k, ea);
	    getTextField().getActionMap().put(ea, ea);
	}
	
	public void directorySelected(String dir)
	{
	    int i = mediatypes.getSelectedIndex();
	    mtm.set(dir, i, MyTableModel.DOWNLOAD_DIR);
	}

	private class EnterAction extends AbstractAction
	{
	    public void actionPerformed(ActionEvent event)
	    {
		directorySelected(getDirectory());
	    }
	}
    }

    private class ResetAction extends AbstractAction
    {
	public ResetAction()
	{
	    putValue(Action.SMALL_ICON, XNapFrame.getSmallIcon("undo.png"));
	    putValue(Action.SHORT_DESCRIPTION, 
		     XNap.tr("Reset media directories"));
	    putValue(Action.MNEMONIC_KEY, new Integer('R'));
	}

	public void actionPerformed(ActionEvent event)
	{
	    for (int i = 0; i < types.length; i++) {
		mtm.set("", i, mtm.DOWNLOAD_DIR);
	    }
	}
    }

}
